/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.tractracadapter.impl;

import com.sap.sailing.domain.base.RaceDefinition;
import com.sap.sailing.domain.base.Regatta;
import com.sap.sailing.domain.tracking.DynamicTrackedRegatta;
import com.sap.sailing.domain.tracking.RaceHandle;
import com.sap.sailing.domain.tracking.RaceTracker;
import com.sap.sailing.domain.tractracadapter.DomainFactory;
import com.tractrac.model.lib.api.event.IRace;

public class RaceHandleImpl
implements RaceHandle {
    private final IRace tractracRace;
    private final DomainFactory domainFactory;
    private final DynamicTrackedRegatta trackedRegatta;
    private final RaceTracker raceTracker;

    public RaceHandleImpl(DomainFactory domainFactory, IRace tractracRace, DynamicTrackedRegatta trackedRegatta, RaceTracker raceTracker) {
        this.domainFactory = domainFactory;
        this.tractracRace = tractracRace;
        this.trackedRegatta = trackedRegatta;
        this.raceTracker = raceTracker;
    }

    public Regatta getRegatta() {
        return this.trackedRegatta.getRegatta();
    }

    public RaceDefinition getRace() {
        return this.domainFactory.getAndWaitForRaceDefinition(this.tractracRace.getId());
    }

    public DynamicTrackedRegatta getTrackedRegatta() {
        return this.trackedRegatta;
    }

    public RaceTracker getRaceTracker() {
        return this.raceTracker;
    }

    public RaceDefinition getRace(long timeoutInMilliseconds) {
        return this.domainFactory.getAndWaitForRaceDefinition(this.tractracRace.getId(), timeoutInMilliseconds);
    }
}

