/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.security.ui.userprofile.shared.userdetails;

import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.sap.sse.gwt.client.Notification;
import com.sap.sse.security.ui.authentication.AuthenticationManager;
import com.sap.sse.security.ui.authentication.app.AuthenticationContext;
import com.sap.sse.security.ui.client.UserManagementWriteServiceAsync;
import com.sap.sse.security.ui.client.UserService;
import com.sap.sse.security.ui.client.component.NewAccountValidator;
import com.sap.sse.security.ui.client.i18n.StringMessages;
import com.sap.sse.security.ui.userprofile.shared.userdetails.UserDetailsView;

public class UserDetailsPresenter
implements UserDetailsView.Presenter {
    private final StringMessages i18n_sec = StringMessages.INSTANCE;
    private final NewAccountValidator validator = new NewAccountValidator(this.i18n_sec);
    private final AuthenticationManager authenticationManager;
    private final UserManagementWriteServiceAsync userManagementService;
    private final UserService userService;
    private final String mailVerifiedConfirmationUrlToken;
    private final UserDetailsView view;

    public UserDetailsPresenter(UserDetailsView view, AuthenticationManager authenticationManager, UserManagementWriteServiceAsync userManagementService, UserService userService, String mailVerifiedConfirmationUrlToken) {
        this.view = view;
        this.authenticationManager = authenticationManager;
        this.userManagementService = userManagementService;
        this.userService = userService;
        this.mailVerifiedConfirmationUrlToken = mailVerifiedConfirmationUrlToken;
        view.setPresenter((UserDetailsView.Presenter)this);
        if (authenticationManager.getAuthenticationContext().isLoggedIn()) {
            view.setUser(authenticationManager.getAuthenticationContext().getCurrentUser());
        }
        this.userService.addUserStatusEventHandler((user, preAuthenticated) -> view.setUser(user));
    }

    public void setAuthenticationContext(AuthenticationContext authenticationContext) {
        this.view.setUser(authenticationContext.getCurrentUser());
    }

    public void handleSaveChangesRequest(String fullName, String company, String locale, String defaultTenantIdAsString) {
        this.authenticationManager.updateUserProperties(fullName, company, locale, defaultTenantIdAsString, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void handleEmailChangeRequest(String email) {
        String username = this.authenticationManager.getAuthenticationContext().getCurrentUser().getName();
        String url = Window.Location.createUrlBuilder().setHash(this.mailVerifiedConfirmationUrlToken).buildString();
        this.userManagementService.updateSimpleUserEmail(username, email, url, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void handlePasswordChangeRequest(String oldPassword, String newPassword, String newPasswordConfirmation) {
        String username = this.authenticationManager.getAuthenticationContext().getCurrentUser().getName();
        String errorMessage = this.validator.validateUsernameAndPassword(username, newPassword, newPasswordConfirmation, true);
        if (errorMessage != null && !errorMessage.isEmpty()) {
            Notification.notify((String)errorMessage, (Notification.NotificationType)Notification.NotificationType.ERROR);
            return;
        }
        this.userManagementService.updateSimpleUserPassword(username, oldPassword, null, newPassword, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    static /* synthetic */ StringMessages access$0(UserDetailsPresenter userDetailsPresenter) {
        return userDetailsPresenter.i18n_sec;
    }

    static /* synthetic */ AuthenticationManager access$1(UserDetailsPresenter userDetailsPresenter) {
        return userDetailsPresenter.authenticationManager;
    }

    static /* synthetic */ UserService access$2(UserDetailsPresenter userDetailsPresenter) {
        return userDetailsPresenter.userService;
    }

    static /* synthetic */ UserDetailsView access$3(UserDetailsPresenter userDetailsPresenter) {
        return userDetailsPresenter.view;
    }
}

