/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.security.ui.userprofile.shared.userdetails;

import com.google.gwt.dom.client.InputElement;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.text.shared.Renderer;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.uibinder.client.UiHandler;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.PasswordTextBox;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.ValueListBox;
import com.google.gwt.user.client.ui.Widget;
import com.sap.sse.common.Util;
import com.sap.sse.gwt.client.GWTLocaleUtil;
import com.sap.sse.security.shared.dto.StrippedUserGroupDTO;
import com.sap.sse.security.shared.dto.UserDTO;
import com.sap.sse.security.ui.client.i18n.StringMessages;
import com.sap.sse.security.ui.userprofile.shared.userdetails.UserDetailsView;
import java.util.Collection;

public class AbstractUserDetails
extends Composite
implements UserDetailsView {
    @UiField
    public InputElement usernameUi;
    @UiField
    public TextBox nameUi;
    @UiField
    public TextBox companyUi;
    @UiField(provided=true)
    public ValueListBox<String> localeUi = new ValueListBox((Renderer)new /* Unavailable Anonymous Inner Class!! */);
    @UiField
    public TextBox emailUi;
    @UiField
    public ListBox defaultTenantUi;
    @UiField
    public PasswordTextBox oldPasswordUi;
    @UiField
    public PasswordTextBox newPasswordUi;
    @UiField
    public PasswordTextBox newPasswordConfirmationUi;
    private UserDetailsView.Presenter presenter;

    public void setPresenter(UserDetailsView.Presenter presenter) {
        this.presenter = presenter;
    }

    protected UserDetailsView.Presenter getPresenter() {
        return this.presenter;
    }

    protected void onLoad() {
        super.onLoad();
        StringMessages i18n = StringMessages.INSTANCE;
        this.setPlaceholder((Widget)this.oldPasswordUi, i18n.oldPasswordPlaceholder());
        this.setPlaceholder((Widget)this.newPasswordUi, i18n.newPasswordPlaceholder());
        this.setPlaceholder((Widget)this.newPasswordConfirmationUi, i18n.passwordRepeatPlaceholder());
    }

    public void setUser(UserDTO currentUser) {
        this.nameUi.setValue((Object)currentUser.getFullName());
        this.companyUi.setValue((Object)currentUser.getCompany());
        this.usernameUi.setValue(currentUser.getName());
        this.emailUi.setValue((Object)currentUser.getEmail());
        this.updateDefaultTenantSelection(currentUser);
        String currentLocale = currentUser.getLocale();
        this.localeUi.setValue((Object)currentLocale);
        this.localeUi.setAcceptableValues(GWTLocaleUtil.getAvailableLocalesAndDefault());
        this.clearPasswordFields();
    }

    private void updateDefaultTenantSelection(UserDTO currentUser) {
        StrippedUserGroupDTO defaultTennant = currentUser.getDefaultTenant();
        this.defaultTenantUi.clear();
        int i = 0;
        for (StrippedUserGroupDTO group : Util.sortNamedCollection((Collection)currentUser.getUserGroups(), (boolean)false)) {
            this.defaultTenantUi.addItem(group.getName(), group.getId().toString());
            if (Util.equalsWithNull((Object)group, (Object)defaultTennant)) {
                this.defaultTenantUi.setSelectedIndex(i);
            }
            ++i;
        }
    }

    public void clearPasswordFields() {
        this.oldPasswordUi.setValue((Object)"");
        this.newPasswordUi.setValue((Object)"");
        this.newPasswordConfirmationUi.setValue((Object)"");
    }

    private void setPlaceholder(Widget widget, String placeholderText) {
        widget.getElement().setAttribute("placeholder", placeholderText);
    }

    @UiHandler(value={"saveChangesUi"})
    public void onSaveChangesClicked(ClickEvent event) {
        this.presenter.handleSaveChangesRequest(this.nameUi.getValue(), this.companyUi.getValue(), (String)this.localeUi.getValue(), this.defaultTenantUi.getSelectedValue());
    }

    @UiHandler(value={"changeEmailUi"})
    public void onChangeEmailClicked(ClickEvent event) {
        this.presenter.handleEmailChangeRequest(this.emailUi.getValue());
    }

    @UiHandler(value={"changePasswordUi"})
    public void onChangePasswordClicked(ClickEvent event) {
        this.presenter.handlePasswordChangeRequest(this.oldPasswordUi.getValue(), this.newPasswordUi.getValue(), this.newPasswordConfirmationUi.getValue());
    }
}

