/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.security.ui.shared;

import com.google.gwt.user.client.rpc.IsSerializable;
import com.sap.sse.security.shared.HasPermissions;
import com.sap.sse.security.shared.QualifiedObjectIdentifier;
import com.sap.sse.security.shared.TypeRelativeObjectIdentifier;
import com.sap.sse.security.shared.WildcardPermission;
import com.sap.sse.security.shared.dto.AccessControlListDTO;
import com.sap.sse.security.shared.dto.SecuredDTO;
import com.sap.sse.security.shared.dto.SecurityInformationDTO;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;

public class EssentialSecuredDTO
extends SecurityInformationDTO
implements SecuredDTO,
IsSerializable {
    private static final long serialVersionUID = -5174060227113723186L;
    private HasPermissions permissionType;
    private TypeRelativeObjectIdentifier typeRelativeObjectIdentifier;
    private String name;

    @Deprecated
    EssentialSecuredDTO() {
    }

    public EssentialSecuredDTO(HasPermissions permissionType, String name, TypeRelativeObjectIdentifier typeRelativeObjectIdentifier) {
        this.typeRelativeObjectIdentifier = typeRelativeObjectIdentifier;
        this.permissionType = permissionType;
        this.name = name;
    }

    public QualifiedObjectIdentifier getIdentifier() {
        return this.getPermissionType().getQualifiedObjectIdentifier(this.getTypeRelativeObjectIdentifier());
    }

    public TypeRelativeObjectIdentifier getTypeRelativeObjectIdentifier() {
        return this.typeRelativeObjectIdentifier;
    }

    public HasPermissions getPermissionType() {
        return this.permissionType;
    }

    public String getName() {
        return this.name;
    }

    public static EssentialSecuredDTO getInstanceByPermissionTypeFromPermissionSet(HasPermissions permissionType, Set<WildcardPermission> wildcardPermissions) {
        EssentialSecuredDTO essentialSecuredDTO = new EssentialSecuredDTO(permissionType, null, new TypeRelativeObjectIdentifier(new String[0]));
        HashMap permissionMap = new HashMap();
        HashSet wildcardsAsStringSet = new HashSet();
        for (WildcardPermission permission : wildcardPermissions) {
            Set domains = (Set)permission.getParts().get(0);
            if (!domains.contains(permissionType.getName())) continue;
            Set actions = (Set)permission.getParts().get(1);
            wildcardsAsStringSet.addAll(actions);
        }
        permissionMap.put(null, wildcardsAsStringSet);
        AccessControlListDTO accessControlListDTO = new AccessControlListDTO(permissionMap);
        essentialSecuredDTO.setAccessControlList(accessControlListDTO);
        return essentialSecuredDTO;
    }
}

