/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.security.ui.loginpanel;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.resources.client.ImageResource;
import com.google.gwt.user.client.ui.Anchor;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.ImageResourceRenderer;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Widget;
import com.sap.sse.security.shared.dto.UserDTO;
import com.sap.sse.security.ui.client.EntryPointLinkFactory;
import com.sap.sse.security.ui.client.IconResources;
import com.sap.sse.security.ui.client.UserManagementWriteServiceAsync;
import com.sap.sse.security.ui.client.UserService;
import com.sap.sse.security.ui.client.UserStatusEventHandler;
import com.sap.sse.security.ui.client.i18n.StringMessages;
import com.sap.sse.security.ui.client.shared.oauthlogin.OAuthLogin;
import com.sap.sse.security.ui.loginpanel.LoginPanelCss;
import java.util.HashMap;

public class LoginPanel
extends HorizontalPanel
implements UserStatusEventHandler {
    public final UserManagementWriteServiceAsync userManagementWriteService;
    public static final StringMessages stringMessages = (StringMessages)GWT.create(StringMessages.class);
    private UserService userService;
    private final Anchor signInLink;
    private final Anchor signOutLink;
    private final Anchor signUpLink;
    private final Label welcomeMessage;
    private final OAuthLogin oAuthPanel;

    public LoginPanel(LoginPanelCss css, UserService userService) {
        this.userManagementWriteService = userService.getUserManagementWriteService();
        this.userService = userService;
        css.ensureInjected();
        this.getElement().addClassName(css.loginPanel());
        this.welcomeMessage = new Label();
        this.signInLink = new Anchor(stringMessages.signIn());
        this.signInLink.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.signUpLink = new Anchor(stringMessages.signUp());
        this.signUpLink.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.signOutLink = new Anchor(stringMessages.signOut());
        this.signOutLink.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        ImageResource userImageResource = IconResources.INSTANCE.userIcon();
        ImageResourceRenderer renderer = new ImageResourceRenderer();
        Anchor imageContainer = new Anchor(renderer.render(userImageResource));
        imageContainer.setHref(EntryPointLinkFactory.createPasswordResetLink(new HashMap()));
        imageContainer.setTitle(stringMessages.editProfile());
        imageContainer.getElement().addClassName(css.userIcon());
        this.add((Widget)imageContainer);
        this.welcomeMessage.getElement().addClassName(css.welcomeMessage());
        this.signInLink.getElement().addClassName(css.link());
        this.signUpLink.getElement().addClassName(css.link());
        this.signOutLink.getElement().addClassName(css.link());
        this.add((Widget)this.welcomeMessage);
        this.add((Widget)this.signInLink);
        this.add((Widget)this.signUpLink);
        this.add((Widget)this.signOutLink);
        this.oAuthPanel = new OAuthLogin(this.userManagementWriteService);
        this.add((Widget)this.oAuthPanel);
        userService.addUserStatusEventHandler((UserStatusEventHandler)this);
        this.updateStatus();
    }

    public void updateStatus() {
        if (this.userService.getCurrentUser() != null) {
            String name = this.userService.getCurrentUser().getName();
            String displayName = name == null ? "" : (name.contains("*") ? name.split("\\*")[1] : name);
            String croppedDisplayName = displayName.length() > 15 ? String.valueOf(displayName.substring(0, 12)) + "..." : displayName;
            this.welcomeMessage.setText(stringMessages.welcome(croppedDisplayName));
            this.signInLink.setVisible(false);
            this.signUpLink.setVisible(false);
            this.oAuthPanel.setVisible(false);
            this.signOutLink.setVisible(true);
        } else {
            this.welcomeMessage.setText("");
            this.signInLink.setVisible(true);
            this.signUpLink.setVisible(true);
            this.oAuthPanel.setVisible(true);
            this.signOutLink.setVisible(false);
        }
    }

    public void onUserStatusChange(UserDTO user, boolean preAuthenticated) {
        this.updateStatus();
    }
}

