/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.security.ui.client.usermanagement.roles;

import com.google.gwt.core.shared.GWT;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.KeyUpEvent;
import com.google.gwt.event.dom.client.KeyUpHandler;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.CaptionPanel;
import com.google.gwt.user.client.ui.CheckBox;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.ScrollPanel;
import com.google.gwt.user.client.ui.SuggestBox;
import com.google.gwt.user.client.ui.SuggestOracle;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.UIObject;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.view.client.MultiSelectionModel;
import com.google.gwt.view.client.SelectionChangeEvent;
import com.google.gwt.view.client.SingleSelectionModel;
import com.sap.sse.gwt.client.ErrorReporter;
import com.sap.sse.gwt.client.celltable.CellTableWithCheckboxResources;
import com.sap.sse.gwt.client.panels.LabeledAbstractFilterablePanel;
import com.sap.sse.security.shared.AbstractRole;
import com.sap.sse.security.shared.dto.StrippedRoleDefinitionDTO;
import com.sap.sse.security.shared.dto.UserDTO;
import com.sap.sse.security.ui.client.UserService;
import com.sap.sse.security.ui.client.component.UserGroupListDataProvider;
import com.sap.sse.security.ui.client.component.usergroup.roles.RoleDefinitionSuggestOracle;
import com.sap.sse.security.ui.client.i18n.StringMessages;
import com.sap.sse.security.ui.client.usermanagement.RoleAndPermissionDetailsResources;
import com.sap.sse.security.ui.client.usermanagement.roles.RoleWithSecurityDTOTableWrapper;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;

public class UserRoleDefinitionPanel
extends HorizontalPanel
implements SelectionChangeEvent.Handler,
ChangeHandler,
KeyUpHandler,
UserGroupListDataProvider.UserGroupListDataProviderChangeHandler {
    private final RoleWithSecurityDTOTableWrapper roleWithSecurityDTOTableWrapper;
    private final SingleSelectionModel<UserDTO> userSelectionModel;
    private final SuggestBox suggestRole;
    private final RoleAndPermissionDetailsResources roleAndPermissionDetailsResources = (RoleAndPermissionDetailsResources)GWT.create(RoleAndPermissionDetailsResources.class);
    private final RoleDefinitionSuggestOracle oracle;

    public UserRoleDefinitionPanel(UserService userService, StringMessages stringMessages, ErrorReporter errorReporter, CellTableWithCheckboxResources tableResources, MultiSelectionModel<UserDTO> userSelectionModel, Runnable updateUsers, Function<SuggestOracle, SuggestBox> suggestBoxConstructor, Supplier<TextBox> textBoxConstructor) {
        this.ensureDebugId(this.getClass().getSimpleName());
        SingleSelectionModel multiToSingleSelectionModelAdapter = new SingleSelectionModel();
        userSelectionModel.addSelectionChangeHandler(event -> {
            multiToSingleSelectionModelAdapter.clear();
            if (userSelectionModel.getSelectedSet().size() != 1) {
                this.setVisible(false);
            } else {
                multiToSingleSelectionModelAdapter.setSelected((Object)((UserDTO)userSelectionModel.getSelectedSet().iterator().next()), true);
                this.setVisible(true);
                this.updateOracle();
                this.updateRoles();
            }
        });
        this.userSelectionModel = multiToSingleSelectionModelAdapter;
        this.oracle = new RoleDefinitionSuggestOracle(userService.getUserManagementService(), stringMessages);
        this.suggestRole = suggestBoxConstructor.apply((SuggestOracle)this.oracle);
        this.roleAndPermissionDetailsResources.css().ensureInjected();
        this.suggestRole.addStyleName(this.roleAndPermissionDetailsResources.css().enterRoleNameSuggest());
        this.suggestRole.getElement().setPropertyString("placeholder", stringMessages.enterRoleName());
        this.suggestRole.ensureDebugId("suggestRole");
        this.initPlaceholder((UIObject)this.suggestRole, stringMessages.enterRoleName());
        HorizontalPanel roleInputPanel = new HorizontalPanel();
        TextBox tenantInput = textBoxConstructor.get();
        tenantInput.ensureDebugId("tenantInput");
        this.initPlaceholder((UIObject)tenantInput, stringMessages.groupName());
        TextBox userInput = textBoxConstructor.get();
        userInput.ensureDebugId("userInput");
        this.initPlaceholder((UIObject)userInput, stringMessages.username());
        CheckBox transitiveCheckBox = new CheckBox(stringMessages.transitive());
        transitiveCheckBox.setValue(Boolean.valueOf(true));
        roleInputPanel.add((Widget)this.suggestRole);
        roleInputPanel.add((Widget)tenantInput);
        roleInputPanel.add((Widget)userInput);
        roleInputPanel.add((Widget)transitiveCheckBox);
        Button addRoleButton = new Button(stringMessages.add(), event -> {
            UserDTO selectedUser;
            StrippedRoleDefinitionDTO role = this.oracle.fromString(this.suggestRole.getText());
            if (role != null && (selectedUser = (UserDTO)this.userSelectionModel.getSelectedObject()) != null) {
                userService.getUserManagementWriteService().addRoleToUser(selectedUser.getName(), userInput.getText(), role.getId(), tenantInput.getText(), transitiveCheckBox.getValue().booleanValue(), (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
            }
            this.suggestRole.setText("");
            tenantInput.setText("");
            userInput.setText("");
            transitiveCheckBox.setValue(Boolean.valueOf(true));
        });
        addRoleButton.ensureDebugId("addRoleButton");
        Command addRoleButtonUpdater = () -> addRoleButton.setEnabled(!this.suggestRole.getValue().isEmpty());
        this.suggestRole.addKeyUpHandler(event -> addRoleButtonUpdater.execute());
        this.suggestRole.addSelectionHandler(event -> addRoleButtonUpdater.execute());
        roleInputPanel.add((Widget)addRoleButton);
        this.roleWithSecurityDTOTableWrapper = new RoleWithSecurityDTOTableWrapper(userService, stringMessages, errorReporter, true, tableResources, this.userSelectionModel, updateUsers);
        ScrollPanel scrollPanel = new ScrollPanel(this.roleWithSecurityDTOTableWrapper.asWidget());
        LabeledAbstractFilterablePanel userFilterbox = this.roleWithSecurityDTOTableWrapper.getFilterField();
        userFilterbox.getElement().setPropertyString("placeholder", stringMessages.filterUserGroups());
        VerticalPanel rolePanel = new VerticalPanel();
        rolePanel.add((Widget)roleInputPanel);
        rolePanel.add((Widget)userFilterbox);
        rolePanel.add((Widget)scrollPanel);
        CaptionPanel captionPanel = new CaptionPanel(stringMessages.roles());
        captionPanel.add((Widget)rolePanel);
        this.setVisible(false);
        this.add((Widget)captionPanel);
        this.ensureDebugId(this.getClass().getSimpleName());
    }

    public void refreshSuggest() {
        this.oracle.refresh();
    }

    private void initPlaceholder(UIObject target, String placeholder) {
        target.getElement().setAttribute("placeholder", placeholder);
    }

    private void updateOracle() {
        UserDTO selectedObject = (UserDTO)this.userSelectionModel.getSelectedObject();
        if (selectedObject != null) {
            Iterable roles = StreamSupport.stream(selectedObject.getRoles().spliterator(), false).map(AbstractRole::getRoleDefinition).collect(Collectors.toList());
            ((RoleDefinitionSuggestOracle)this.suggestRole.getSuggestOracle()).resetAndRemoveExistingRoles(roles);
        }
    }

    public void updateRoles() {
        this.roleWithSecurityDTOTableWrapper.refreshRoleList();
    }

    public void onChange() {
        this.updateRoles();
    }

    public void onKeyUp(KeyUpEvent event) {
        this.updateRoles();
    }

    public void onChange(ChangeEvent event) {
        this.updateRoles();
    }

    public void onSelectionChange(SelectionChangeEvent event) {
        this.updateRoles();
    }
}

