/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.security.ui.client.usermanagement.roles;

import com.google.gwt.user.cellview.client.Column;
import com.google.gwt.user.cellview.client.ColumnSortEvent;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.view.client.SingleSelectionModel;
import com.sap.sse.gwt.client.ErrorReporter;
import com.sap.sse.gwt.client.StringMessages;
import com.sap.sse.gwt.client.celltable.AbstractSortableTextColumn;
import com.sap.sse.gwt.client.celltable.CellTableWithCheckboxResources;
import com.sap.sse.gwt.client.celltable.EntityIdentityComparator;
import com.sap.sse.gwt.client.celltable.FlushableCellTable;
import com.sap.sse.gwt.client.celltable.ImagesBarCell;
import com.sap.sse.gwt.client.celltable.RefreshableSingleSelectionModel;
import com.sap.sse.gwt.client.celltable.TableWrapper;
import com.sap.sse.gwt.client.panels.LabeledAbstractFilterablePanel;
import com.sap.sse.security.shared.HasPermissions;
import com.sap.sse.security.shared.dto.AccessControlListDTO;
import com.sap.sse.security.shared.dto.RoleWithSecurityDTO;
import com.sap.sse.security.shared.dto.SecuredDTO;
import com.sap.sse.security.shared.dto.StrippedRoleDefinitionDTO;
import com.sap.sse.security.shared.dto.StrippedUserDTO;
import com.sap.sse.security.shared.dto.StrippedUserGroupDTO;
import com.sap.sse.security.shared.dto.UserDTO;
import com.sap.sse.security.shared.impl.SecuredSecurityTypes;
import com.sap.sse.security.ui.client.UserManagementWriteServiceAsync;
import com.sap.sse.security.ui.client.UserService;
import com.sap.sse.security.ui.client.component.AccessControlledActionsColumn;
import com.sap.sse.security.ui.client.component.DefaultActionsImagesBarCell;
import com.sap.sse.security.ui.client.component.EditOwnershipDialog;
import com.sap.sse.security.ui.client.component.editacl.EditACLDialog;
import com.sap.sse.security.ui.client.usermanagement.PermissionAndRoleImagesBarCell;

public class RoleWithSecurityDTOTableWrapper
extends TableWrapper<RoleWithSecurityDTO, RefreshableSingleSelectionModel<RoleWithSecurityDTO>, com.sap.sse.security.ui.client.i18n.StringMessages, CellTableWithCheckboxResources> {
    private final LabeledAbstractFilterablePanel<RoleWithSecurityDTO> filterField;
    private final SingleSelectionModel<UserDTO> userSelectionModel;

    public RoleWithSecurityDTOTableWrapper(UserService userService, com.sap.sse.security.ui.client.i18n.StringMessages stringMessages, ErrorReporter errorReporter, boolean enablePager, CellTableWithCheckboxResources tableResources, SingleSelectionModel<UserDTO> userSelectionModel, Runnable updateUsers) {
        super((StringMessages)stringMessages, errorReporter, false, enablePager, (EntityIdentityComparator)new /* Unavailable Anonymous Inner Class!! */, tableResources);
        this.userSelectionModel = userSelectionModel;
        this.userSelectionModel.addSelectionChangeHandler(e -> this.refreshRoleList());
        ColumnSortEvent.ListHandler userColumnListHandler = this.getColumnSortHandler();
        AbstractSortableTextColumn userGroupWithSecurityDTONameColumn = new AbstractSortableTextColumn(dto -> dto.toString(), userColumnListHandler);
        AbstractSortableTextColumn userGroupWithSecurityDTOTransitiveColumn = new AbstractSortableTextColumn(dto -> dto.isTransitive() != false ? stringMessages.yes() : stringMessages.no(), userColumnListHandler);
        AccessControlledActionsColumn userActionColumn = AccessControlledActionsColumn.create((ImagesBarCell)new PermissionAndRoleImagesBarCell(stringMessages), (UserService)userService);
        userActionColumn.addAction(DefaultActionsImagesBarCell.ACTION_DELETE, (HasPermissions.Action)HasPermissions.DefaultActions.DELETE, selectedRole -> {
            UserDTO selectedObject = (UserDTO)userSelectionModel.getSelectedObject();
            if (selectedObject != null) {
                StrippedUserGroupDTO qualifiedForTenant = (StrippedUserGroupDTO)selectedRole.getQualifiedForTenant();
                StrippedUserDTO qualifiedForUser = (StrippedUserDTO)selectedRole.getQualifiedForUser();
                userService.getUserManagementWriteService().removeRoleFromUser(selectedObject.getName(), qualifiedForUser != null ? qualifiedForUser.getName() : null, ((StrippedRoleDefinitionDTO)selectedRole.getRoleDefinition()).getId(), qualifiedForTenant == null ? null : qualifiedForTenant.getName(), selectedRole.isTransitive(), (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
            } else {
                Window.alert((String)stringMessages.pleaseSelect());
            }
        });
        HasPermissions type = SecuredSecurityTypes.PERMISSION_ASSOCIATION;
        EditOwnershipDialog.DialogConfig configOwnership = EditOwnershipDialog.create((UserManagementWriteServiceAsync)userService.getUserManagementWriteService(), (HasPermissions)type, permission -> this.refreshRoleList(), (com.sap.sse.security.ui.client.i18n.StringMessages)stringMessages);
        EditACLDialog.DialogConfig configACL = EditACLDialog.create((UserManagementWriteServiceAsync)userService.getUserManagementWriteService(), (HasPermissions)type, user -> {
            AccessControlListDTO accessControlListDTO = user.getAccessControlList();
        }, (com.sap.sse.security.ui.client.i18n.StringMessages)stringMessages);
        userActionColumn.addAction(DefaultActionsImagesBarCell.ACTION_CHANGE_OWNERSHIP, (HasPermissions.Action)HasPermissions.DefaultActions.CHANGE_OWNERSHIP, arg_0 -> ((EditOwnershipDialog.DialogConfig)configOwnership).openOwnershipDialog(arg_0));
        userActionColumn.addAction(DefaultActionsImagesBarCell.ACTION_CHANGE_ACL, (HasPermissions.Action)HasPermissions.DefaultActions.CHANGE_ACL, permission -> configACL.openDialog((SecuredDTO)permission));
        this.filterField = new /* Unavailable Anonymous Inner Class!! */;
        this.filterField.setUpdatePermissionFilterForCheckbox(role -> userService.hasPermission((SecuredDTO)role, (HasPermissions.Action)HasPermissions.DefaultActions.UPDATE));
        this.registerSelectionModelOnNewDataProvider(this.filterField.getAllListDataProvider());
        this.mainPanel.insert((Widget)this.filterField, 0);
        this.table.addColumnSortHandler((ColumnSortEvent.Handler)userColumnListHandler);
        this.table.addColumn((Column)userGroupWithSecurityDTONameColumn, stringMessages.roleName());
        this.table.addColumn((Column)userGroupWithSecurityDTOTransitiveColumn, stringMessages.transitive());
        this.table.addColumn((Column)userActionColumn);
        this.table.ensureDebugId("RoleWithSecurityDTOTable");
    }

    public LabeledAbstractFilterablePanel<RoleWithSecurityDTO> getFilterField() {
        return this.filterField;
    }

    public void refreshRoleList() {
        UserDTO selectedObject = (UserDTO)this.userSelectionModel.getSelectedObject();
        if (selectedObject != null) {
            this.filterField.updateAll(selectedObject.getRoles());
        }
    }

    static /* synthetic */ FlushableCellTable access$0(RoleWithSecurityDTOTableWrapper roleWithSecurityDTOTableWrapper) {
        return roleWithSecurityDTOTableWrapper.table;
    }
}

