/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.security.ui.client.usermanagement.permissions;

import com.google.gwt.user.cellview.client.Column;
import com.google.gwt.user.cellview.client.ColumnSortEvent;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.view.client.SingleSelectionModel;
import com.sap.sse.gwt.client.ErrorReporter;
import com.sap.sse.gwt.client.StringMessages;
import com.sap.sse.gwt.client.celltable.AbstractSortableTextColumn;
import com.sap.sse.gwt.client.celltable.CellTableWithCheckboxResources;
import com.sap.sse.gwt.client.celltable.EntityIdentityComparator;
import com.sap.sse.gwt.client.celltable.FlushableCellTable;
import com.sap.sse.gwt.client.celltable.ImagesBarCell;
import com.sap.sse.gwt.client.celltable.RefreshableSingleSelectionModel;
import com.sap.sse.gwt.client.celltable.TableWrapper;
import com.sap.sse.gwt.client.panels.LabeledAbstractFilterablePanel;
import com.sap.sse.security.shared.HasPermissions;
import com.sap.sse.security.shared.WildcardPermission;
import com.sap.sse.security.shared.dto.AccessControlListDTO;
import com.sap.sse.security.shared.dto.SecuredDTO;
import com.sap.sse.security.shared.dto.UserDTO;
import com.sap.sse.security.shared.dto.WildcardPermissionWithSecurityDTO;
import com.sap.sse.security.shared.impl.SecuredSecurityTypes;
import com.sap.sse.security.ui.client.UserManagementWriteServiceAsync;
import com.sap.sse.security.ui.client.UserService;
import com.sap.sse.security.ui.client.component.AccessControlledActionsColumn;
import com.sap.sse.security.ui.client.component.DefaultActionsImagesBarCell;
import com.sap.sse.security.ui.client.component.EditOwnershipDialog;
import com.sap.sse.security.ui.client.component.editacl.EditACLDialog;
import com.sap.sse.security.ui.client.usermanagement.PermissionAndRoleImagesBarCell;
import java.util.ArrayList;

public class WildcardPermissionWithSecurityDTOTableWrapper
extends TableWrapper<WildcardPermissionWithSecurityDTO, RefreshableSingleSelectionModel<WildcardPermissionWithSecurityDTO>, com.sap.sse.security.ui.client.i18n.StringMessages, CellTableWithCheckboxResources> {
    private final LabeledAbstractFilterablePanel<WildcardPermissionWithSecurityDTO> filterField;
    private final SingleSelectionModel<UserDTO> userSelectionModel;

    public WildcardPermissionWithSecurityDTOTableWrapper(UserService userService, com.sap.sse.security.ui.client.i18n.StringMessages stringMessages, ErrorReporter errorReporter, boolean enablePager, CellTableWithCheckboxResources tableResources, SingleSelectionModel<UserDTO> userSelectionModel, Runnable updateUsers) {
        super((StringMessages)stringMessages, errorReporter, false, enablePager, (EntityIdentityComparator)new /* Unavailable Anonymous Inner Class!! */, tableResources);
        this.userSelectionModel = userSelectionModel;
        this.userSelectionModel.addSelectionChangeHandler(e -> this.refreshPermissionList());
        ColumnSortEvent.ListHandler userColumnListHandler = this.getColumnSortHandler();
        AbstractSortableTextColumn userGroupWithSecurityDTONameColumn = new AbstractSortableTextColumn(dto -> dto.toString(), userColumnListHandler);
        AccessControlledActionsColumn userActionColumn = AccessControlledActionsColumn.create((ImagesBarCell)new PermissionAndRoleImagesBarCell(stringMessages), (UserService)userService);
        userActionColumn.addAction(DefaultActionsImagesBarCell.ACTION_DELETE, (HasPermissions.Action)HasPermissions.DefaultActions.DELETE, selectedPermission -> {
            UserDTO selectedObject = (UserDTO)userSelectionModel.getSelectedObject();
            if (selectedObject != null) {
                userService.getUserManagementWriteService().removePermissionFromUser(selectedObject.getName(), selectedPermission, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
            } else {
                Window.alert((String)stringMessages.pleaseSelect());
            }
        });
        HasPermissions type = SecuredSecurityTypes.PERMISSION_ASSOCIATION;
        EditOwnershipDialog.DialogConfig configOwnership = EditOwnershipDialog.create((UserManagementWriteServiceAsync)userService.getUserManagementWriteService(), (HasPermissions)type, permission -> this.refreshPermissionList(), (com.sap.sse.security.ui.client.i18n.StringMessages)stringMessages);
        EditACLDialog.DialogConfig configACL = EditACLDialog.create((UserManagementWriteServiceAsync)userService.getUserManagementWriteService(), (HasPermissions)type, user -> {
            AccessControlListDTO accessControlListDTO = user.getAccessControlList();
        }, (com.sap.sse.security.ui.client.i18n.StringMessages)stringMessages);
        userActionColumn.addAction(DefaultActionsImagesBarCell.ACTION_CHANGE_OWNERSHIP, (HasPermissions.Action)HasPermissions.DefaultActions.CHANGE_OWNERSHIP, arg_0 -> ((EditOwnershipDialog.DialogConfig)configOwnership).openOwnershipDialog(arg_0));
        userActionColumn.addAction(DefaultActionsImagesBarCell.ACTION_CHANGE_ACL, (HasPermissions.Action)HasPermissions.DefaultActions.CHANGE_ACL, permission -> configACL.openDialog((SecuredDTO)permission));
        this.filterField = new /* Unavailable Anonymous Inner Class!! */;
        this.registerSelectionModelOnNewDataProvider(this.filterField.getAllListDataProvider());
        this.filterField.setUpdatePermissionFilterForCheckbox(permission -> userService.hasPermission((SecuredDTO)permission, (HasPermissions.Action)HasPermissions.DefaultActions.UPDATE));
        this.mainPanel.insert((Widget)this.filterField, 0);
        this.table.ensureDebugId("WildcardPermissionWithSecurityDTOTable");
        this.table.addColumnSortHandler((ColumnSortEvent.Handler)userColumnListHandler);
        this.table.addColumn((Column)userGroupWithSecurityDTONameColumn, stringMessages.permission());
        this.table.addColumn((Column)userActionColumn, stringMessages.actions());
    }

    public LabeledAbstractFilterablePanel<WildcardPermissionWithSecurityDTO> getFilterField() {
        return this.filterField;
    }

    public void refreshPermissionList() {
        UserDTO selectedObject = (UserDTO)this.userSelectionModel.getSelectedObject();
        if (selectedObject != null) {
            ArrayList<WildcardPermissionWithSecurityDTO> permissions = new ArrayList<WildcardPermissionWithSecurityDTO>();
            for (WildcardPermission permission : selectedObject.getPermissions()) {
                permissions.add((WildcardPermissionWithSecurityDTO)permission);
            }
            this.filterField.updateAll(permissions);
        }
    }

    static /* synthetic */ FlushableCellTable access$0(WildcardPermissionWithSecurityDTOTableWrapper wildcardPermissionWithSecurityDTOTableWrapper) {
        return wildcardPermissionWithSecurityDTOTableWrapper.table;
    }
}

