/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.security.ui.client.usermanagement;

import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.DockPanel;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.ScrollPanel;
import com.google.gwt.user.client.ui.SuggestBox;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.view.client.MultiSelectionModel;
import com.google.gwt.view.client.SetSelectionModel;
import com.sap.sse.gwt.client.ErrorReporter;
import com.sap.sse.gwt.client.celltable.CellTableWithCheckboxResources;
import com.sap.sse.gwt.client.celltable.RefreshableMultiSelectionModel;
import com.sap.sse.gwt.client.panels.LabeledAbstractFilterablePanel;
import com.sap.sse.security.shared.HasPermissions;
import com.sap.sse.security.shared.dto.UserDTO;
import com.sap.sse.security.shared.impl.SecuredSecurityTypes;
import com.sap.sse.security.ui.client.UserManagementWriteServiceAsync;
import com.sap.sse.security.ui.client.UserService;
import com.sap.sse.security.ui.client.component.AccessControlledButtonPanel;
import com.sap.sse.security.ui.client.component.CreateUserDialog;
import com.sap.sse.security.ui.client.i18n.StringMessages;
import com.sap.sse.security.ui.client.usermanagement.UserManagementPanel;
import com.sap.sse.security.ui.client.usermanagement.UserTableWrapper;
import com.sap.sse.security.ui.client.usermanagement.permissions.WildcardPermissionPanel;
import com.sap.sse.security.ui.client.usermanagement.roles.UserRoleDefinitionPanel;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class UserManagementPanel<TR extends CellTableWithCheckboxResources>
extends DockPanel {
    private final List<UserCreatedEventHandler> userCreatedHandlers = new ArrayList();
    private final List<UserDeletedEventHandler> userDeletedHandlers = new ArrayList();
    protected final UserTableWrapper<RefreshableMultiSelectionModel<UserDTO>, TR> userList;
    private final RefreshableMultiSelectionModel<UserDTO> userSelectionModel;
    private final TextBox userNameTextbox;
    private final UserRoleDefinitionPanel userRoleDefinitionPanel;

    public UserManagementPanel(UserService userService, StringMessages stringMessages, ErrorReporter errorReporter, TR tableResources) {
        UserManagementWriteServiceAsync userManagementWriteService = userService.getUserManagementWriteService();
        VerticalPanel west = new VerticalPanel();
        AccessControlledButtonPanel buttonPanel = new AccessControlledButtonPanel(userService, SecuredSecurityTypes.USER);
        west.add((Widget)buttonPanel);
        this.userList = new UserTableWrapper(userService, stringMessages, errorReporter, true, true, tableResources);
        buttonPanel.addUnsecuredAction(stringMessages.refresh(), () -> this.userList.refreshUserList(null, false));
        Button createUserButton = buttonPanel.addCreateActionWithoutServerCreateObjectPermissionCheck(stringMessages.createUser(), () -> new CreateUserDialog(stringMessages, userManagementWriteService, (Iterable)this.userCreatedHandlers, userService).show());
        createUserButton.ensureDebugId("CreateUserButton");
        this.userNameTextbox = buttonPanel.addUnsecuredTextBox(stringMessages.username());
        this.userNameTextbox.ensureDebugId("UserNameTextbox");
        Button editRolesAndPermissionsForUserButton = buttonPanel.addUnsecuredAction(stringMessages.editRolesAndPermissionsForUser(""), () -> this.showRolesAndPermissionsEditDialog(userService, tableResources, errorReporter));
        editRolesAndPermissionsForUserButton.ensureDebugId("EditRolesAndPermissionsForUserButton");
        this.userNameTextbox.addKeyUpHandler(e -> editRolesAndPermissionsForUserButton.setEnabled(!this.userNameTextbox.getText().isEmpty()));
        editRolesAndPermissionsForUserButton.setEnabled(false);
        this.userSelectionModel = (RefreshableMultiSelectionModel)this.userList.getSelectionModel();
        Button removeButton = buttonPanel.addRemoveAction(stringMessages.remove(), (SetSelectionModel)this.userSelectionModel, false, () -> {
            assert (this.userSelectionModel.getSelectedSet().size() > 0);
            HashSet<UserDTO> usersToDelete = new HashSet<UserDTO>();
            HashSet<String> usernamesToDelete = new HashSet<String>();
            for (UserDTO userToDelete : this.userSelectionModel.getSelectedSet()) {
                usersToDelete.add(userToDelete);
                usernamesToDelete.add(userToDelete.getName());
            }
            if (Window.confirm((String)(usernamesToDelete.size() == 1 ? stringMessages.doYouReallyWantToDeleteUser((String)usernamesToDelete.iterator().next()) : stringMessages.doYouReallyWantToDeleteNUsers(usernamesToDelete.size())))) {
                userManagementWriteService.deleteUsers(usernamesToDelete, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
            }
        });
        removeButton.ensureDebugId("DeleteUserButton");
        boolean hasManageLockPermissionOnAnyUser = userService.hasCurrentUserAnyPermission(SecuredSecurityTypes.USER.getPermission(new HasPermissions.Action[]{SecuredSecurityTypes.UserActions.MANAGE_LOCK}), null);
        if (hasManageLockPermissionOnAnyUser) {
            Button unlockButton = buttonPanel.addCountingAction("Unlock", (SetSelectionModel)this.userSelectionModel, () -> true, () -> this.onCountingUnlockButtonClick(stringMessages, userManagementWriteService, errorReporter));
            unlockButton.ensureDebugId("UnlockUserButton");
        }
        ScrollPanel scrollPanel = new ScrollPanel(this.userList.asWidget());
        LabeledAbstractFilterablePanel filterBox = this.userList.getFilterField();
        filterBox.getElement().setPropertyString("placeholder", stringMessages.filterUsers());
        west.add((Widget)filterBox);
        west.add((Widget)scrollPanel);
        this.add((Widget)west, DockPanel.WEST);
        this.addUserCreatedEventHandler((UserCreatedEventHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.addUserDeletedEventHandler((UserDeletedEventHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.updateUsers();
        HorizontalPanel detailsPanel = new HorizontalPanel();
        this.userRoleDefinitionPanel = new UserRoleDefinitionPanel(userService, stringMessages, errorReporter, tableResources, (MultiSelectionModel)this.userList.getSelectionModel(), () -> this.updateUsers(), SuggestBox::new, TextBox::new);
        detailsPanel.add((Widget)this.userRoleDefinitionPanel);
        WildcardPermissionPanel userPermissionPanel = new WildcardPermissionPanel(userService, stringMessages, errorReporter, tableResources, (MultiSelectionModel)this.userList.getSelectionModel(), () -> this.updateUsers(), SuggestBox::new);
        detailsPanel.add((Widget)userPermissionPanel);
        west.add((Widget)detailsPanel);
    }

    private void onCountingUnlockButtonClick(StringMessages stringMessages, UserManagementWriteServiceAsync userManagementWriteService, ErrorReporter errorReporter) {
        Set selectedUsers = this.userSelectionModel.getSelectedSet();
        HashSet selectedUsernames = new HashSet();
        selectedUsers.forEach(u -> {
            boolean bl = selectedUsernames.add(u.getName());
        });
        boolean didConfirm = Window.confirm((String)stringMessages.doYouReallyWantToUnlockNUsers(selectedUsers.size()));
        if (didConfirm) {
            HashSet successUserNames = new HashSet();
            HashSet failureUserNames = new HashSet();
            userManagementWriteService.unlockUsers(selectedUsernames, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
        }
    }

    private void showRolesAndPermissionsEditDialog(UserService userService, CellTableWithCheckboxResources tableResources, ErrorReporter errorReporter) {
        userService.getUserManagementService().userExists(this.userNameTextbox.getText(), (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void refreshSuggests() {
        this.userRoleDefinitionPanel.refreshSuggest();
    }

    public void updateUsers() {
        this.userList.refreshUserList(null);
    }

    public void addUserCreatedEventHandler(UserCreatedEventHandler handler) {
        this.userCreatedHandlers.add(handler);
    }

    public void removeUserCreatedEventHandler(UserCreatedEventHandler handler) {
        this.userCreatedHandlers.remove(handler);
    }

    public void addUserDeletedEventHandler(UserDeletedEventHandler handler) {
        this.userDeletedHandlers.add(handler);
    }

    public void removeUserDeletedEventHandler(UserDeletedEventHandler handler) {
        this.userDeletedHandlers.remove(handler);
    }

    static /* synthetic */ List access$0(UserManagementPanel userManagementPanel) {
        return userManagementPanel.userDeletedHandlers;
    }

    static /* synthetic */ RefreshableMultiSelectionModel access$1(UserManagementPanel userManagementPanel) {
        return userManagementPanel.userSelectionModel;
    }

    static /* synthetic */ TextBox access$2(UserManagementPanel userManagementPanel) {
        return userManagementPanel.userNameTextbox;
    }
}

