/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.security.ui.client.premium.settings;

import com.google.gwt.core.client.GWT;
import com.sap.sse.common.settings.generic.AbstractGenericSerializableSettingsWithContext;
import com.sap.sse.common.settings.generic.StringToEnumConverter;
import com.sap.sse.common.settings.generic.ValueConverter;
import com.sap.sse.common.settings.generic.base.AbstractValueSetSetting;
import com.sap.sse.common.settings.generic.converter.EnumConverter;
import com.sap.sse.common.settings.value.ValueCollectionValue;
import com.sap.sse.security.shared.HasPermissions;
import com.sap.sse.security.shared.dto.SecuredDTO;
import com.sap.sse.security.ui.client.SecurityChildSettingsContext;
import com.sap.sse.security.ui.client.premium.PaywallResolver;
import java.util.ArrayList;
import java.util.Collection;
import java.util.stream.StreamSupport;

public class SecuredEnumSetSetting<T extends Enum<T>>
extends AbstractValueSetSetting<T> {
    private final PaywallResolver paywallResolver;
    private final SecuredDTO securedDto;

    public SecuredEnumSetSetting(String name, AbstractGenericSerializableSettingsWithContext<SecurityChildSettingsContext> settings, Iterable<T> defaultValues, StringToEnumConverter<T> stringToEnumConverter, SecurityChildSettingsContext securityContext) {
        super(name, settings, defaultValues, (ValueConverter)new EnumConverter(stringToEnumConverter));
        this.paywallResolver = securityContext.getPaywallResolver();
        this.securedDto = securityContext.getSecuredDTO();
    }

    public Iterable<T> getValues() {
        if (this.paywallResolver == null) {
            GWT.log((String)"getValue paywall resolver not available.");
        }
        if (this.securedDto == null) {
            GWT.log((String)"getValue securedDTO context not available!");
        }
        ValueCollectionValue value = this.getValue();
        Collection result = value.getValues(this.getValueConverter());
        ArrayList<Enum> permittedCollection = new ArrayList<Enum>();
        for (Enum singleValue : result) {
            if (this.securedDto == null || this.paywallResolver != null && this.paywallResolver.hasPermission(((HasPermissions.SecuredEnum)singleValue).getPremiumAction(), this.securedDto)) {
                permittedCollection.add(singleValue);
                continue;
            }
            if (!StreamSupport.stream(this.getDefaultValues().spliterator(), false).anyMatch(t -> t == singleValue)) continue;
            permittedCollection.add(singleValue);
        }
        return permittedCollection;
    }
}

