/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.security.ui.client.premium.settings;

import com.google.gwt.core.client.GWT;
import com.sap.sse.common.settings.generic.AbstractGenericSerializableSettingsWithContext;
import com.sap.sse.common.settings.generic.ValueConverter;
import com.sap.sse.common.settings.generic.base.AbstractValueSetting;
import com.sap.sse.security.shared.HasPermissions;
import com.sap.sse.security.shared.dto.SecuredDTO;
import com.sap.sse.security.ui.client.SecurityChildSettingsContext;
import com.sap.sse.security.ui.client.premium.PaywallResolver;

public abstract class AbstractSecuredValueSetting<T>
extends AbstractValueSetting<T> {
    private final PaywallResolver paywallResolver;
    private final HasPermissions.Action action;
    private final SecuredDTO securedDTO;

    protected AbstractSecuredValueSetting(String name, AbstractGenericSerializableSettingsWithContext<SecurityChildSettingsContext> settings, T defaultValue, ValueConverter<T> valueConverter, HasPermissions.Action action, SecurityChildSettingsContext securityContext) {
        super(name, settings, defaultValue, valueConverter);
        this.paywallResolver = securityContext.getPaywallResolver();
        this.action = action;
        this.securedDTO = securityContext.getSecuredDTO();
    }

    public boolean hasPermission() {
        return this.paywallResolver.hasPermission(this.action, this.securedDTO);
    }

    public T getValue() {
        if (this.paywallResolver == null) {
            GWT.log((String)"getValue paywall resolver not available.");
        }
        if (this.securedDTO == null) {
            GWT.log((String)"getValue securedDTO context not available!");
        }
        if (this.securedDTO == null || this.paywallResolver != null && this.paywallResolver.hasPermission(this.action, this.securedDTO)) {
            return (T)super.getValue();
        }
        return (T)super.getDefaultValue();
    }

    public void setValue(T value) {
        if (this.paywallResolver == null) {
            GWT.log((String)"setValue Paywall resolver not available.");
        }
        if (this.securedDTO == null) {
            GWT.log((String)"setValue DTOContext not set!");
        }
        if (this.securedDTO != null || this.paywallResolver != null && this.paywallResolver.hasPermission(this.action, this.securedDTO)) {
            super.setValue(value);
        }
    }

    public PaywallResolver getPaywallResolver() {
        return this.paywallResolver;
    }

    public HasPermissions.Action getAction() {
        return this.action;
    }

    public SecuredDTO getSecuredDTO() {
        return this.securedDTO;
    }
}

