/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.security.ui.client.premium;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.HasClickHandlers;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.uibinder.client.UiHandler;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.FocusPanel;
import com.google.gwt.user.client.ui.Widget;
import com.sap.sse.gwt.client.dialog.ConfirmationDialog;
import com.sap.sse.gwt.client.shared.components.Component;
import com.sap.sse.security.shared.HasPermissions;
import com.sap.sse.security.shared.dto.SecuredDTO;
import com.sap.sse.security.ui.client.i18n.StringMessages;
import com.sap.sse.security.ui.client.premium.PaywallResolver;
import com.sap.sse.security.ui.client.premium.PremiumToggleButton;
import com.sap.sse.security.ui.client.premium.PremiumToogleButtonResource;
import com.sap.sse.security.ui.client.premium.PremiumUiElement;

public abstract class PremiumToggleButton
extends PremiumUiElement
implements HasClickHandlers {
    private static PremiumToggleButtonUiBinder uiBinder = (PremiumToggleButtonUiBinder)GWT.create(PremiumToggleButtonUiBinder.class);
    @UiField
    StringMessages i18n;
    @UiField
    protected FocusPanel container;
    @UiField(provided=true)
    protected final Button button;
    private final ConfirmationDialog subscribeDialog;
    protected final HasPermissions.Action action;
    private final Component<?> associatedComponent;
    private Runnable evaluateAndRenderSplitterWithButtons;

    protected PremiumToggleButton(String label, HasPermissions.Action action, PaywallResolver paywallResolver, Component<?> associatedComponent, SecuredDTO dtoContext) {
        super(action, paywallResolver, dtoContext);
        PremiumToogleButtonResource.INSTANCE.css().ensureInjected();
        this.action = action;
        this.associatedComponent = associatedComponent;
        this.button = new Button(label);
        this.initWidget((Widget)uiBinder.createAndBindUi((Object)this));
        this.subscribeDialog = ConfirmationDialog.create((String)this.i18n.subscriptionSuggestionTitle(), (String)this.i18n.pleaseSubscribeToUse(), (String)this.i18n.takeMeToSubscriptions(), (String)this.i18n.cancel(), () -> paywallResolver.getUnlockingSubscriptionPlans(action, dtoContext, arg_0 -> this.onSubscribeDialogConfirmation(arg_0)));
        this.updateUserPermission();
    }

    protected abstract void onSubscribeDialogConfirmation(Iterable<String> var1);

    protected void onEnsureDebugId(String baseID) {
        this.button.ensureDebugId(baseID);
    }

    @UiHandler(value={"container"})
    void onContainerClicked(ClickEvent event) {
        event.stopPropagation();
        event.preventDefault();
        if (!this.hasPermission()) {
            this.updateUserPermission();
            this.subscribeDialog.center();
        } else {
            this.button.click();
        }
    }

    protected void onUserPermissionUpdate(boolean isPermitted) {
        boolean visible = this.associatedComponent.isVisible();
        if (this.action != null) {
            this.addStyleName(PremiumToogleButtonResource.INSTANCE.css().premiumActive());
            this.button.setStyleName(PremiumToogleButtonResource.INSTANCE.css().premiumPermitted(), isPermitted);
            this.button.setStyleName(PremiumToogleButtonResource.INSTANCE.css().notPremiumPermitted(), !isPermitted);
            if (!isPermitted && visible && this.evaluateAndRenderSplitterWithButtons != null) {
                this.evaluateAndRenderSplitterWithButtons.run();
            }
        } else {
            this.removeStyleName(PremiumToogleButtonResource.INSTANCE.css().premiumActive());
            this.button.removeStyleName(PremiumToogleButtonResource.INSTANCE.css().premiumPermitted());
            this.button.removeStyleName(PremiumToogleButtonResource.INSTANCE.css().notPremiumPermitted());
        }
        this.button.setEnabled(this.isEnabled() && isPermitted);
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.button.setEnabled(enabled);
    }

    public HandlerRegistration addClickHandler(ClickHandler handler) {
        return this.button.addClickHandler(handler);
    }

    public Button getInternalButton() {
        return this.button;
    }

    public FocusPanel getFocusPanel() {
        return this.container;
    }

    public void addRunOnUserPermissionChanged(Runnable evaluateAndRenderSplitterWithButtons) {
        this.evaluateAndRenderSplitterWithButtons = evaluateAndRenderSplitterWithButtons;
    }
}

