/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.security.ui.client.premium;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.HasAllKeyHandlers;
import com.google.gwt.event.dom.client.KeyDownHandler;
import com.google.gwt.event.dom.client.KeyPressHandler;
import com.google.gwt.event.dom.client.KeyUpHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.uibinder.client.UiHandler;
import com.google.gwt.user.client.ui.FocusPanel;
import com.google.gwt.user.client.ui.FocusWidget;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.Widget;
import com.sap.sse.gwt.client.dialog.ConfirmationDialog;
import com.sap.sse.security.shared.HasPermissions;
import com.sap.sse.security.shared.dto.SecuredDTO;
import com.sap.sse.security.ui.client.UserStatusEventHandler;
import com.sap.sse.security.ui.client.i18n.StringMessages;
import com.sap.sse.security.ui.client.premium.PaywallResolver;
import com.sap.sse.security.ui.client.premium.PremiumListBox;
import com.sap.sse.security.ui.client.premium.PremiumUiElement;

public abstract class PremiumListBox
extends PremiumUiElement
implements HasAllKeyHandlers {
    private static PremiumCheckBoxUiBinder uiBinder = (PremiumCheckBoxUiBinder)GWT.create(PremiumCheckBoxUiBinder.class);
    @UiField
    StringMessages i18n;
    @UiField
    Style style;
    @UiField
    FocusPanel container;
    @UiField(provided=true)
    protected final Image image;
    @UiField(provided=true)
    protected final ListBox listBox = new ListBox();
    private final ConfirmationDialog subscribeDialog;

    protected PremiumListBox(String emptyLabel, String emptyValue, HasPermissions.Action action, PaywallResolver paywallResolver, SecuredDTO contextDTO) {
        super(action, paywallResolver, contextDTO);
        this.listBox.addItem(emptyLabel, emptyValue);
        this.listBox.setSelectedIndex(0);
        this.image = this.createPremiumIcon();
        this.initWidget((Widget)uiBinder.createAndBindUi((Object)this));
        this.subscribeDialog = ConfirmationDialog.create((String)this.i18n.subscriptionSuggestionTitle(), (String)this.i18n.pleaseSubscribeToUse(), (String)this.i18n.takeMeToSubscriptions(), (String)this.i18n.cancel(), () -> paywallResolver.getUnlockingSubscriptionPlans(action, contextDTO, arg_0 -> this.onSubscribeDialogConfirmation(arg_0)));
        this.updateUserPermission();
        paywallResolver.registerUserStatusEventHandler((UserStatusEventHandler)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void reset() {
        while (this.listBox.getItemCount() > 1) {
            this.listBox.removeItem(1);
        }
    }

    protected abstract void onSubscribeDialogConfirmation(Iterable<String> var1);

    protected void onEnsureDebugId(String baseID) {
        this.listBox.ensureDebugId(baseID);
    }

    @UiHandler(value={"container"})
    void onContainerClicked(ClickEvent event) {
        if (!this.hasPermission()) {
            this.updateUserPermission();
            this.subscribeDialog.center();
        }
    }

    protected void onUserPermissionUpdate(boolean isPermitted) {
        this.listBox.setSelectedIndex(this.getSelectedIndex());
        this.listBox.setEnabled(this.isEnabled() && isPermitted);
        this.container.setStyleName(this.style.premiumPermitted(), isPermitted);
    }

    public void addItem(String item, String value) {
        if (this.hasPermission()) {
            this.listBox.addItem(item, value);
        }
    }

    public void setSelectedIndex(int index) {
        if (this.hasPermission()) {
            this.listBox.setSelectedIndex(index);
        }
    }

    public int getSelectedIndex() {
        int selectedIndex = this.hasPermission() ? this.listBox.getSelectedIndex() : 0;
        return selectedIndex;
    }

    public String getSelectedValue() {
        if (!this.hasPermission()) {
            this.listBox.setSelectedIndex(0);
        }
        return this.listBox.getSelectedValue();
    }

    public void setVisibleItemCount(int visibleItems) {
        if (this.hasPermission()) {
            this.listBox.setVisibleItemCount(visibleItems);
        }
    }

    public HandlerRegistration addChangeHandler(ChangeHandler handler) {
        return this.listBox.addChangeHandler(handler);
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.listBox.setEnabled(enabled);
    }

    public HandlerRegistration addKeyDownHandler(KeyDownHandler handler) {
        return this.container.addKeyDownHandler(handler);
    }

    public HandlerRegistration addKeyPressHandler(KeyPressHandler handler) {
        return this.container.addKeyPressHandler(handler);
    }

    public HandlerRegistration addKeyUpHandler(KeyUpHandler handler) {
        return this.container.addKeyUpHandler(handler);
    }

    public FocusWidget getFocusWidget() {
        return this.listBox;
    }

    public ListBox getListBox() {
        return this.listBox;
    }
}

