/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.security.ui.client.component.usergroup.roles;

import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.MultiWordSuggestOracle;
import com.sap.sse.common.Util;
import com.sap.sse.security.shared.RoleDefinitionImpl;
import com.sap.sse.security.shared.dto.StrippedRoleDefinitionDTO;
import com.sap.sse.security.ui.client.UserManagementServiceAsync;
import com.sap.sse.security.ui.client.i18n.StringMessages;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class RoleDefinitionSuggestOracle
extends MultiWordSuggestOracle {
    private final Map<String, StrippedRoleDefinitionDTO> allRoles = new HashMap();
    private boolean initialized = false;
    private final UserManagementServiceAsync userManagementService;
    private final StringMessages stringMessages;

    public RoleDefinitionSuggestOracle(UserManagementServiceAsync userManagementService, StringMessages stringMessages) {
        this.userManagementService = userManagementService;
        this.stringMessages = stringMessages;
        this.refresh();
    }

    public void refresh() {
        this.initialized = false;
        this.userManagementService.getRoleDefinitions((AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    public StrippedRoleDefinitionDTO fromString(String roleName) {
        if (!this.initialized) {
            throw new NullPointerException("Role definitions are not loaded yet or could not be loaded.");
        }
        return (StrippedRoleDefinitionDTO)this.allRoles.get(roleName);
    }

    public void resetAndRemoveExistingRoles(Iterable<StrippedRoleDefinitionDTO> existingRoles) {
        ArrayList roles = new ArrayList(this.allRoles.values());
        Util.removeAll(existingRoles, roles);
        List textSuggestions = roles.stream().map(RoleDefinitionImpl::getName).collect(Collectors.toList());
        super.clear();
        super.setDefaultSuggestionsFromText(textSuggestions);
        super.addAll(textSuggestions);
    }

    static /* synthetic */ Map access$0(RoleDefinitionSuggestOracle roleDefinitionSuggestOracle) {
        return roleDefinitionSuggestOracle.allRoles;
    }

    static /* synthetic */ void access$1(RoleDefinitionSuggestOracle roleDefinitionSuggestOracle) {
        super.clear();
    }

    static /* synthetic */ void access$2(RoleDefinitionSuggestOracle roleDefinitionSuggestOracle, Collection collection) {
        super.setDefaultSuggestionsFromText(collection);
    }

    static /* synthetic */ void access$3(RoleDefinitionSuggestOracle roleDefinitionSuggestOracle, Collection collection) {
        super.addAll(collection);
    }

    static /* synthetic */ void access$4(RoleDefinitionSuggestOracle roleDefinitionSuggestOracle, boolean bl) {
        roleDefinitionSuggestOracle.initialized = bl;
    }

    static /* synthetic */ StringMessages access$5(RoleDefinitionSuggestOracle roleDefinitionSuggestOracle) {
        return roleDefinitionSuggestOracle.stringMessages;
    }
}

