/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.security.ui.client.component;

import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.CaptionPanel;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.ScrollPanel;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.view.client.MultiSelectionModel;
import com.sap.sse.common.Util;
import com.sap.sse.gwt.client.ErrorReporter;
import com.sap.sse.gwt.client.async.ParallelExecutionCallback;
import com.sap.sse.gwt.client.celltable.CellTableWithCheckboxResources;
import com.sap.sse.gwt.client.celltable.RefreshableMultiSelectionModel;
import com.sap.sse.gwt.client.celltable.RefreshableSelectionModel;
import com.sap.sse.gwt.client.celltable.TableWrapper;
import com.sap.sse.gwt.client.panels.LabeledAbstractFilterablePanel;
import com.sap.sse.security.shared.dto.UserGroupDTO;
import com.sap.sse.security.shared.impl.SecuredSecurityTypes;
import com.sap.sse.security.ui.client.UserManagementServiceAsync;
import com.sap.sse.security.ui.client.UserManagementWriteServiceAsync;
import com.sap.sse.security.ui.client.UserService;
import com.sap.sse.security.ui.client.component.AccessControlledButtonPanel;
import com.sap.sse.security.ui.client.component.CreateUserGroupDialog;
import com.sap.sse.security.ui.client.component.UserGroupListDataProvider;
import com.sap.sse.security.ui.client.component.UserGroupTableWrapper;
import com.sap.sse.security.ui.client.component.usergroup.roles.GroupRoleDefinitionPanel;
import com.sap.sse.security.ui.client.component.usergroup.users.UserGroupDetailPanel;
import com.sap.sse.security.ui.client.i18n.StringMessages;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class UserGroupManagementPanel
extends Composite {
    private final UserGroupListDataProvider userGroupListDataProvider;
    private UserGroupDetailPanel userGroupDetailPanel;
    private GroupRoleDefinitionPanel userGroupRoleDefinitionPanel;
    protected final UserGroupTableWrapper userGroupTableWrapper;

    public UserGroupManagementPanel(UserService userService, StringMessages stringMessages, ErrorReporter errorReporter, CellTableWithCheckboxResources tableResources) {
        UserManagementWriteServiceAsync userManagementWriteService = userService.getUserManagementWriteService();
        VerticalPanel mainPanel = new VerticalPanel();
        this.userGroupListDataProvider = new UserGroupListDataProvider((UserManagementServiceAsync)userManagementWriteService, new TextBox());
        this.userGroupTableWrapper = new UserGroupTableWrapper(userService, stringMessages, errorReporter, true, tableResources, () -> this.updateUserGroups());
        mainPanel.add(this.createButtonPanel(userService, stringMessages, userManagementWriteService, this.userGroupTableWrapper.getSelectionModel()));
        LabeledAbstractFilterablePanel userGroupfilterBox = this.userGroupTableWrapper.getFilterField();
        userGroupfilterBox.getElement().setPropertyString("placeholder", stringMessages.filterUserGroups());
        mainPanel.add((Widget)userGroupfilterBox);
        mainPanel.add((Widget)new ScrollPanel(this.userGroupTableWrapper.asWidget()));
        mainPanel.add((Widget)this.createUserGroupDetailsPanel(stringMessages, (UserManagementServiceAsync)userManagementWriteService, userService, errorReporter, tableResources));
        this.initWidget((Widget)mainPanel);
        this.ensureDebugId(this.getClass().getSimpleName());
    }

    private Widget createButtonPanel(UserService userService, StringMessages stringMessages, UserManagementWriteServiceAsync userManagementWriteService, RefreshableSelectionModel<UserGroupDTO> userGroupSelectionModel) {
        AccessControlledButtonPanel buttonPanel = new AccessControlledButtonPanel(userService, SecuredSecurityTypes.USER_GROUP);
        buttonPanel.addUnsecuredAction(stringMessages.refresh(), () -> this.updateUserGroups());
        Button createGroupButton = buttonPanel.addCreateActionWithoutServerCreateObjectPermissionCheck(stringMessages.createUserGroup(), () -> new CreateUserGroupDialog(stringMessages, userService, userManagementWriteService, this.userGroupListDataProvider, () -> this.updateUserGroups()).show());
        createGroupButton.ensureDebugId("CreateGroupButton");
        Button removeGroupButton = buttonPanel.addRemoveAction(stringMessages.removeUserGroup(), userGroupSelectionModel, false, () -> {
            Set userGroups = ((RefreshableMultiSelectionModel)this.userGroupTableWrapper.getSelectionModel()).getSelectedSet();
            if (userGroups == null || userGroups.isEmpty()) {
                Window.alert((String)stringMessages.youHaveToSelectAUserGroup());
            } else {
                String userGroupNames = String.join((CharSequence)", ", Util.map((Iterable)userGroups, g -> g.getName()));
                if (Window.confirm((String)stringMessages.doYouReallyWantToRemoveUserGroup(userGroupNames))) {
                    HashMap<UserGroupDTO, ParallelExecutionCallback> callbacks = new HashMap<UserGroupDTO, ParallelExecutionCallback>();
                    for (UserGroupDTO userGroupDTO : userGroups) {
                        callbacks.put(userGroupDTO, new ParallelExecutionCallback());
                    }
                    new /* Unavailable Anonymous Inner Class!! */;
                    for (Map.Entry entry : callbacks.entrySet()) {
                        userManagementWriteService.deleteUserGroup(((UserGroupDTO)entry.getKey()).getId().toString(), (AsyncCallback)entry.getValue());
                    }
                }
            }
        });
        removeGroupButton.ensureDebugId("DeleteUserGroupButton");
        return buttonPanel;
    }

    private HorizontalPanel createUserGroupDetailsPanel(StringMessages stringMessages, UserManagementServiceAsync userManagementService, UserService userService, ErrorReporter errorReporter, CellTableWithCheckboxResources tableResources) {
        this.userGroupDetailPanel = new UserGroupDetailPanel((MultiSelectionModel)this.userGroupTableWrapper.getSelectionModel(), this.userGroupListDataProvider, userService, stringMessages, errorReporter, tableResources);
        this.userGroupRoleDefinitionPanel = new GroupRoleDefinitionPanel(userService, stringMessages, errorReporter, tableResources, (MultiSelectionModel)this.userGroupTableWrapper.getSelectionModel(), this.userGroupListDataProvider);
        VerticalPanel userListWrapper = new VerticalPanel();
        userListWrapper.add((Widget)this.userGroupDetailPanel);
        CaptionPanel userListCaption = new CaptionPanel(stringMessages.users());
        userListCaption.add((Widget)userListWrapper);
        VerticalPanel roleWrapper = new VerticalPanel();
        roleWrapper.add((Widget)this.userGroupRoleDefinitionPanel);
        CaptionPanel roleCaption = new CaptionPanel(stringMessages.roles());
        roleCaption.add((Widget)roleWrapper);
        HorizontalPanel listsWrapper = new HorizontalPanel();
        listsWrapper.add((Widget)userListCaption);
        listsWrapper.add((Widget)roleCaption);
        listsWrapper.setVisible(false);
        ((RefreshableMultiSelectionModel)this.userGroupTableWrapper.getSelectionModel()).addSelectionChangeHandler(h -> listsWrapper.setVisible(TableWrapper.getSingleSelectedObjectOrNull((MultiSelectionModel)((MultiSelectionModel)this.userGroupTableWrapper.getSelectionModel())) != null));
        return listsWrapper;
    }

    public void updateUserGroups() {
        this.userGroupTableWrapper.refreshUserList(null);
        this.userGroupListDataProvider.updateDisplays();
        this.userGroupDetailPanel.updateUserList();
        this.userGroupRoleDefinitionPanel.updateUserGroups();
    }

    public void refreshSuggests() {
        this.userGroupRoleDefinitionPanel.refreshSuggest();
    }

    static /* synthetic */ UserGroupListDataProvider access$0(UserGroupManagementPanel userGroupManagementPanel) {
        return userGroupManagementPanel.userGroupListDataProvider;
    }
}

