/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.security.ui.client.component;

import com.google.gwt.user.cellview.client.AbstractCellTable;
import com.google.gwt.user.cellview.client.CellTable;
import com.google.gwt.user.cellview.client.Column;
import com.google.gwt.user.cellview.client.ColumnSortEvent;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.view.client.HasData;
import com.google.gwt.view.client.ListDataProvider;
import com.google.gwt.view.client.SelectionModel;
import com.sap.sse.common.Util;
import com.sap.sse.gwt.client.ErrorReporter;
import com.sap.sse.gwt.client.celltable.AbstractSortableTextColumn;
import com.sap.sse.gwt.client.celltable.CellTableWithCheckboxResources;
import com.sap.sse.gwt.client.celltable.EntityIdentityComparator;
import com.sap.sse.gwt.client.celltable.Flushable;
import com.sap.sse.gwt.client.celltable.FlushableCellTable;
import com.sap.sse.gwt.client.celltable.ImagesBarCell;
import com.sap.sse.gwt.client.celltable.RefreshableMultiSelectionModel;
import com.sap.sse.gwt.client.celltable.SelectionCheckboxColumn;
import com.sap.sse.gwt.client.dialog.DataEntryDialog;
import com.sap.sse.gwt.client.panels.LabeledAbstractFilterablePanel;
import com.sap.sse.security.shared.HasPermissions;
import com.sap.sse.security.shared.RoleDefinition;
import com.sap.sse.security.shared.RoleDefinitionImpl;
import com.sap.sse.security.shared.WildcardPermission;
import com.sap.sse.security.shared.dto.RoleDefinitionDTO;
import com.sap.sse.security.shared.dto.SecuredDTO;
import com.sap.sse.security.shared.impl.SecuredSecurityTypes;
import com.sap.sse.security.ui.client.UserManagementWriteServiceAsync;
import com.sap.sse.security.ui.client.UserService;
import com.sap.sse.security.ui.client.component.AccessControlledActionsColumn;
import com.sap.sse.security.ui.client.component.AccessControlledButtonPanel;
import com.sap.sse.security.ui.client.component.DefaultActionsImagesBarCell;
import com.sap.sse.security.ui.client.component.EditOwnershipDialog;
import com.sap.sse.security.ui.client.component.RoleDefinitionCreationDialog;
import com.sap.sse.security.ui.client.component.RoleDefinitionEditDialog;
import com.sap.sse.security.ui.client.component.RoleDefinitionsPanel;
import com.sap.sse.security.ui.client.component.SecuredDTOOwnerColumn;
import com.sap.sse.security.ui.client.component.editacl.EditACLDialog;
import com.sap.sse.security.ui.client.i18n.StringMessages;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;

public class RoleDefinitionsPanel
extends VerticalPanel {
    private final FlushableCellTable<RoleDefinitionDTO> roleDefinitionsTable;
    private final ErrorReporter errorReporter;
    private final UserService userService;
    private final UserManagementWriteServiceAsync userManagementWriteService;
    private final ListDataProvider<RoleDefinitionDTO> rolesListDataProvider;
    private final StringMessages stringMessages;
    protected final LabeledAbstractFilterablePanel<RoleDefinitionDTO> filterablePanelRoleDefinitions;
    private final RefreshableMultiSelectionModel<? super RoleDefinitionDTO> refreshableRoleDefinitionMultiSelectionModel;

    public RoleDefinitionsPanel(StringMessages stringMessages, UserService userService, CellTableWithCheckboxResources tableResources, ErrorReporter errorReporter) {
        this.ensureDebugId(this.getClass().getSimpleName());
        this.errorReporter = errorReporter;
        this.stringMessages = stringMessages;
        this.userService = userService;
        this.userManagementWriteService = userService.getUserManagementWriteService();
        this.rolesListDataProvider = new ListDataProvider();
        this.filterablePanelRoleDefinitions = new /* Unavailable Anonymous Inner Class!! */;
        this.filterablePanelRoleDefinitions.setUpdatePermissionFilterForCheckbox(role -> userService.hasPermission((SecuredDTO)role, (HasPermissions.Action)HasPermissions.DefaultActions.UPDATE));
        this.roleDefinitionsTable = this.createRoleDefinitionsTable(tableResources);
        this.roleDefinitionsTable.ensureDebugId("RolesCellTable");
        this.filterablePanelRoleDefinitions.getTextBox().ensureDebugId("RolesFilterTextBox");
        this.refreshableRoleDefinitionMultiSelectionModel = (RefreshableMultiSelectionModel)this.roleDefinitionsTable.getSelectionModel();
        AccessControlledButtonPanel buttonPanel = new AccessControlledButtonPanel(userService, SecuredSecurityTypes.ROLE_DEFINITION);
        buttonPanel.addUnsecuredAction(stringMessages.refresh(), () -> this.updateRoleDefinitions());
        Button createButton = buttonPanel.addCreateActionWithoutServerCreateObjectPermissionCheck(stringMessages.add(), () -> this.createRoleDefinition());
        createButton.ensureDebugId("CreateRoleButton");
        Button removeButton = buttonPanel.addRemoveAction(stringMessages.remove(), () -> {
            String roles = String.join((CharSequence)", ", Util.map((Iterable)this.getSelectedRoleDefinitions(), RoleDefinitionImpl::getName));
            if (Window.confirm((String)stringMessages.doYouReallyWantToRemoveRole(roles))) {
                HashSet selectedRoles = new HashSet(this.getSelectedRoleDefinitions());
                this.filterablePanelRoleDefinitions.removeAll(selectedRoles);
            }
        });
        removeButton.ensureDebugId("RemoveRoleButton");
        this.add((Widget)buttonPanel);
        this.add((Widget)this.filterablePanelRoleDefinitions);
        this.add((Widget)this.roleDefinitionsTable);
        this.updateRoleDefinitions();
    }

    private void createRoleDefinition() {
        new RoleDefinitionCreationDialog(this.stringMessages, (Iterable)this.getAllPermissions(), (Iterable)this.getAllRoleDefinitions(), (DataEntryDialog.DialogCallback)new /* Unavailable Anonymous Inner Class!! */).show();
    }

    private Set<RoleDefinitionDTO> getSelectedRoleDefinitions() {
        Set result = this.refreshableRoleDefinitionMultiSelectionModel.getSelectedSet();
        return result;
    }

    private FlushableCellTable<RoleDefinitionDTO> createRoleDefinitionsTable(CellTableWithCheckboxResources tableResources) {
        FlushableCellTable table = new FlushableCellTable(50, (CellTable.Resources)tableResources);
        this.rolesListDataProvider.addDataDisplay((HasData)table);
        SelectionCheckboxColumn roleSelectionCheckboxColumn = new SelectionCheckboxColumn(tableResources.cellTableStyle().cellTableCheckboxSelected(), tableResources.cellTableStyle().cellTableCheckboxDeselected(), tableResources.cellTableStyle().cellTableCheckboxColumnCell(), (EntityIdentityComparator)new /* Unavailable Anonymous Inner Class!! */, this.filterablePanelRoleDefinitions.getAllListDataProvider(), (Flushable)table);
        ColumnSortEvent.ListHandler columnSortHandler = new ColumnSortEvent.ListHandler(this.rolesListDataProvider.getList());
        table.addColumnSortHandler((ColumnSortEvent.Handler)columnSortHandler);
        columnSortHandler.setComparator((Column)roleSelectionCheckboxColumn, (Comparator)roleSelectionCheckboxColumn.getComparator());
        AbstractSortableTextColumn roleDefinitionUUidColumn = new AbstractSortableTextColumn(role -> role.getId() == null ? "<null>" : role.getId().toString(), columnSortHandler);
        AbstractSortableTextColumn roleDefinitionNameColumn = new AbstractSortableTextColumn(role -> role.getName(), columnSortHandler);
        4 permissionsColumn = new /* Unavailable Anonymous Inner Class!! */;
        permissionsColumn.setSortable(true);
        columnSortHandler.setComparator((Column)permissionsColumn, (Comparator)new /* Unavailable Anonymous Inner Class!! */);
        HasPermissions type = SecuredSecurityTypes.ROLE_DEFINITION;
        AccessControlledActionsColumn roleActionColumn = AccessControlledActionsColumn.create((ImagesBarCell)new DefaultActionsImagesBarCell(this.stringMessages), (UserService)this.userService);
        roleActionColumn.addAction(DefaultActionsImagesBarCell.ACTION_UPDATE, (HasPermissions.Action)HasPermissions.DefaultActions.UPDATE, arg_0 -> this.editRole(arg_0));
        roleActionColumn.addAction(DefaultActionsImagesBarCell.ACTION_DELETE, (HasPermissions.Action)HasPermissions.DefaultActions.DELETE, roleDefinition -> {
            if (Window.confirm((String)this.stringMessages.doYouReallyWantToRemoveRole(roleDefinition.getName()))) {
                this.removeRole((RoleDefinition)roleDefinition);
            }
        });
        EditOwnershipDialog.DialogConfig config = EditOwnershipDialog.create((UserManagementWriteServiceAsync)this.userManagementWriteService, (HasPermissions)type, roleDefinition -> this.updateRoleDefinitions(), (StringMessages)this.stringMessages);
        roleActionColumn.addAction(DefaultActionsImagesBarCell.ACTION_CHANGE_OWNERSHIP, (HasPermissions.Action)HasPermissions.DefaultActions.CHANGE_OWNERSHIP, arg_0 -> ((EditOwnershipDialog.DialogConfig)config).openOwnershipDialog(arg_0));
        EditACLDialog.DialogConfig configACL = EditACLDialog.create((UserManagementWriteServiceAsync)this.userService.getUserManagementWriteService(), (HasPermissions)type, roleDefinition -> this.updateRoleDefinitions(), (StringMessages)this.stringMessages);
        roleActionColumn.addAction(DefaultActionsImagesBarCell.ACTION_CHANGE_ACL, (HasPermissions.Action)HasPermissions.DefaultActions.CHANGE_ACL, arg_0 -> ((EditACLDialog.DialogConfig)configACL).openDialog(arg_0));
        table.addColumn((Column)roleSelectionCheckboxColumn, roleSelectionCheckboxColumn.getHeader());
        table.addColumn((Column)roleDefinitionNameColumn, this.stringMessages.name());
        table.addColumn((Column)permissionsColumn, this.stringMessages.permissions());
        SecuredDTOOwnerColumn.configureOwnerColumns((AbstractCellTable)table, (ColumnSortEvent.ListHandler)columnSortHandler, (StringMessages)this.stringMessages);
        table.addColumn((Column)roleDefinitionUUidColumn, this.stringMessages.id());
        table.addColumn((Column)roleActionColumn, this.stringMessages.actions());
        table.setSelectionModel((SelectionModel)roleSelectionCheckboxColumn.getSelectionModel(), roleSelectionCheckboxColumn.getSelectionManager());
        return table;
    }

    private void removeRole(RoleDefinition roleDefinition) {
        this.userManagementWriteService.deleteRoleDefinition(roleDefinition.getId().toString(), (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void editRole(RoleDefinition role) {
        Set allOtherRoles = this.getAllOtherRoles(role);
        Set allPermissionsAsStrings = this.getAllPermissions();
        new RoleDefinitionEditDialog(role, this.stringMessages, (Iterable)allPermissionsAsStrings, (Iterable)allOtherRoles, (DataEntryDialog.DialogCallback)new /* Unavailable Anonymous Inner Class!! */).show();
    }

    private Set<WildcardPermission> getAllPermissions() {
        HashSet<WildcardPermission> allPermissionsAsStrings = new HashSet<WildcardPermission>();
        for (HasPermissions permission : this.userService.getAllKnownPermissions()) {
            HasPermissions.Action[] actionArray = permission.getAvailableActions();
            int n = actionArray.length;
            int n2 = 0;
            while (n2 < n) {
                HasPermissions.Action action = actionArray[n2];
                allPermissionsAsStrings.add(permission.getPermission(new HasPermissions.Action[]{action}));
                ++n2;
            }
        }
        return allPermissionsAsStrings;
    }

    private Set<RoleDefinitionDTO> getAllOtherRoles(RoleDefinition role) {
        Set allOtherRoles = this.getAllRoleDefinitions();
        allOtherRoles.remove(role);
        return allOtherRoles;
    }

    private Set<RoleDefinitionDTO> getAllRoleDefinitions() {
        HashSet<RoleDefinitionDTO> allOtherRoles = new HashSet<RoleDefinitionDTO>();
        Util.addAll((Iterable)this.filterablePanelRoleDefinitions.getAll(), allOtherRoles);
        return allOtherRoles;
    }

    public void updateRoleDefinitions() {
        this.userManagementWriteService.getRoleDefinitions((AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    static /* synthetic */ FlushableCellTable access$0(RoleDefinitionsPanel roleDefinitionsPanel) {
        return roleDefinitionsPanel.roleDefinitionsTable;
    }

    static /* synthetic */ UserManagementWriteServiceAsync access$1(RoleDefinitionsPanel roleDefinitionsPanel) {
        return roleDefinitionsPanel.userManagementWriteService;
    }

    static /* synthetic */ ErrorReporter access$2(RoleDefinitionsPanel roleDefinitionsPanel) {
        return roleDefinitionsPanel.errorReporter;
    }

    static /* synthetic */ StringMessages access$3(RoleDefinitionsPanel roleDefinitionsPanel) {
        return roleDefinitionsPanel.stringMessages;
    }
}

