/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.security.ui.authentication.view;

import com.google.gwt.place.shared.Place;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.web.bindery.event.shared.Event;
import com.google.web.bindery.event.shared.EventBus;
import com.sap.sse.security.shared.HasPermissions;
import com.sap.sse.security.shared.dto.SecuredDTO;
import com.sap.sse.security.shared.impl.SecuredSecurityTypes;
import com.sap.sse.security.ui.authentication.AuthenticationContextEvent;
import com.sap.sse.security.ui.authentication.AuthenticationPlaceManagementController;
import com.sap.sse.security.ui.authentication.AuthenticationRequestEvent;
import com.sap.sse.security.ui.authentication.WrappedPlaceManagementController;
import com.sap.sse.security.ui.authentication.app.AuthenticationContext;
import com.sap.sse.security.ui.authentication.create.CreateAccountPlace;
import com.sap.sse.security.ui.authentication.view.AuthenticationMenuView;
import com.sap.sse.security.ui.authentication.view.FlyoutAuthenticationView;

public class FlyoutAuthenticationPresenter
implements AuthenticationMenuView.Presenter,
FlyoutAuthenticationView.Presenter {
    private final FlyoutAuthenticationView flyoutAuthenticationView;
    private final WrappedPlaceManagementController authenticationPlaceManagementController;
    private final AuthenticationMenuView authenticationMenuView;

    public FlyoutAuthenticationPresenter(FlyoutAuthenticationView flyoutAuthenticationView, AuthenticationMenuView authenticationMenuView, AuthenticationPlaceManagementController authenticationPlaceManagementController, EventBus eventBus, AuthenticationContext initialAuthentication) {
        this.flyoutAuthenticationView = flyoutAuthenticationView;
        this.authenticationMenuView = authenticationMenuView;
        this.authenticationPlaceManagementController = authenticationPlaceManagementController;
        flyoutAuthenticationView.setPresenter((FlyoutAuthenticationView.Presenter)this);
        authenticationMenuView.setPresenter((AuthenticationMenuView.Presenter)this);
        flyoutAuthenticationView.setAutoHidePartner((IsWidget)authenticationMenuView);
        eventBus.addHandler((Event.Type)AuthenticationRequestEvent.TYPE, event -> {
            flyoutAuthenticationView.show();
            authenticationPlaceManagementController.goTo(event.getRequestedPlace());
        });
        eventBus.addHandler((Event.Type)AuthenticationContextEvent.TYPE, (Object)new /* Unavailable Anonymous Inner Class!! */);
        authenticationMenuView.setAuthenticated(initialAuthentication.isLoggedIn());
        authenticationMenuView.showPremium(initialAuthentication.hasPermission((SecuredDTO)initialAuthentication.getCurrentUser(), (HasPermissions.Action)SecuredSecurityTypes.UserActions.BE_PREMIUM));
    }

    public void showRegister() {
        if (!this.flyoutAuthenticationView.isShowing()) {
            this.flyoutAuthenticationView.show();
            this.authenticationPlaceManagementController.start();
            this.authenticationPlaceManagementController.goTo((Place)new CreateAccountPlace());
        }
    }

    public void toggleFlyout() {
        if (this.flyoutAuthenticationView.isShowing()) {
            this.flyoutAuthenticationView.hide();
        } else {
            this.flyoutAuthenticationView.show();
            this.authenticationPlaceManagementController.start();
        }
    }

    public void onVisibilityChanged(boolean isShowing) {
        this.authenticationMenuView.setOpen(isShowing);
    }
}

