/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.security.ui.authentication.recover;

import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.DivElement;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.KeyUpEvent;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.uibinder.client.UiHandler;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.CheckBox;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.Widget;
import com.sap.sse.gwt.common.CommonSharedResources;
import com.sap.sse.security.ui.authentication.UserManagementResources;
import com.sap.sse.security.ui.authentication.recover.PasswordRecoveryView;
import com.sap.sse.security.ui.authentication.recover.PasswordRecoveryViewImpl;

public class PasswordRecoveryViewImpl
extends Composite
implements PasswordRecoveryView {
    private static PasswordRecoveryViewImplUiBinder uiBinder = (PasswordRecoveryViewImplUiBinder)GWT.create(PasswordRecoveryViewImplUiBinder.class);
    @UiField
    TextBox emailUi;
    @UiField
    TextBox usernameUi;
    @UiField
    CheckBox reallyUseLeadingOrTrailingSpacesInUsernameUi;
    @UiField
    Button resetPasswordUi;
    @UiField
    DivElement formErrorUi;
    @UiField(provided=true)
    final CommonSharedResources res;
    private PasswordRecoveryView.Presenter presenter;

    public PasswordRecoveryViewImpl(CommonSharedResources resources) {
        this.res = resources;
        UserManagementResources.INSTANCE.css().ensureInjected();
        this.initWidget((Widget)uiBinder.createAndBindUi((Object)this));
        this.usernameUi.addKeyUpHandler(e -> this.validate());
        this.reallyUseLeadingOrTrailingSpacesInUsernameUi.addValueChangeHandler(e -> this.validate());
    }

    private void validate() {
        String username = this.usernameUi.getValue();
        boolean usernameStartsOrEndsWithSpace = username.startsWith(" ") || username.endsWith(" ");
        this.reallyUseLeadingOrTrailingSpacesInUsernameUi.setVisible(usernameStartsOrEndsWithSpace);
        this.resetPasswordUi.setEnabled(!usernameStartsOrEndsWithSpace || this.reallyUseLeadingOrTrailingSpacesInUsernameUi.getValue() != false);
    }

    public void setPresenter(PasswordRecoveryView.Presenter presenter) {
        this.presenter = presenter;
    }

    public void setErrorMessage(String errorMessage) {
        this.formErrorUi.setInnerText(errorMessage);
        this.selectAll(this.usernameUi.getValue().isEmpty() ? this.emailUi : this.usernameUi);
    }

    protected void onLoad() {
        this.selectAll(this.emailUi);
    }

    @UiHandler(value={"resetPasswordUi"})
    void onResetPasswordUiControlClicked(ClickEvent event) {
        this.triggerPasswordReset();
    }

    @UiHandler(value={"emailUi", "usernameUi"})
    void onResetPasswordKeyPressed(KeyUpEvent event) {
        if (event.getNativeKeyCode() == 13) {
            this.triggerPasswordReset();
        }
    }

    private void triggerPasswordReset() {
        this.presenter.resetPassword(this.emailUi.getValue(), this.usernameUi.getValue());
    }

    private void selectAll(TextBox textBox) {
        textBox.setFocus(true);
        textBox.selectAll();
    }
}

