/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.security.ui.authentication;

import com.google.gwt.i18n.client.LocaleInfo;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.web.bindery.event.shared.Event;
import com.google.web.bindery.event.shared.EventBus;
import com.sap.sse.security.shared.dto.UserDTO;
import com.sap.sse.security.ui.authentication.AuthenticationManager;
import com.sap.sse.security.ui.authentication.AuthenticationManagerImpl;
import com.sap.sse.security.ui.authentication.AuthenticationPlaces;
import com.sap.sse.security.ui.authentication.AuthenticationRequestEvent;
import com.sap.sse.security.ui.authentication.AuthenticationSignOutRequestEvent;
import com.sap.sse.security.ui.authentication.ErrorMessageView;
import com.sap.sse.security.ui.authentication.app.AuthenticationContext;
import com.sap.sse.security.ui.authentication.app.AuthenticationContextImpl;
import com.sap.sse.security.ui.client.UserManagementWriteServiceAsync;
import com.sap.sse.security.ui.client.UserService;
import com.sap.sse.security.ui.client.UserStatusEventHandler;
import com.sap.sse.security.ui.client.WithSecurity;
import com.sap.sse.security.ui.client.i18n.StringMessages;
import com.sap.sse.security.ui.client.premium.PaywallResolver;
import com.sap.sse.security.ui.client.premium.PaywallResolverImpl;
import com.sap.sse.security.ui.shared.SuccessInfo;
import java.util.function.Consumer;

public class AuthenticationManagerImpl
implements AuthenticationManager {
    private final UserManagementWriteServiceAsync userManagementWriteService;
    private final UserService userService;
    private final EventBus eventBus;
    private final String emailConfirmationUrl;
    private final String passwordResetUrl;
    private final PaywallResolver paywallResolver;
    private final StringMessages i18n = StringMessages.INSTANCE;
    private final ErrorMessageView view = new ErrorMessageViewImpl(this, null);

    public AuthenticationManagerImpl(WithSecurity clientFactory, EventBus eventBus, String emailConfirmationUrl, String passwordResetUrl) {
        this(clientFactory.getUserManagementWriteService(), clientFactory.getUserService(), (PaywallResolver)new PaywallResolverImpl(clientFactory.getUserService(), clientFactory.getSubscriptionServiceFactory()), eventBus, emailConfirmationUrl, passwordResetUrl);
    }

    public AuthenticationManagerImpl(UserService userService, PaywallResolver paywallResolver, EventBus eventBus, String emailConfirmationUrl, String passwordResetUrl) {
        this(userService.getUserManagementWriteService(), userService, paywallResolver, eventBus, emailConfirmationUrl, passwordResetUrl);
    }

    private AuthenticationManagerImpl(UserManagementWriteServiceAsync userManagementWriteService, UserService userService, PaywallResolver paywallResolver, EventBus eventBus, String emailConfirmationUrl, String passwordResetUrl) {
        this.userManagementWriteService = userManagementWriteService;
        this.userService = userService;
        this.eventBus = eventBus;
        this.emailConfirmationUrl = emailConfirmationUrl;
        this.passwordResetUrl = passwordResetUrl;
        this.paywallResolver = paywallResolver;
        userService.addUserStatusEventHandler((UserStatusEventHandler)new /* Unavailable Anonymous Inner Class!! */);
        eventBus.addHandler((Event.Type)AuthenticationSignOutRequestEvent.TYPE, (Object)new /* Unavailable Anonymous Inner Class!! */);
        userService.addUserStatusEventHandler((UserStatusEventHandler)new /* Unavailable Anonymous Inner Class!! */, true);
    }

    public void createAccount(String name, String email, String password, String fullName, String locale, String company, AuthenticationManager.SuccessCallback<UserDTO> callback) {
        this.userManagementWriteService.createSimpleUser(name, email, password, fullName, company, locale, this.emailConfirmationUrl, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void requestPasswordReset(String username, String eMailAddress, AuthenticationManager.SuccessCallback<Void> callback) {
        this.userManagementWriteService.resetPassword(username, eMailAddress, this.passwordResetUrl, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void login(String username, String password, AuthenticationManager.SuccessCallback<SuccessInfo> callback) {
        this.userService.login(username, password, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void logout() {
        this.userService.logout();
        this.eventBus.fireEvent((Event)new AuthenticationRequestEvent(AuthenticationPlaces.SIGN_IN));
    }

    private void refreshUserInfo() {
        this.userService.updateUser(true);
    }

    public void updateUserProperties(String fullName, String company, String localeName, String defaultTenantIdAsString, AsyncCallback<UserDTO> callback) {
        UserDTO currentUser = this.getAuthenticationContext().getCurrentUser();
        String username = currentUser.getName();
        String locale = currentUser.getLocale();
        this.userManagementWriteService.updateUserProperties(username, fullName, company, localeName, defaultTenantIdAsString, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void redirectWithLocaleForAuthenticatedUser() {
        AuthenticationContext authenticationContext = this.getAuthenticationContext();
        if (authenticationContext.isLoggedIn()) {
            this.redirectIfLocaleIsSetAndLocaleIsNotGivenInTheURL(authenticationContext.getCurrentUser().getLocale());
        }
    }

    private void redirectIfLocaleIsSetAndLocaleIsNotGivenInTheURL(String locale) {
        if (this.shouldChangeLocale(locale)) {
            Window.Location.reload();
        }
    }

    private boolean shouldChangeLocale(String locale) {
        if (locale == null || locale.isEmpty()) {
            return false;
        }
        String localeParam = Window.Location.getParameter((String)LocaleInfo.getLocaleQueryParam());
        if (localeParam != null && !localeParam.isEmpty()) {
            return false;
        }
        String currentLocale = LocaleInfo.getCurrentLocale().getLocaleName();
        return !currentLocale.equals(locale);
    }

    public AuthenticationContext getAuthenticationContext() {
        return new AuthenticationContextImpl(this.userService.getCurrentUser(), this.userService, this.paywallResolver);
    }

    public void checkNewUserPopup(Runnable hideUserHintCallback, Consumer<Runnable> showUserHintCallback) {
        this.userService.addUserStatusEventHandler((UserStatusEventHandler)new /* Unavailable Anonymous Inner Class!! */, true);
    }

    static /* synthetic */ ErrorMessageView access$0(AuthenticationManagerImpl authenticationManagerImpl) {
        return authenticationManagerImpl.view;
    }

    static /* synthetic */ StringMessages access$1(AuthenticationManagerImpl authenticationManagerImpl) {
        return authenticationManagerImpl.i18n;
    }

    static /* synthetic */ void access$2(AuthenticationManagerImpl authenticationManagerImpl, String string) {
        authenticationManagerImpl.redirectIfLocaleIsSetAndLocaleIsNotGivenInTheURL(string);
    }

    static /* synthetic */ void access$3(AuthenticationManagerImpl authenticationManagerImpl) {
        authenticationManagerImpl.refreshUserInfo();
    }

    static /* synthetic */ UserService access$4(AuthenticationManagerImpl authenticationManagerImpl) {
        return authenticationManagerImpl.userService;
    }
}

