/*
 * Decompiled with CFR 0.152.
 */
package smile.validation;

import smile.math.Math;
import smile.validation.RegressionMeasure;

public class RSS
implements RegressionMeasure {
    @Override
    public double measure(double[] truth, double[] prediction) {
        if (truth.length != prediction.length) {
            throw new IllegalArgumentException(String.format("The vector sizes don't match: %d != %d.", truth.length, prediction.length));
        }
        int n = truth.length;
        double rss = 0.0;
        for (int i = 0; i < n; ++i) {
            rss += Math.sqr((double)(truth[i] - prediction[i]));
        }
        return rss;
    }

    public String toString() {
        return "RSS";
    }
}

