/*
 * Decompiled with CFR 0.152.
 */
package smile.validation;

import smile.validation.ClassificationMeasure;
import smile.validation.ConfusionMatrix;

public class MCCMeasure
implements ClassificationMeasure {
    @Override
    public double measure(int[] truth, int[] prediction) {
        if (truth.length != prediction.length) {
            throw new IllegalArgumentException(String.format("The vector sizes don't match: %d != %d.", truth.length, prediction.length));
        }
        ConfusionMatrix confusionMatrix = new ConfusionMatrix(truth, prediction);
        int[][] matrix = confusionMatrix.getMatrix();
        if (matrix.length != 2 || matrix[0].length != 2) {
            throw new IllegalArgumentException("MCC can only be applied to binary classification: " + confusionMatrix.toString());
        }
        int tp = matrix[0][0];
        int tn = matrix[1][1];
        int fp = matrix[0][1];
        int fn = matrix[1][0];
        int numerator = tp * tn - fp * fn;
        double denominator = Math.sqrt(tp + fp) * Math.sqrt(tp + fn) * Math.sqrt(tn + fp) * Math.sqrt(tn + fn);
        if (numerator == 0) {
            return 0.0;
        }
        if (denominator == 0.0) {
            throw new IllegalArgumentException("MCC can not be applied, denominator is 0 " + confusionMatrix.toString());
        }
        return (double)numerator / denominator;
    }
}

