/*
 * Decompiled with CFR 0.152.
 */
package smile.validation;

import smile.sort.QuickSort;

public class AUC {
    public static double measure(int[] truth, double[] probability) {
        if (truth.length != probability.length) {
            throw new IllegalArgumentException(String.format("The vector sizes don't match: %d != %d.", truth.length, probability.length));
        }
        double pos = 0.0;
        double neg = 0.0;
        for (int i = 0; i < truth.length; ++i) {
            if (truth[i] == 0) {
                neg += 1.0;
                continue;
            }
            if (truth[i] == 1) {
                pos += 1.0;
                continue;
            }
            throw new IllegalArgumentException("AUC is only for binary classification. Invalid label: " + truth[i]);
        }
        int[] label = (int[])truth.clone();
        double[] prediction = (double[])probability.clone();
        QuickSort.sort((double[])prediction, (int[])label);
        double[] rank = new double[label.length];
        for (int i = 0; i < prediction.length; ++i) {
            int j;
            if (i == prediction.length - 1 || prediction[i] != prediction[i + 1]) {
                rank[i] = i + 1;
                continue;
            }
            for (j = i + 1; j < prediction.length && prediction[j] == prediction[i]; ++j) {
            }
            double r = (double)(i + 1 + j) / 2.0;
            for (int k = i; k < j; ++k) {
                rank[k] = r;
            }
            i = j - 1;
        }
        double auc = 0.0;
        for (int i = 0; i < label.length; ++i) {
            if (label[i] != 1) continue;
            auc += rank[i];
        }
        auc = (auc - pos * (pos + 1.0) / 2.0) / (pos * neg);
        return auc;
    }
}

