/*
 * Decompiled with CFR 0.152.
 */
package smile.clustering;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.Callable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import smile.clustering.KMeans;
import smile.clustering.PartitionClustering;
import smile.math.Math;
import smile.util.MulticoreExecutor;

public class DENCLUE
extends PartitionClustering<double[]> {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(DENCLUE.class);
    private double eps = 1.0E-7;
    private double sigma;
    private double gamma;
    private double[][] attractors;
    private double[] radius;
    private double[][] samples;

    public DENCLUE(double[][] data, double sigma, int m) {
        int i;
        if (sigma <= 0.0) {
            throw new IllegalArgumentException("Invalid standard deviation of Gaussian kernel: " + sigma);
        }
        if (m <= 0) {
            throw new IllegalArgumentException("Invalid number of selected samples: " + m);
        }
        if (m < 10) {
            throw new IllegalArgumentException("The number of selected samples is too small: " + m);
        }
        this.sigma = sigma;
        this.gamma = -0.5 / (sigma * sigma);
        KMeans kmeans = new KMeans(data, m);
        this.samples = kmeans.centroids();
        int n = data.length;
        int d = data[0].length;
        this.attractors = new double[n][];
        for (int i2 = 0; i2 < n; ++i2) {
            this.attractors[i2] = (double[])data[i2].clone();
        }
        double[] attractor = new double[d];
        double[] prob = new double[n];
        this.radius = new double[n];
        int np = MulticoreExecutor.getThreadPoolSize();
        ArrayList<DENCLUEThread> tasks = null;
        if (n >= 1000 && np >= 2) {
            tasks = new ArrayList<DENCLUEThread>(np + 1);
            int step = n / np;
            if (step < 100) {
                step = 100;
            }
            int start = 0;
            int end = step;
            for (int i3 = 0; i3 < np - 1; ++i3) {
                tasks.add(new DENCLUEThread(prob, start, end));
                start += step;
                end += step;
            }
            tasks.add(new DENCLUEThread(prob, start, n));
            try {
                MulticoreExecutor.run(tasks);
            }
            catch (Exception ex) {
                logger.error("Failed to run DENCLUE on multi-core", (Throwable)ex);
                for (DENCLUEThread task : tasks) {
                    task.call();
                }
            }
        } else {
            for (int i4 = 0; i4 < n; ++i4) {
                double diff = 1.0;
                while (diff > this.eps) {
                    double weight = 0.0;
                    for (int j = 0; j < m; ++j) {
                        double w = Math.exp((double)(this.gamma * Math.squaredDistance((double[])this.attractors[i4], (double[])this.samples[j])));
                        weight += w;
                        for (int l = 0; l < d; ++l) {
                            int n2 = l;
                            attractor[n2] = attractor[n2] + w * this.samples[j][l];
                        }
                    }
                    int l = 0;
                    while (l < d) {
                        int n3 = l++;
                        attractor[n3] = attractor[n3] / weight;
                    }
                    diff = (weight /= (double)m) - prob[i4];
                    prob[i4] = weight;
                    if (diff > 1.0E-5) {
                        this.radius[i4] = 2.0 * Math.distance((double[])this.attractors[i4], (double[])attractor);
                    }
                    System.arraycopy(attractor, 0, this.attractors[i4], 0, d);
                    Arrays.fill(attractor, 0.0);
                }
            }
        }
        this.y = new int[n];
        ArrayList<double[]> cluster = new ArrayList<double[]>();
        ArrayList<Double> probability = new ArrayList<Double>();
        ArrayList<Double> step = new ArrayList<Double>();
        this.y[0] = 0;
        cluster.add(this.attractors[0]);
        probability.add(prob[0]);
        step.add(this.radius[0]);
        boolean newcluster = true;
        for (i = 1; i < n; ++i) {
            newcluster = true;
            for (int j = 0; j < cluster.size(); ++j) {
                if (!(Math.distance((double[])this.attractors[i], (double[])((double[])cluster.get(j))) < this.radius[i] + (Double)step.get(j))) continue;
                this.y[i] = j;
                newcluster = false;
                if (!(prob[i] > (Double)probability.get(j))) break;
                cluster.set(j, this.attractors[i]);
                probability.set(j, prob[i]);
                step.set(j, this.radius[i]);
                break;
            }
            if (!newcluster) continue;
            this.y[i] = cluster.size();
            cluster.add(this.attractors[i]);
            probability.add(prob[i]);
            step.add(this.radius[i]);
        }
        this.size = new int[cluster.size()];
        for (i = 0; i < n; ++i) {
            int n4 = this.y[i];
            this.size[n4] = this.size[n4] + 1;
        }
        this.k = cluster.size();
        this.attractors = new double[this.k][];
        for (i = 0; i < this.k; ++i) {
            this.attractors[i] = (double[])cluster.get(i);
        }
    }

    public double getSigma() {
        return this.sigma;
    }

    public double[][] getDensityAttractors() {
        return this.attractors;
    }

    @Override
    public int predict(double[] x) {
        int p = this.attractors[0].length;
        if (x.length != p) {
            throw new IllegalArgumentException(String.format("Invalid input vector size: %d, expected: %d", x.length, p));
        }
        double prob = 0.0;
        double diff = 1.0;
        double step = 0.0;
        double[] z = (double[])x.clone();
        double[] attractor = new double[p];
        while (diff > this.eps) {
            double weight = 0.0;
            for (int i = 0; i < this.samples.length; ++i) {
                double w = Math.exp((double)(this.gamma * Math.squaredDistance((double[])this.samples[i], (double[])z)));
                weight += w;
                for (int j = 0; j < p; ++j) {
                    int n = j;
                    attractor[n] = attractor[n] + w * this.samples[i][j];
                }
            }
            int j = 0;
            while (j < p) {
                int n = j++;
                attractor[n] = attractor[n] / weight;
            }
            diff = (weight /= (double)this.k) - prob;
            prob = weight;
            if (diff > 1.0E-5) {
                step = 2.0 * Math.distance((double[])attractor, (double[])z);
            }
            for (j = 0; j < p; ++j) {
                z[j] = attractor[j];
                attractor[j] = 0.0;
            }
        }
        for (int i = 0; i < this.k; ++i) {
            if (!(Math.distance((double[])this.attractors[i], (double[])z) < this.radius[i] + step)) continue;
            return i;
        }
        return Integer.MAX_VALUE;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("DENCLUE clusters of %d data points:%n", this.y.length));
        for (int i = 0; i < this.k; ++i) {
            int r = (int)Math.round((double)(1000.0 * (double)this.size[i] / (double)this.y.length));
            sb.append(String.format("%3d\t%5d (%2d.%1d%%)%n", i, this.size[i], r / 10, r % 10));
        }
        return sb.toString();
    }

    class DENCLUEThread
    implements Callable<DENCLUEThread> {
        final int start;
        final int end;
        double[] attractor;
        double[] prob;

        DENCLUEThread(double[] prob, int start, int end) {
            this.prob = prob;
            this.start = start;
            this.end = end;
            this.attractor = new double[DENCLUE.this.samples[0].length];
        }

        @Override
        public DENCLUEThread call() {
            int m = DENCLUE.this.samples.length;
            int d = DENCLUE.this.samples[0].length;
            for (int i = this.start; i < this.end; ++i) {
                double diff = 1.0;
                while (diff > DENCLUE.this.eps) {
                    double weight = 0.0;
                    for (int j = 0; j < m; ++j) {
                        double w = Math.exp((double)(DENCLUE.this.gamma * Math.squaredDistance((double[])DENCLUE.this.attractors[i], (double[])DENCLUE.this.samples[j])));
                        weight += w;
                        for (int l = 0; l < d; ++l) {
                            int n = l;
                            this.attractor[n] = this.attractor[n] + w * DENCLUE.this.samples[j][l];
                        }
                    }
                    int l = 0;
                    while (l < d) {
                        int n = l++;
                        this.attractor[n] = this.attractor[n] / weight;
                    }
                    diff = (weight /= (double)m) - this.prob[i];
                    this.prob[i] = weight;
                    if (diff > 1.0E-5) {
                        ((DENCLUE)DENCLUE.this).radius[i] = 2.0 * Math.distance((double[])DENCLUE.this.attractors[i], (double[])this.attractor);
                    }
                    System.arraycopy(this.attractor, 0, DENCLUE.this.attractors[i], 0, d);
                    Arrays.fill(this.attractor, 0.0);
                }
            }
            return this;
        }
    }
}

