/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.remote;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.util.CharsetUtil;
import io.netty.util.Timeout;
import io.netty.util.TimerTask;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.redisson.RedissonBlockingQueue;
import org.redisson.RedissonMap;
import org.redisson.api.RBlockingQueue;
import org.redisson.api.RFuture;
import org.redisson.api.RMap;
import org.redisson.api.RemoteInvocationOptions;
import org.redisson.api.annotation.RRemoteAsync;
import org.redisson.api.annotation.RRemoteReactive;
import org.redisson.api.annotation.RRemoteRx;
import org.redisson.client.codec.Codec;
import org.redisson.client.codec.StringCodec;
import org.redisson.codec.CompositeCodec;
import org.redisson.command.CommandAsyncExecutor;
import org.redisson.executor.RemotePromise;
import org.redisson.misc.Hash;
import org.redisson.remote.AsyncRemoteProxy;
import org.redisson.remote.ReactiveRemoteProxy;
import org.redisson.remote.RemoteServiceRequest;
import org.redisson.remote.RxRemoteProxy;
import org.redisson.remote.SyncRemoteProxy;

public abstract class BaseRemoteService {
    private final Map<Class<?>, String> requestQueueNameCache = new ConcurrentHashMap();
    private final ConcurrentMap<Method, long[]> methodSignaturesCache = new ConcurrentHashMap<Method, long[]>();
    protected final Codec codec;
    protected final String name;
    protected final CommandAsyncExecutor commandExecutor;
    protected final String executorId;
    protected final String cancelRequestMapName;
    protected final String cancelResponseMapName;
    protected final String responseQueueName;

    public BaseRemoteService(Codec codec, String name, CommandAsyncExecutor commandExecutor, String executorId) {
        this.codec = commandExecutor.getServiceManager().getCodec(codec);
        this.name = commandExecutor.getServiceManager().getConfig().getNameMapper().map(name);
        this.commandExecutor = commandExecutor;
        this.executorId = executorId;
        this.cancelRequestMapName = "{" + name + ":remote}:cancel-request";
        this.cancelResponseMapName = "{" + name + ":remote}:cancel-response";
        this.responseQueueName = this.getResponseQueueName(executorId);
    }

    public String getResponseQueueName(String executorId) {
        return "{remote_response}:" + executorId;
    }

    protected String getAckName(String requestId) {
        return "{" + this.name + ":remote}:" + requestId + ":ack";
    }

    public String getRequestQueueName(Class<?> remoteInterface) {
        return this.requestQueueNameCache.computeIfAbsent(remoteInterface, k -> "{" + this.name + ":" + k.getName() + "}");
    }

    protected ByteBuf encode(Object obj) {
        try {
            return this.codec.getValueEncoder().encode(obj);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public <T> T get(Class<T> remoteInterface) {
        return this.get(remoteInterface, RemoteInvocationOptions.defaults());
    }

    public <T> T get(Class<T> remoteInterface, long executionTimeout, TimeUnit executionTimeUnit) {
        return this.get(remoteInterface, RemoteInvocationOptions.defaults().expectResultWithin(executionTimeout, executionTimeUnit));
    }

    public <T> T get(Class<T> remoteInterface, long executionTimeout, TimeUnit executionTimeUnit, long ackTimeout, TimeUnit ackTimeUnit) {
        return this.get(remoteInterface, RemoteInvocationOptions.defaults().expectAckWithin(ackTimeout, ackTimeUnit).expectResultWithin(executionTimeout, executionTimeUnit));
    }

    public <T> T get(Class<T> remoteInterface, RemoteInvocationOptions options) {
        for (Annotation annotation : remoteInterface.getAnnotations()) {
            if (annotation.annotationType() == RRemoteAsync.class) {
                Class<?> syncInterface = ((RRemoteAsync)annotation).value();
                AsyncRemoteProxy proxy = new AsyncRemoteProxy(this.commandExecutor, this.name, this.responseQueueName, this.codec, this.executorId, this.cancelRequestMapName, this);
                return proxy.create(remoteInterface, options, syncInterface);
            }
            if (annotation.annotationType() == RRemoteReactive.class) {
                Class<?> syncInterface = ((RRemoteReactive)annotation).value();
                ReactiveRemoteProxy proxy = new ReactiveRemoteProxy(this.commandExecutor, this.name, this.responseQueueName, this.codec, this.executorId, this.cancelRequestMapName, this);
                return proxy.create(remoteInterface, options, syncInterface);
            }
            if (annotation.annotationType() != RRemoteRx.class) continue;
            Class<?> syncInterface = ((RRemoteRx)annotation).value();
            RxRemoteProxy proxy = new RxRemoteProxy(this.commandExecutor, this.name, this.responseQueueName, this.codec, this.executorId, this.cancelRequestMapName, this);
            return proxy.create(remoteInterface, options, syncInterface);
        }
        SyncRemoteProxy proxy = new SyncRemoteProxy(this.commandExecutor, this.name, this.responseQueueName, this.codec, this.executorId, this);
        return proxy.create(remoteInterface, options);
    }

    protected long getTimeout(Long executionTimeoutInMillis, RemoteServiceRequest request) {
        return executionTimeoutInMillis;
    }

    protected <K, V> RMap<K, V> getMap(String name) {
        return new RedissonMap(new CompositeCodec(StringCodec.INSTANCE, this.codec, this.codec), this.commandExecutor, name);
    }

    protected <T> void scheduleCheck(final String mapName, final String requestId, final CompletableFuture<T> cancelRequest) {
        this.commandExecutor.getServiceManager().newTimeout(new TimerTask(){

            public void run(Timeout timeout) throws Exception {
                if (cancelRequest.isDone()) {
                    return;
                }
                RMap canceledRequests = BaseRemoteService.this.getMap(mapName);
                RFuture future = canceledRequests.removeAsync(requestId);
                future.whenComplete((request, ex) -> {
                    if (cancelRequest.isDone()) {
                        return;
                    }
                    if (ex != null) {
                        BaseRemoteService.this.scheduleCheck(mapName, requestId, cancelRequest);
                        return;
                    }
                    if (request == null) {
                        BaseRemoteService.this.scheduleCheck(mapName, requestId, cancelRequest);
                    } else {
                        cancelRequest.complete(request);
                    }
                });
            }
        }, 3000L, TimeUnit.MILLISECONDS);
    }

    protected String generateRequestId(Object[] args) {
        return this.commandExecutor.getServiceManager().generateId();
    }

    protected abstract CompletableFuture<Boolean> addAsync(String var1, RemoteServiceRequest var2, RemotePromise<Object> var3);

    protected abstract CompletableFuture<Boolean> removeAsync(String var1, String var2);

    protected long[] getMethodSignature(Method method) {
        long[] result = (long[])this.methodSignaturesCache.get(method);
        if (result == null) {
            String str = Arrays.stream(method.getParameterTypes()).map(c -> c.getName()).collect(Collectors.joining());
            ByteBuf buf = Unpooled.copiedBuffer((CharSequence)str, (Charset)CharsetUtil.UTF_8);
            result = Hash.hash128(buf);
            buf.release();
            long[] oldResult = this.methodSignaturesCache.putIfAbsent(method, result);
            if (oldResult != null) {
                return oldResult;
            }
        }
        return result;
    }

    protected <V> RBlockingQueue<V> getBlockingQueue(String name, Codec codec) {
        return new RedissonBlockingQueue(codec, this.commandExecutor, name);
    }
}

