/*
 * Decompiled with CFR 0.152.
 */
package org.redisson;

import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import org.redisson.RedissonLock;
import org.redisson.RedissonLockEntry;
import org.redisson.api.RFuture;
import org.redisson.api.RLock;
import org.redisson.client.codec.LongCodec;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.client.protocol.RedisStrictCommand;
import org.redisson.command.CommandAsyncExecutor;
import org.redisson.pubsub.LockPubSub;

public class RedissonFairLock
extends RedissonLock
implements RLock {
    private final long threadWaitTime;
    private final CommandAsyncExecutor commandExecutor;
    private final String threadsQueueName;
    private final String timeoutSetName;

    public RedissonFairLock(CommandAsyncExecutor commandExecutor, String name) {
        this(commandExecutor, name, 300000L);
    }

    public RedissonFairLock(CommandAsyncExecutor commandExecutor, String name, long threadWaitTime) {
        super(commandExecutor, name);
        this.commandExecutor = commandExecutor;
        this.threadWaitTime = threadWaitTime;
        this.threadsQueueName = RedissonFairLock.prefixName("redisson_lock_queue", name);
        this.timeoutSetName = RedissonFairLock.prefixName("redisson_lock_timeout", name);
    }

    @Override
    protected CompletableFuture<RedissonLockEntry> subscribe(long threadId) {
        return this.pubSub.subscribe(this.getEntryName() + ":" + threadId, this.getChannelName() + ":" + this.getLockName(threadId));
    }

    @Override
    protected void unsubscribe(RedissonLockEntry entry, long threadId) {
        this.pubSub.unsubscribe(entry, this.getEntryName() + ":" + threadId, this.getChannelName() + ":" + this.getLockName(threadId));
    }

    @Override
    protected CompletableFuture<Void> acquireFailedAsync(long waitTime, TimeUnit unit, long threadId) {
        long wait = this.threadWaitTime;
        if (waitTime > 0L) {
            wait = unit.toMillis(waitTime);
        }
        RFuture<Void> f = this.evalWriteSyncedAsync(this.getRawName(), LongCodec.INSTANCE, RedisCommands.EVAL_VOID, "local queue = redis.call('lrange', KEYS[1], 0, -1);local i = 1;while i <= #queue and queue[i] ~= ARGV[1] do i = i + 1;end;i = i + 1;while i <= #queue do redis.call('zincrby', KEYS[2], -tonumber(ARGV[2]), queue[i]);i = i + 1;end;redis.call('zrem', KEYS[2], ARGV[1]);redis.call('lrem', KEYS[1], 0, ARGV[1]);", Arrays.asList(this.threadsQueueName, this.timeoutSetName), this.getLockName(threadId), wait);
        return f.toCompletableFuture();
    }

    @Override
    <T> RFuture<T> tryLockInnerAsync(long waitTime, long leaseTime, TimeUnit unit, long threadId, RedisStrictCommand<T> command) {
        long wait = this.threadWaitTime;
        if (waitTime > 0L) {
            wait = unit.toMillis(waitTime);
        }
        long currentTime = System.currentTimeMillis();
        if (command == RedisCommands.EVAL_NULL_BOOLEAN) {
            return this.commandExecutor.syncedEval(this.getRawName(), LongCodec.INSTANCE, command, "while true do local firstThreadId2 = redis.call('lindex', KEYS[2], 0);if firstThreadId2 == false then break;end;local timeout = tonumber(redis.call('zscore', KEYS[3], firstThreadId2));if timeout <= tonumber(ARGV[3]) then redis.call('zrem', KEYS[3], firstThreadId2);redis.call('lpop', KEYS[2]);else break;end;end;if (redis.call('exists', KEYS[1]) == 0) and ((redis.call('exists', KEYS[2]) == 0) or (redis.call('lindex', KEYS[2], 0) == ARGV[2])) then redis.call('lpop', KEYS[2]);redis.call('zrem', KEYS[3], ARGV[2]);local keys = redis.call('zrange', KEYS[3], 0, -1);for i = 1, #keys, 1 do redis.call('zincrby', KEYS[3], -tonumber(ARGV[4]), keys[i]);end;redis.call('hset', KEYS[1], ARGV[2], 1);redis.call('pexpire', KEYS[1], ARGV[1]);return nil;end;if (redis.call('hexists', KEYS[1], ARGV[2]) == 1) then redis.call('hincrby', KEYS[1], ARGV[2], 1);redis.call('pexpire', KEYS[1], ARGV[1]);return nil;end;return 1;", Arrays.asList(this.getRawName(), this.threadsQueueName, this.timeoutSetName), unit.toMillis(leaseTime), this.getLockName(threadId), currentTime, wait);
        }
        if (command == RedisCommands.EVAL_LONG) {
            return this.commandExecutor.syncedEval(this.getRawName(), LongCodec.INSTANCE, command, "while true do local firstThreadId2 = redis.call('lindex', KEYS[2], 0);if firstThreadId2 == false then break;end;local timeout = tonumber(redis.call('zscore', KEYS[3], firstThreadId2));if timeout <= tonumber(ARGV[4]) then redis.call('zrem', KEYS[3], firstThreadId2);redis.call('lpop', KEYS[2]);else break;end;end;if (redis.call('exists', KEYS[1]) == 0) and ((redis.call('exists', KEYS[2]) == 0) or (redis.call('lindex', KEYS[2], 0) == ARGV[2])) then redis.call('lpop', KEYS[2]);redis.call('zrem', KEYS[3], ARGV[2]);local keys = redis.call('zrange', KEYS[3], 0, -1);for i = 1, #keys, 1 do redis.call('zincrby', KEYS[3], -tonumber(ARGV[3]), keys[i]);end;redis.call('hset', KEYS[1], ARGV[2], 1);redis.call('pexpire', KEYS[1], ARGV[1]);return nil;end;if redis.call('hexists', KEYS[1], ARGV[2]) == 1 then redis.call('hincrby', KEYS[1], ARGV[2],1);redis.call('pexpire', KEYS[1], ARGV[1]);return nil;end;local timeout = redis.call('zscore', KEYS[3], ARGV[2]);if timeout ~= false then return timeout - tonumber(ARGV[3]) - tonumber(ARGV[4]);end;local lastThreadId = redis.call('lindex', KEYS[2], -1);local ttl;if lastThreadId ~= false and lastThreadId ~= ARGV[2] then ttl = tonumber(redis.call('zscore', KEYS[3], lastThreadId)) - tonumber(ARGV[4]);else ttl = redis.call('pttl', KEYS[1]);end;local timeout = ttl + tonumber(ARGV[3]) + tonumber(ARGV[4]);if redis.call('zadd', KEYS[3], timeout, ARGV[2]) == 1 then redis.call('rpush', KEYS[2], ARGV[2]);end;return ttl;", Arrays.asList(this.getRawName(), this.threadsQueueName, this.timeoutSetName), unit.toMillis(leaseTime), this.getLockName(threadId), wait, currentTime);
        }
        throw new IllegalArgumentException();
    }

    @Override
    protected RFuture<Boolean> unlockInnerAsync(long threadId, String requestId, int timeout) {
        return this.evalWriteSyncedAsync(this.getRawName(), LongCodec.INSTANCE, RedisCommands.EVAL_BOOLEAN, "local val = redis.call('get', KEYS[5]); if val ~= false then return tonumber(val);end; while true do local firstThreadId2 = redis.call('lindex', KEYS[2], 0);if firstThreadId2 == false then break;end; local timeout = tonumber(redis.call('zscore', KEYS[3], firstThreadId2));if timeout <= tonumber(ARGV[4]) then redis.call('zrem', KEYS[3], firstThreadId2); redis.call('lpop', KEYS[2]); else break;end; end;if (redis.call('exists', KEYS[1]) == 0) then local nextThreadId = redis.call('lindex', KEYS[2], 0); if nextThreadId ~= false then redis.call(ARGV[5], KEYS[4] .. ':' .. nextThreadId, ARGV[1]); end; redis.call('set', KEYS[5], 1, 'px', ARGV[6]); return 1; end;if (redis.call('hexists', KEYS[1], ARGV[3]) == 0) then return nil;end; local counter = redis.call('hincrby', KEYS[1], ARGV[3], -1); if (counter > 0) then redis.call('pexpire', KEYS[1], ARGV[2]); redis.call('set', KEYS[5], 0, 'px', ARGV[6]); return 0; end; redis.call('del', KEYS[1]); redis.call('set', KEYS[5], 1, 'px', ARGV[6]); local nextThreadId = redis.call('lindex', KEYS[2], 0); if nextThreadId ~= false then redis.call(ARGV[5], KEYS[4] .. ':' .. nextThreadId, ARGV[1]); end; return 1; ", Arrays.asList(this.getRawName(), this.threadsQueueName, this.timeoutSetName, this.getChannelName(), this.getUnlockLatchName(requestId)), LockPubSub.UNLOCK_MESSAGE, this.internalLockLeaseTime, this.getLockName(threadId), System.currentTimeMillis(), this.getSubscribeService().getPublishCommand(), timeout);
    }

    @Override
    public Condition newCondition() {
        throw new UnsupportedOperationException();
    }

    @Override
    public RFuture<Boolean> deleteAsync() {
        return this.deleteAsync(this.getRawName(), this.threadsQueueName, this.timeoutSetName);
    }

    @Override
    public RFuture<Long> sizeInMemoryAsync() {
        List<Object> keys = Arrays.asList(this.getRawName(), this.threadsQueueName, this.timeoutSetName);
        return super.sizeInMemoryAsync(keys);
    }

    @Override
    public RFuture<Boolean> expireAsync(long timeToLive, TimeUnit timeUnit, String param, String ... keys) {
        return super.expireAsync(timeToLive, timeUnit, param, this.getRawName(), this.threadsQueueName, this.timeoutSetName);
    }

    @Override
    protected RFuture<Boolean> expireAtAsync(long timestamp, String param, String ... keys) {
        return super.expireAtAsync(timestamp, param, this.getRawName(), this.threadsQueueName, this.timeoutSetName);
    }

    @Override
    public RFuture<Boolean> clearExpireAsync() {
        return this.clearExpireAsync(this.getRawName(), this.threadsQueueName, this.timeoutSetName);
    }

    @Override
    public RFuture<Boolean> forceUnlockAsync() {
        this.cancelExpirationRenewal(null, null);
        return this.commandExecutor.syncedEvalWithRetry(this.getRawName(), LongCodec.INSTANCE, RedisCommands.EVAL_BOOLEAN, "while true do local firstThreadId2 = redis.call('lindex', KEYS[2], 0);if firstThreadId2 == false then break;end; local timeout = tonumber(redis.call('zscore', KEYS[3], firstThreadId2));if timeout <= tonumber(ARGV[2]) then redis.call('zrem', KEYS[3], firstThreadId2); redis.call('lpop', KEYS[2]); else break;end; end;if (redis.call('del', KEYS[1]) == 1) then local nextThreadId = redis.call('lindex', KEYS[2], 0); if nextThreadId ~= false then redis.call(ARGV[3], KEYS[4] .. ':' .. nextThreadId, ARGV[1]); end; return 1; end; return 0;", Arrays.asList(this.getRawName(), this.threadsQueueName, this.timeoutSetName, this.getChannelName()), LockPubSub.UNLOCK_MESSAGE, System.currentTimeMillis(), this.getSubscribeService().getPublishCommand());
    }
}

