/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.monitoring.sysinfo;

import com.sap.sailing.monitoring.sysinfo.ProcessInformation;
import com.sap.sailing.monitoring.sysinfo.ProcessInformationImpl;
import com.sap.sailing.monitoring.sysinfo.SystemInformation;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.hyperic.sigar.FileSystem;
import org.hyperic.sigar.NetConnection;
import org.hyperic.sigar.Sigar;
import org.hyperic.sigar.SigarException;

public class SystemInformationImpl
implements SystemInformation {
    private Sigar sigar_manager;
    private OperatingSystemMXBean java_manager;
    private static SystemInformation singleton = null;
    private long used_sockets = -1L;
    private long allocated_tcp_connections = -1L;
    private long used_tcp_connections = -1L;

    public static synchronized SystemInformation getInstance() {
        if (singleton == null) {
            try {
                singleton = new SystemInformationImpl();
            }
            catch (SigarException ex) {
                singleton = null;
            }
        }
        return singleton;
    }

    public SystemInformationImpl() throws SigarException {
        Sigar.load();
        this.sigar_manager = new Sigar();
        this.java_manager = ManagementFactory.getOperatingSystemMXBean();
    }

    protected String[] readProc(String path) {
        String line = "";
        StringBuffer buf = new StringBuffer();
        BufferedReader reader = null;
        try {
            try {
                reader = new BufferedReader(new FileReader(path));
                while ((line = reader.readLine()) != null) {
                    buf.append(line).append("\n");
                }
            }
            catch (Exception ex) {
                String[] stringArray = new String[]{};
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                return stringArray;
            }
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
        }
        return buf.toString().split("\\n");
    }

    protected void parseSockStat() {
        String[] sockstat = new String[]{};
        try {
            sockstat = this.readProc("/proc/" + this.getPid() + "/net/sockstat");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (sockstat.length == 0) {
            sockstat = this.readProc("/proc/net/sockstat");
        }
        String[] stringArray = sockstat;
        int n = sockstat.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            String[] parts = line.split(" ");
            if (parts[0].equalsIgnoreCase("sockets:")) {
                this.used_sockets = Long.parseLong(parts[2].trim());
            }
            if (parts[0].equalsIgnoreCase("TCP:")) {
                this.allocated_tcp_connections = Long.parseLong(parts[8].trim());
                this.used_tcp_connections = Long.parseLong(parts[2].trim());
            }
            ++n2;
        }
    }

    @Override
    public ProcessInformation getProcessInformation(long pid) {
        return new ProcessInformationImpl(pid, this.sigar_manager);
    }

    @Override
    public long getOutbundOpenConnectionCount() throws Exception {
        int flags = 49;
        NetConnection[] connections = this.sigar_manager.getNetConnectionList(flags);
        return connections.length;
    }

    @Override
    public long getInboundOpenConnectionCount() throws Exception {
        int flags = 50;
        NetConnection[] connections = this.sigar_manager.getNetConnectionList(flags);
        return connections.length;
    }

    @Override
    public long getMaxOpenSockets() throws Exception {
        return this.getMaxOpenFiles();
    }

    @Override
    public long getUsedSockets() {
        this.parseSockStat();
        return this.used_sockets;
    }

    @Override
    public long getAllocatedTCPConnections() {
        this.parseSockStat();
        return this.allocated_tcp_connections;
    }

    @Override
    public long getTCPConnectionsInUse() {
        this.parseSockStat();
        return this.used_tcp_connections;
    }

    @Override
    public long getOpenFiles() {
        String[] val = this.readProc("/proc/sys/fs/file-nr");
        if (val.length > 0) {
            return Long.parseLong(val[0].split("\t| ")[0].trim());
        }
        return -1L;
    }

    @Override
    public long getMaxOpenFiles() throws Exception {
        String[] val = this.readProc("/proc/sys/fs/file-max");
        if (val.length > 0) {
            return Long.parseLong(val[0].trim());
        }
        return -1L;
    }

    @Override
    public long getMaxInMemoryINodes() throws Exception {
        String[] val = this.readProc("/proc/sys/fs/inode-max");
        if (val.length > 0) {
            return Long.parseLong(val[0].trim());
        }
        return -1L;
    }

    @Override
    public long getPid() throws Exception {
        return this.sigar_manager.getPid();
    }

    @Override
    public double getLastLoadAverage() throws Exception {
        return this.java_manager.getSystemLoadAverage();
    }

    @Override
    public NetConnection[] getOpenNetworkConnections(int flags) throws Exception {
        return this.sigar_manager.getNetConnectionList(flags);
    }

    @Override
    public long getTotalRunningProcesses() throws Exception {
        return this.sigar_manager.getProcStat().getRunning();
    }

    @Override
    public long getTotalStoppedProcesses() throws Exception {
        return this.sigar_manager.getProcStat().getStopped();
    }

    @Override
    public long getTotalZombieProcesses() throws Exception {
        return this.sigar_manager.getProcStat().getZombie();
    }

    @Override
    public long getTotalProcesses() throws Exception {
        return this.sigar_manager.getProcStat().getTotal();
    }

    @Override
    public long getFreeMemoryGlobal() throws Exception {
        return this.sigar_manager.getMem().getFree();
    }

    @Override
    public long getFreeMemoryJVM() {
        return Runtime.getRuntime().freeMemory();
    }

    @Override
    public long getTotalMemoryJVM() {
        return Runtime.getRuntime().totalMemory();
    }

    @Override
    public Map<String, Long> getFreeFileNodes() throws Exception {
        HashMap<String, Long> result = new HashMap<String, Long>();
        FileSystem[] fileSystemArray = this.sigar_manager.getFileSystemList();
        int n = fileSystemArray.length;
        int n2 = 0;
        while (n2 < n) {
            FileSystem fs = fileSystemArray[n2];
            if (fs.getType() == 2) {
                result.put(fs.getDirName(), this.sigar_manager.getFileSystemUsage(fs.getDirName()).getFreeFiles());
            }
            ++n2;
        }
        return result;
    }

    public String toString() {
        StringBuffer result = new StringBuffer("");
        try {
            NetConnection ns;
            result.append("General:\n");
            result.append(this.getLastLoadAverage()).append(" (load avg)").append("\n");
            result.append(this.getTotalRunningProcesses()).append(" (total processes running)").append("\n");
            result.append(this.getTotalStoppedProcesses()).append(" (total processes stopped)").append("\n");
            result.append(this.getTotalZombieProcesses()).append(" (total processes zombie)").append("\n");
            result.append(this.getTotalProcesses()).append(" (total)").append("\n");
            result.append("\nMemory:\n");
            result.append(String.valueOf(this.getFreeMemoryGlobal() / 1000L) + "kb (free, not cached, not inactive)\n");
            result.append(String.valueOf(this.getFreeMemoryJVM() / 1000L) + "kb (free JVM)\n");
            result.append(String.valueOf((this.getTotalMemoryJVM() - this.getFreeMemoryJVM()) / 1000L) + "kb (used JVM)\n");
            result.append(String.valueOf(this.getTotalMemoryJVM() / 1000L) + "kb (total JVM)\n");
            result.append("\nOpen files:\n").append(this.getOpenFiles()).append(" / ").append(this.getUsedSockets()).append(" (normal / sockets)").append("\n").append(this.getMaxOpenFiles()).append(" (max, also socket max)").append("\n").append(this.getMaxInMemoryINodes()).append(" (max in-memory inodes)").append("\n");
            result.append("\nNet:\n" + this.getTCPConnectionsInUse() + " (tcp conn in use)\n" + this.getAllocatedTCPConnections() + " (alloc'd tcp conn)\n" + this.getUsedSockets() + " (used sockets)").append("\n");
            result.append(this.getOutbundOpenConnectionCount()).append(" (outbound conn count)").append("\n").append(this.getInboundOpenConnectionCount()).append(" (inbound conn count)").append("\n");
            int flags = 50;
            NetConnection[] connections = this.getOpenNetworkConnections(flags);
            result.append("\nCalling Process Statistics:\n");
            result.append(this.getProcessInformation(this.getPid()) + "\n");
            result.append("\nOpen Local Ports:\n");
            NetConnection[] netConnectionArray = connections;
            int n = connections.length;
            int n2 = 0;
            while (n2 < n) {
                ns = netConnectionArray[n2];
                if (ns.getRemoteAddress().equalsIgnoreCase("0.0.0.0") || ns.getRemoteAddress().equalsIgnoreCase("127.0.0.1") || ns.getRemoteAddress().equalsIgnoreCase("::")) {
                    result.append(String.valueOf(ns.getLocalAddress()) + ":" + ns.getLocalPort()).append("\n");
                }
                ++n2;
            }
            flags = 49;
            connections = this.getOpenNetworkConnections(flags);
            result.append("\nOutbound Connections:\n");
            netConnectionArray = connections;
            n = connections.length;
            n2 = 0;
            while (n2 < n) {
                ns = netConnectionArray[n2];
                result.append(String.valueOf(ns.getLocalAddress()) + ":" + ns.getLocalPort() + " -> " + ns.getRemoteAddress() + ":" + ns.getRemotePort()).append("\n");
                ++n2;
            }
            result.append("\nInbound Connections:\n");
            netConnectionArray = connections;
            n = connections.length;
            n2 = 0;
            while (n2 < n) {
                ns = netConnectionArray[n2];
                if (!(ns.getRemoteAddress().equalsIgnoreCase("0.0.0.0") || ns.getRemoteAddress().equalsIgnoreCase("127.0.0.1") || ns.getRemoteAddress().equalsIgnoreCase("::"))) {
                    result.append(ns.toString()).append("\n");
                }
                ++n2;
            }
            result.append("\nContents of TMP directory (java.io.tmpdir)").append("\n");
            result.append(Arrays.toString(new File(System.getProperty("java.io.tmpdir")).listFiles()));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return result.toString();
    }

    public static void main(String[] args) {
        try {
            System.out.println(SystemInformationImpl.getInstance());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

