/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.coursetemplate.impl;

import com.sap.sailing.domain.coursetemplate.CourseConfiguration;
import com.sap.sailing.domain.coursetemplate.CourseTemplate;
import com.sap.sailing.domain.coursetemplate.CourseTemplateCompatibilityChecker;
import com.sap.sailing.domain.coursetemplate.MarkConfiguration;
import com.sap.sailing.domain.coursetemplate.MarkRole;
import com.sap.sailing.domain.coursetemplate.WaypointWithMarkConfiguration;
import com.sap.sse.common.RepeatablePart;
import java.net.URL;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class CourseConfigurationImpl<P>
implements CourseConfiguration<P> {
    private static final long serialVersionUID = -9189989170055144298L;
    private final String shortName;
    private final CourseTemplate optionalCourseTemplate;
    private final Iterable<MarkConfiguration<P>> markConfigurations;
    private final Map<MarkConfiguration<P>, MarkRole> associatedRoles;
    private final List<WaypointWithMarkConfiguration<P>> waypoints;
    private final RepeatablePart optionalRepeatablePart;
    private final Integer numberOfLaps;
    private final String name;
    private final URL optionalImageURL;

    public CourseConfigurationImpl(CourseTemplate optionalCourseTemplate, Iterable<MarkConfiguration<P>> markConfigurations, Map<MarkConfiguration<P>, MarkRole> associatedRoles, List<WaypointWithMarkConfiguration<P>> waypoints, RepeatablePart optionalRepeatablePart, Integer numberOfLaps, String name, String shortName, URL optionalImageURL) {
        assert (!associatedRoles.values().contains(null));
        this.optionalCourseTemplate = optionalCourseTemplate;
        this.markConfigurations = markConfigurations;
        this.associatedRoles = associatedRoles;
        this.waypoints = waypoints;
        if (optionalRepeatablePart != null && optionalCourseTemplate == null) {
            throw new IllegalArgumentException("Inconsistent course configuration " + name + ": When a repeatable part is defined, a course template must be provided");
        }
        this.optionalRepeatablePart = optionalRepeatablePart;
        this.numberOfLaps = numberOfLaps;
        this.name = name;
        this.shortName = shortName;
        this.optionalImageURL = optionalImageURL;
    }

    @Override
    public String getShortName() {
        return this.shortName;
    }

    public RepeatablePart getRepeatablePart() {
        return this.optionalRepeatablePart;
    }

    @Override
    public CourseTemplate getOptionalCourseTemplate() {
        return this.optionalCourseTemplate;
    }

    @Override
    public Iterable<MarkConfiguration<P>> getAllMarks() {
        return this.markConfigurations;
    }

    @Override
    public Iterable<WaypointWithMarkConfiguration<P>> getWaypoints() {
        return this.waypoints;
    }

    @Override
    public Map<MarkConfiguration<P>, MarkRole> getAssociatedRoles() {
        return this.associatedRoles;
    }

    @Override
    public Map<MarkConfiguration<P>, MarkRole> getAllMarksWithOptionalRoles() {
        HashMap<MarkConfiguration<P>, MarkRole> result = new HashMap<MarkConfiguration<P>, MarkRole>();
        for (MarkConfiguration<P> mc : this.markConfigurations) {
            result.put(mc, this.associatedRoles.get(mc));
        }
        return result;
    }

    @Override
    public Integer getNumberOfLaps() {
        return this.numberOfLaps;
    }

    private Integer getNumberOfRepeatablePartOccurrencesInWaypoints() {
        Integer numberOfLaps = new CourseTemplateCompatibilityCheckerForCourseConfiguration().isCourseInstanceOfCourseTemplate();
        return numberOfLaps == null ? null : Integer.valueOf(numberOfLaps == -1 ? -1 : numberOfLaps - 1);
    }

    @Override
    public Iterable<WaypointWithMarkConfiguration<P>> getWaypoints(int numberOfLaps) {
        List<WaypointWithMarkConfiguration<P>> result;
        if (this.hasRepeatablePart()) {
            if (numberOfLaps < 1) {
                throw new IllegalArgumentException("The course template " + this + " has a repeatable part, hence the number of laps needs to be at least 1.");
            }
            Integer numberOfRepeatablePartOccurrences = this.getNumberOfRepeatablePartOccurrencesInWaypoints();
            assert (numberOfRepeatablePartOccurrences != null);
            LinkedList<WaypointWithMarkConfiguration<P>> waypointsWithCorrectNumberOfLaps = new LinkedList<WaypointWithMarkConfiguration<P>>();
            int i = 0;
            while (i < this.getRepeatablePart().getZeroBasedIndexOfRepeatablePartStart()) {
                waypointsWithCorrectNumberOfLaps.add(this.waypoints.get(i));
                ++i;
            }
            int repetitions = 0;
            while (repetitions < numberOfLaps - 1) {
                int occurrenceInWaypointsToUse = Math.min(repetitions, numberOfRepeatablePartOccurrences - 1);
                int i2 = this.getRepeatablePart().getZeroBasedIndexOfRepeatablePartStart();
                while (i2 < this.getRepeatablePart().getZeroBasedIndexOfRepeatablePartEnd()) {
                    waypointsWithCorrectNumberOfLaps.add(this.waypoints.get(this.getRepeatablePart().length() * occurrenceInWaypointsToUse + i2));
                    ++i2;
                }
                ++repetitions;
            }
            i = this.getRepeatablePart().getZeroBasedIndexOfRepeatablePartStart() + numberOfRepeatablePartOccurrences * this.getRepeatablePart().length();
            while (i < this.waypoints.size()) {
                waypointsWithCorrectNumberOfLaps.add(this.waypoints.get(i));
                ++i;
            }
            assert (waypointsWithCorrectNumberOfLaps.size() == this.waypoints.size() + (numberOfLaps - 1 - numberOfRepeatablePartOccurrences) * this.getRepeatablePart().length());
            result = waypointsWithCorrectNumberOfLaps;
        } else {
            result = this.waypoints;
        }
        return result;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public URL getOptionalImageURL() {
        return this.optionalImageURL;
    }

    private class CourseTemplateCompatibilityCheckerForCourseConfiguration
    extends CourseTemplateCompatibilityChecker<CourseConfiguration<P>, MarkConfiguration<P>, WaypointWithMarkConfiguration<P>> {
        public CourseTemplateCompatibilityCheckerForCourseConfiguration() {
            super(CourseConfigurationImpl.this, CourseConfigurationImpl.this.optionalCourseTemplate);
        }

        @Override
        protected MarkRole getMarkRole(MarkConfiguration<P> markFromCourse) {
            return CourseConfigurationImpl.this.getAssociatedRoles().get(markFromCourse);
        }

        @Override
        protected Iterable<MarkConfiguration<P>> getMarks(WaypointWithMarkConfiguration<P> waypoint) {
            return waypoint.getControlPoint().getMarkConfigurations();
        }

        @Override
        protected Iterable<WaypointWithMarkConfiguration<P>> getWaypoints(CourseConfiguration<P> course) {
            return CourseConfigurationImpl.this.waypoints;
        }
    }
}

