/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.coursetemplate;

import com.sap.sailing.domain.coursetemplate.CourseTemplate;
import com.sap.sailing.domain.coursetemplate.MarkRole;
import com.sap.sailing.domain.coursetemplate.WaypointTemplate;
import com.sap.sse.common.RepeatablePart;
import com.sap.sse.common.Util;
import java.util.Iterator;

public abstract class CourseTemplateCompatibilityChecker<C, M, W> {
    private final C course;
    private final CourseTemplate courseTemplate;

    public CourseTemplateCompatibilityChecker(C course, CourseTemplate courseTemplate) {
        assert (course != null);
        assert (courseTemplate != null);
        this.course = course;
        this.courseTemplate = courseTemplate;
    }

    public Integer isCourseInstanceOfCourseTemplate() {
        Iterable<WaypointTemplate> effectiveCourseSequence;
        int numberOfLaps = -1;
        boolean validCourseTemplateUsage = true;
        if (this.courseTemplate.hasRepeatablePart()) {
            int lengthOfRepeatablePart;
            int lengthOfNonRepeatablePart;
            RepeatablePart optionalRepeatablePart = this.courseTemplate.getRepeatablePart();
            int numberOfWaypointsInTemplate = Util.size(this.courseTemplate.getWaypointTemplates());
            int numberOfWaypointsInCourse = Util.size(this.getWaypoints(this.course));
            int lengthOfRepetitions = numberOfWaypointsInCourse - (lengthOfNonRepeatablePart = numberOfWaypointsInTemplate - (lengthOfRepeatablePart = optionalRepeatablePart.getZeroBasedIndexOfRepeatablePartEnd() - optionalRepeatablePart.getZeroBasedIndexOfRepeatablePartStart()));
            if (lengthOfRepetitions % lengthOfRepeatablePart == 0) {
                numberOfLaps = lengthOfRepetitions / lengthOfRepeatablePart + 1;
                effectiveCourseSequence = this.courseTemplate.getWaypointTemplates(numberOfLaps);
            } else {
                validCourseTemplateUsage = false;
                effectiveCourseSequence = this.courseTemplate.getWaypointTemplates();
            }
        } else {
            effectiveCourseSequence = this.courseTemplate.getWaypointTemplates();
        }
        if (validCourseTemplateUsage) {
            Iterator<WaypointTemplate> waypointTemplateIterator = effectiveCourseSequence.iterator();
            Iterator<W> waypointIterator = this.getWaypoints(this.course).iterator();
            while (waypointTemplateIterator.hasNext() && validCourseTemplateUsage) {
                WaypointTemplate waypointTemplate = waypointTemplateIterator.next();
                Iterable<MarkRole> markRolesOfControlPoint = waypointTemplate.getControlPointTemplate().getMarkRoles();
                W waypoint = waypointIterator.next();
                Iterable<M> marksOfControlPoint = this.getMarks(waypoint);
                if (Util.size(markRolesOfControlPoint) != Util.size(marksOfControlPoint)) {
                    validCourseTemplateUsage = false;
                    continue;
                }
                Iterator<MarkRole> markRoleIterator = markRolesOfControlPoint.iterator();
                Iterator<M> markIterator = marksOfControlPoint.iterator();
                while (markRoleIterator.hasNext()) {
                    M markFromRegatta;
                    MarkRole roleForMarkOrNull;
                    MarkRole markRoleFromCourseTemplate = markRoleIterator.next();
                    if (Util.equalsWithNull((Object)markRoleFromCourseTemplate, (Object)(roleForMarkOrNull = this.getMarkRole(markFromRegatta = markIterator.next())))) continue;
                    validCourseTemplateUsage = false;
                }
            }
        }
        return validCourseTemplateUsage ? Integer.valueOf(numberOfLaps) : null;
    }

    protected C getCourse() {
        return this.course;
    }

    protected CourseTemplate getCourseTemplate() {
        return this.courseTemplate;
    }

    protected abstract MarkRole getMarkRole(M var1);

    protected abstract Iterable<M> getMarks(W var1);

    protected abstract Iterable<W> getWaypoints(C var1);
}

