/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.base.impl;

import com.sap.sailing.domain.base.CourseArea;
import com.sap.sailing.domain.base.Venue;
import com.sap.sse.concurrent.LockUtil;
import com.sap.sse.concurrent.NamedReentrantReadWriteLock;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class VenueImpl
implements Venue {
    private static final long serialVersionUID = 6854152040737643290L;
    private String name;
    private final List<CourseArea> courseAreas;
    private NamedReentrantReadWriteLock courseAreasLock;

    public VenueImpl(String name) {
        this.name = name;
        this.courseAreas = new ArrayList<CourseArea>();
        this.courseAreasLock = this.createCourseAreasLock(name);
    }

    private NamedReentrantReadWriteLock createCourseAreasLock(String name) {
        return new NamedReentrantReadWriteLock("Course Areas for venue " + name, false);
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        ois.defaultReadObject();
        if (this.courseAreasLock == null) {
            this.courseAreasLock = this.createCourseAreasLock(this.getName());
        }
    }

    @Override
    public Iterable<CourseArea> getCourseAreas() {
        LockUtil.lockForRead((NamedReentrantReadWriteLock)this.courseAreasLock);
        try {
            List<CourseArea> list = Collections.unmodifiableList(this.courseAreas);
            return list;
        }
        finally {
            LockUtil.unlockAfterRead((NamedReentrantReadWriteLock)this.courseAreasLock);
        }
    }

    @Override
    public void addCourseArea(CourseArea courseArea) {
        LockUtil.lockForWrite((NamedReentrantReadWriteLock)this.courseAreasLock);
        try {
            this.courseAreas.add(courseArea);
        }
        finally {
            LockUtil.unlockAfterWrite((NamedReentrantReadWriteLock)this.courseAreasLock);
        }
    }

    @Override
    public void removeCourseArea(CourseArea courseArea) {
        LockUtil.lockForWrite((NamedReentrantReadWriteLock)this.courseAreasLock);
        try {
            this.courseAreas.remove(courseArea);
        }
        finally {
            LockUtil.unlockAfterWrite((NamedReentrantReadWriteLock)this.courseAreasLock);
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String newName) {
        if (newName == null) {
            throw new IllegalArgumentException("An venue name must not be null");
        }
        this.name = newName;
    }
}

