/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.base.impl;

import com.sap.sailing.domain.base.Nationality;
import com.sap.sailing.domain.base.NationalityChangeListener;
import com.sap.sailing.domain.base.Person;
import com.sap.sailing.domain.base.WithNationality;
import com.sap.sailing.domain.base.impl.DynamicPerson;
import com.sap.sailing.domain.base.impl.DynamicTeam;
import com.sap.sse.common.Util;
import com.sap.sse.common.impl.NamedImpl;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.net.URI;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Logger;

public class TeamImpl
extends NamedImpl
implements DynamicTeam {
    private static final long serialVersionUID = 4646922280429210183L;
    private static final Logger logger = Logger.getLogger(TeamImpl.class.getName());
    private final Iterable<? extends DynamicPerson> sailors;
    private final DynamicPerson coach;
    private final NationalityChangeListener personNationalityChangeForwarder;
    private transient Set<NationalityChangeListener> listeners = new HashSet<NationalityChangeListener>();
    private URI image;

    public TeamImpl(String name, Iterable<? extends DynamicPerson> sailors, DynamicPerson coach) {
        super(name);
        this.sailors = sailors;
        this.coach = coach;
        this.personNationalityChangeForwarder = new NationalityChangeListener(){
            private static final long serialVersionUID = -6024941913105410444L;

            @Override
            public void nationalityChanged(WithNationality what, Nationality oldNationality, Nationality newNationality) {
                if (what == TeamImpl.this.getNationalityDonor()) {
                    for (NationalityChangeListener listener : TeamImpl.this.getNationalityChangeListeners()) {
                        listener.nationalityChanged(TeamImpl.this, oldNationality, newNationality);
                    }
                }
            }
        };
        this.setTransitiveListeners();
    }

    public TeamImpl(String name, Iterable<? extends DynamicPerson> sailors, DynamicPerson coach, URI image) {
        this(name, sailors, coach);
        this.image = image;
    }

    private void setTransitiveListeners() {
        if (this.sailors != null) {
            for (DynamicPerson dynamicPerson : this.sailors) {
                dynamicPerson.addNationalityChangeListener(this.personNationalityChangeForwarder);
            }
        }
        if (this.coach != null) {
            this.coach.addNationalityChangeListener(this.personNationalityChangeForwarder);
        }
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        ois.defaultReadObject();
        this.listeners = new HashSet<NationalityChangeListener>();
        this.setTransitiveListeners();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addNationalityChangeListener(NationalityChangeListener listener) {
        Set<NationalityChangeListener> set = this.listeners;
        synchronized (set) {
            this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeNationalityChangeListener(NationalityChangeListener listener) {
        Set<NationalityChangeListener> set = this.listeners;
        synchronized (set) {
            this.listeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Iterable<NationalityChangeListener> getNationalityChangeListeners() {
        Set<NationalityChangeListener> set = this.listeners;
        synchronized (set) {
            return new HashSet<NationalityChangeListener>(this.listeners);
        }
    }

    @Override
    public Iterable<? extends Person> getSailors() {
        return this.sailors;
    }

    @Override
    public DynamicPerson getCoach() {
        return this.coach;
    }

    @Override
    public Nationality getNationality() {
        return this.getNationalityDonor() == null ? null : this.getNationalityDonor().getNationality();
    }

    private WithNationality getNationalityDonor() {
        for (Person person : this.getSailors()) {
            if (person.getNationality() == null) continue;
            return person;
        }
        if (this.getCoach() != null) {
            return this.getCoach();
        }
        return null;
    }

    @Override
    public void setNationality(Nationality newNationality) {
        Nationality oldNationality = this.getNationality();
        if (!Util.equalsWithNull((Object)oldNationality, (Object)newNationality)) {
            if (Util.isEmpty(this.getSailors()) && this.getCoach() == null) {
                logger.warning("Would like to update nationality of team " + this + " to " + newNationality + " but cannot because neither sailors nor coach are set");
            } else {
                for (Person person : this.getSailors()) {
                    ((DynamicPerson)person).setNationality(newNationality);
                }
                if (this.getCoach() != null) {
                    this.getCoach().setNationality(newNationality);
                }
                for (NationalityChangeListener nationalityChangeListener : this.getNationalityChangeListeners()) {
                    nationalityChangeListener.nationalityChanged(this, oldNationality, newNationality);
                }
            }
        }
    }

    @Override
    public URI getImage() {
        return this.image;
    }

    @Override
    public void setImage(URI teamImage) {
        this.image = teamImage;
    }
}

