/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.base.impl;

import com.sap.sailing.domain.base.Nationality;
import com.sap.sailing.domain.base.NationalityChangeListener;
import com.sap.sailing.domain.base.impl.DynamicPerson;
import com.sap.sse.common.Util;
import com.sap.sse.common.impl.NamedImpl;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;

public class PersonImpl
extends NamedImpl
implements DynamicPerson {
    private static final long serialVersionUID = -2104903799224233508L;
    private Nationality nationality;
    private final Date dateOfBirth;
    private final String description;
    private transient Set<NationalityChangeListener> listeners;

    public PersonImpl(String name, Nationality nationality, Date dateOfBirth, String description) {
        super(name);
        this.nationality = nationality;
        this.dateOfBirth = dateOfBirth;
        this.description = description;
        this.listeners = new HashSet<NationalityChangeListener>();
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        ois.defaultReadObject();
        this.listeners = new HashSet<NationalityChangeListener>();
    }

    @Override
    public Nationality getNationality() {
        return this.nationality;
    }

    @Override
    public void setNationality(Nationality newNationality) {
        Nationality oldNationality = this.nationality;
        if (!Util.equalsWithNull((Object)oldNationality, (Object)newNationality)) {
            this.nationality = newNationality;
            for (NationalityChangeListener listener : this.getListeners()) {
                listener.nationalityChanged(this, oldNationality, newNationality);
            }
        }
    }

    @Override
    public Date getDateOfBirth() {
        return this.dateOfBirth;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addNationalityChangeListener(NationalityChangeListener listener) {
        Set<NationalityChangeListener> set = this.listeners;
        synchronized (set) {
            this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeNationalityChangeListener(NationalityChangeListener listener) {
        Set<NationalityChangeListener> set = this.listeners;
        synchronized (set) {
            this.listeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Iterable<NationalityChangeListener> getListeners() {
        Set<NationalityChangeListener> set = this.listeners;
        synchronized (set) {
            return new HashSet<NationalityChangeListener>(this.listeners);
        }
    }
}

