/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.abstractlog.shared.analyzing;

import com.sap.sailing.domain.abstractlog.AbstractLog;
import com.sap.sailing.domain.abstractlog.AbstractLogEvent;
import com.sap.sailing.domain.abstractlog.BaseLogAnalyzer;
import com.sap.sailing.domain.abstractlog.race.RaceLog;
import com.sap.sailing.domain.abstractlog.race.tracking.RaceLogRegisterCompetitorEvent;
import com.sap.sailing.domain.abstractlog.regatta.RegattaLog;
import com.sap.sailing.domain.abstractlog.regatta.events.RegattaLogRegisterCompetitorEvent;
import com.sap.sailing.domain.base.Boat;
import com.sap.sailing.domain.base.Competitor;
import com.sap.sailing.domain.base.CompetitorWithBoat;
import java.util.HashMap;
import java.util.Map;

public class CompetitorsAndBoatsInLogAnalyzer<LogT extends AbstractLog<EventT, VisitorT>, EventT extends AbstractLogEvent<VisitorT>, VisitorT>
extends BaseLogAnalyzer<LogT, EventT, VisitorT, Map<Competitor, Boat>> {
    public CompetitorsAndBoatsInLogAnalyzer(LogT log) {
        super(log);
    }

    @Override
    protected Map<Competitor, Boat> performAnalysis() {
        HashMap<Competitor, Boat> result;
        block3: {
            Object log;
            block2: {
                result = new HashMap<Competitor, Boat>();
                log = this.getLog();
                if (!(log instanceof RegattaLog)) break block2;
                for (AbstractLogEvent event : this.getLog().getUnrevokedEvents()) {
                    RegattaLogRegisterCompetitorEvent regattaLogCompetitorEvent;
                    if (!(event instanceof RegattaLogRegisterCompetitorEvent) || !(regattaLogCompetitorEvent = (RegattaLogRegisterCompetitorEvent)event).getCompetitor().hasBoat()) continue;
                    CompetitorWithBoat competitorWithBoat = (CompetitorWithBoat)regattaLogCompetitorEvent.getCompetitor();
                    result.put(competitorWithBoat, competitorWithBoat.getBoat());
                }
                break block3;
            }
            if (!(log instanceof RaceLog)) break block3;
            for (AbstractLogEvent event : this.getLog().getUnrevokedEvents()) {
                if (!(event instanceof RaceLogRegisterCompetitorEvent)) continue;
                RaceLogRegisterCompetitorEvent raceLogCompetitorEvent = (RaceLogRegisterCompetitorEvent)event;
                result.put(raceLogCompetitorEvent.getCompetitor(), raceLogCompetitorEvent.getBoat());
            }
        }
        return result;
    }
}

