/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.abstractlog.regatta.tracking.analyzing.impl;

import com.sap.sailing.domain.abstractlog.AbstractLogEventAuthor;
import com.sap.sailing.domain.abstractlog.regatta.RegattaLog;
import com.sap.sailing.domain.abstractlog.regatta.events.RegattaLogCloseOpenEndedDeviceMappingEvent;
import com.sap.sailing.domain.abstractlog.regatta.events.RegattaLogDeviceMappingEvent;
import com.sap.sailing.domain.abstractlog.regatta.events.impl.RegattaLogCloseOpenEndedDeviceMappingEventImpl;
import com.sap.sailing.domain.abstractlog.regatta.tracking.analyzing.impl.RegattaLogAnalyzer;
import com.sap.sailing.domain.racelogtracking.DeviceMapping;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.impl.MillisecondsTimePoint;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class RegattaLogOpenEndedDeviceMappingCloser
extends RegattaLogAnalyzer<List<RegattaLogCloseOpenEndedDeviceMappingEvent>> {
    private final DeviceMapping<?> mapping;
    protected final AbstractLogEventAuthor author;
    protected final TimePoint closingTimePointInclusive;

    public RegattaLogOpenEndedDeviceMappingCloser(RegattaLog log, DeviceMapping<?> mapping, AbstractLogEventAuthor author, TimePoint closingTimePointInclusive) {
        super(log);
        this.mapping = mapping;
        this.author = author;
        this.closingTimePointInclusive = closingTimePointInclusive;
    }

    protected RegattaLogCloseOpenEndedDeviceMappingEvent createCloseEvent(TimePoint logicalTimePoint, Serializable eventToCloseId) {
        return new RegattaLogCloseOpenEndedDeviceMappingEventImpl(logicalTimePoint, this.author, eventToCloseId, this.closingTimePointInclusive);
    }

    @Override
    protected List<RegattaLogCloseOpenEndedDeviceMappingEvent> performAnalysis() {
        ArrayList<RegattaLogCloseOpenEndedDeviceMappingEvent> result = new ArrayList<RegattaLogCloseOpenEndedDeviceMappingEvent>();
        for (Serializable eventId : this.mapping.getOriginalRaceLogEventIds()) {
            RegattaLogDeviceMappingEvent event = (RegattaLogDeviceMappingEvent)((RegattaLog)this.getLog()).getEventById(eventId);
            if (event.getFrom() != null && event.getToInclusive() != null) continue;
            result.add(this.createCloseEvent(MillisecondsTimePoint.now(), event.getId()));
        }
        return result;
    }
}

