/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.abstractlog.regatta.tracking.analyzing.impl;

import com.sap.sailing.domain.abstractlog.AbstractLog;
import com.sap.sailing.domain.abstractlog.AbstractLogEvent;
import com.sap.sailing.domain.abstractlog.AbstractLogEventAuthor;
import com.sap.sailing.domain.abstractlog.BaseLogAnalyzer;
import com.sap.sailing.domain.abstractlog.regatta.events.RegattaLogRegisterBoatEvent;
import com.sap.sailing.domain.base.Boat;
import com.sap.sailing.domain.common.abstractlog.NotRevokableException;
import com.sap.sse.common.Util;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class RegattaLogBoatDeregistrator<LogT extends AbstractLog<EventT, VisitorT>, EventT extends AbstractLogEvent<VisitorT>, VisitorT>
extends BaseLogAnalyzer<LogT, EventT, VisitorT, Set<EventT>> {
    private static final Logger logger = Logger.getLogger(RegattaLogBoatDeregistrator.class.getName());
    protected final Iterable<Boat> boatsToDeregister;
    private AbstractLogEventAuthor eventAuthor;

    public RegattaLogBoatDeregistrator(LogT log, Iterable<Boat> boatsToDeregister, AbstractLogEventAuthor eventAuthor) {
        super(log);
        this.boatsToDeregister = boatsToDeregister;
        this.eventAuthor = eventAuthor;
    }

    @Override
    protected Set<EventT> performAnalysis() {
        HashSet<AbstractLogEvent> result = new HashSet<AbstractLogEvent>();
        HashSet boatSet = new HashSet();
        Util.addAll(this.boatsToDeregister, boatSet);
        for (AbstractLogEvent event : this.log.getUnrevokedEventsDescending()) {
            RegattaLogRegisterBoatEvent registerEvent;
            if (!(event instanceof RegattaLogRegisterBoatEvent) || !boatSet.contains((registerEvent = (RegattaLogRegisterBoatEvent)event).getBoat())) continue;
            result.add(event);
        }
        return result;
    }

    public void deregister(Set<EventT> boatRegistrationEvents) {
        for (AbstractLogEvent event : boatRegistrationEvents) {
            try {
                this.log.revokeEvent(this.eventAuthor, event, "unregistering boat because no longer selected for registration");
            }
            catch (NotRevokableException e) {
                logger.log(Level.WARNING, "could not unregister boat by adding RevokeEvent", e);
            }
        }
    }
}

