/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.abstractlog.race.state.racingprocedure.line.impl;

import com.sap.sailing.domain.abstractlog.AbstractLogEventAuthor;
import com.sap.sailing.domain.abstractlog.race.RaceLog;
import com.sap.sailing.domain.abstractlog.race.analyzing.impl.RaceLogResolver;
import com.sap.sailing.domain.abstractlog.race.state.RaceStateEvent;
import com.sap.sailing.domain.abstractlog.race.state.impl.RaceStateEventImpl;
import com.sap.sailing.domain.abstractlog.race.state.impl.RaceStateEvents;
import com.sap.sailing.domain.abstractlog.race.state.racingprocedure.FlagPoleState;
import com.sap.sailing.domain.abstractlog.race.state.racingprocedure.line.RRS26RacingProcedure;
import com.sap.sailing.domain.abstractlog.race.state.racingprocedure.line.impl.ConfigurableStartModeFlagRacingProcedureImpl;
import com.sap.sailing.domain.base.configuration.procedures.RRS26Configuration;
import com.sap.sailing.domain.common.racelog.FlagPole;
import com.sap.sailing.domain.common.racelog.Flags;
import com.sap.sse.common.Duration;
import com.sap.sse.common.TimePoint;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public abstract class BaseRRS26RacingProcedureImpl
extends ConfigurableStartModeFlagRacingProcedureImpl
implements RRS26RacingProcedure {
    private final Duration startPhaseClassUpInterval;
    private final Duration startPhaseStartModeUpInterval;
    private final Duration startPhaseStartModeDownInterval;

    public BaseRRS26RacingProcedureImpl(RaceLog raceLog, AbstractLogEventAuthor author, RRS26Configuration configuration, RaceLogResolver raceLogResolver, Duration startPhaseClassUpInterval, Duration startPhaseStartModeUpInterval) {
        super(raceLog, author, configuration, raceLogResolver);
        this.startPhaseClassUpInterval = startPhaseClassUpInterval;
        this.startPhaseStartModeUpInterval = startPhaseStartModeUpInterval;
        this.startPhaseStartModeDownInterval = Duration.ONE_MINUTE;
    }

    @Override
    protected Duration getStartPhaseStartModeUpInterval() {
        return this.startPhaseStartModeUpInterval;
    }

    @Override
    public boolean hasIndividualRecall() {
        boolean hasRecall = super.hasIndividualRecall();
        if (hasRecall) {
            return true;
        }
        if (this.startmodeFlagHasBeenSet) {
            return this.cachedStartmodeFlag != Flags.BLACK;
        }
        return false;
    }

    @Override
    protected boolean hasIndividualRecallByDefault() {
        return true;
    }

    @Override
    protected Boolean isResultEntryEnabledByDefault() {
        return false;
    }

    @Override
    public Iterable<RaceStateEvent> createStartStateEvents(TimePoint startTime) {
        return Arrays.asList(new RaceStateEventImpl(startTime.minus(this.startPhaseClassUpInterval), RaceStateEvents.RRS26_CLASS_UP), new RaceStateEventImpl(startTime.minus(this.startPhaseStartModeUpInterval), RaceStateEvents.RRS26_STARTMODE_UP), new RaceStateEventImpl(startTime.minus(this.startPhaseStartModeDownInterval), RaceStateEvents.RRS26_STARTMODE_DOWN), new RaceStateEventImpl(startTime, RaceStateEvents.START));
    }

    @Override
    public boolean processStateEvent(RaceStateEvent event) {
        switch (event.getEventName()) {
            case RRS26_STARTMODE_UP: {
                if (!this.startmodeFlagHasBeenSet) {
                    this.setStartModeFlag(event.getTimePoint(), this.cachedStartmodeFlag);
                }
            }
            case RRS26_CLASS_UP: 
            case RRS26_STARTMODE_DOWN: {
                this.getChangedListeners().onActiveFlagsChanged(this);
                return true;
            }
        }
        return super.processStateEvent(event);
    }

    @Override
    public FlagPoleState getActiveFlags(TimePoint startTime, TimePoint now) {
        Flags classFlag;
        Flags flags = classFlag = this.getConfiguration().getClassFlag() != null ? this.getConfiguration().getClassFlag() : Flags.CLASS;
        if (now.before(startTime.minus(this.startPhaseClassUpInterval))) {
            return new FlagPoleState(Arrays.asList(new FlagPole(classFlag, false), new FlagPole(this.cachedStartmodeFlag, false)), null, Arrays.asList(new FlagPole(classFlag, true), new FlagPole(this.cachedStartmodeFlag, false)), startTime.minus(this.startPhaseClassUpInterval));
        }
        if (now.before(startTime.minus(this.startPhaseStartModeUpInterval))) {
            return new FlagPoleState(Arrays.asList(new FlagPole(classFlag, true), new FlagPole(this.cachedStartmodeFlag, false)), startTime.minus(this.startPhaseClassUpInterval), Arrays.asList(new FlagPole(classFlag, true), new FlagPole(this.cachedStartmodeFlag, true)), startTime.minus(this.startPhaseStartModeUpInterval));
        }
        if (now.before(startTime.minus(this.startPhaseStartModeDownInterval))) {
            return new FlagPoleState(Arrays.asList(new FlagPole(classFlag, true), new FlagPole(this.cachedStartmodeFlag, true)), startTime.minus(this.startPhaseStartModeUpInterval), Arrays.asList(new FlagPole(classFlag, true), new FlagPole(this.cachedStartmodeFlag, false)), startTime.minus(this.startPhaseStartModeDownInterval));
        }
        if (now.before(startTime)) {
            return new FlagPoleState(Arrays.asList(new FlagPole(classFlag, true), new FlagPole(this.cachedStartmodeFlag, false)), startTime.minus(this.startPhaseStartModeDownInterval), Arrays.asList(new FlagPole(classFlag, false), new FlagPole(this.cachedStartmodeFlag, false)), startTime);
        }
        if (this.isIndividualRecallDisplayed(now)) {
            return new FlagPoleState(Collections.singletonList(new FlagPole(Flags.XRAY, true)), this.getIndividualRecallDisplayedTime(), Collections.singletonList(new FlagPole(Flags.XRAY, false)), this.getIndividualRecallRemovalTime());
        }
        if (this.isFinished(now)) {
            return new FlagPoleState(Collections.singletonList(new FlagPole(Flags.BLUE, false)), this.getFinishedTime());
        }
        if (this.isInFinishingPhase(now)) {
            return new FlagPoleState(Collections.singletonList(new FlagPole(Flags.BLUE, true)), this.getFinishingTime(), Collections.singletonList(new FlagPole(Flags.BLUE, false)), null);
        }
        TimePoint recallRemoved = this.getIndividualRecallRemovalTime();
        return new FlagPoleState(Collections.emptyList(), recallRemoved == null ? startTime : recallRemoved);
    }

    @Override
    public Flags getDefaultStartMode() {
        return RRS26RacingProcedure.DEFAULT_START_MODE;
    }

    @Override
    public List<Flags> getDefaultStartModeFlags() {
        return RRS26RacingProcedure.DEFAULT_START_MODE_FLAGS;
    }

    @Override
    public RRS26Configuration getConfiguration() {
        return (RRS26Configuration)super.getConfiguration();
    }
}

