/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.abstractlog.race.state.impl;

import com.sap.sailing.domain.abstractlog.race.CompetitorResults;
import com.sap.sailing.domain.abstractlog.race.RaceLog;
import com.sap.sailing.domain.abstractlog.race.RaceLogChangedListener;
import com.sap.sailing.domain.abstractlog.race.RaceLogDependentStartTimeEvent;
import com.sap.sailing.domain.abstractlog.race.RaceLogEvent;
import com.sap.sailing.domain.abstractlog.race.RaceLogPassChangeEvent;
import com.sap.sailing.domain.abstractlog.race.RaceLogResultsAreOfficialEvent;
import com.sap.sailing.domain.abstractlog.race.RaceLogStartTimeEvent;
import com.sap.sailing.domain.abstractlog.race.RaceLogTagEvent;
import com.sap.sailing.domain.abstractlog.race.SimpleRaceLogIdentifier;
import com.sap.sailing.domain.abstractlog.race.analyzing.impl.AbstractFinishPositioningListFinder;
import com.sap.sailing.domain.abstractlog.race.analyzing.impl.ConfirmedFinishPositioningListFinder;
import com.sap.sailing.domain.abstractlog.race.analyzing.impl.FinishPositioningListFinder;
import com.sap.sailing.domain.abstractlog.race.analyzing.impl.FinishedTimeFinder;
import com.sap.sailing.domain.abstractlog.race.analyzing.impl.FinishingTimeFinder;
import com.sap.sailing.domain.abstractlog.race.analyzing.impl.LastPublishedCourseDesignFinder;
import com.sap.sailing.domain.abstractlog.race.analyzing.impl.LastWindFixFinder;
import com.sap.sailing.domain.abstractlog.race.analyzing.impl.ProtestTimeFinder;
import com.sap.sailing.domain.abstractlog.race.analyzing.impl.RaceLogResolver;
import com.sap.sailing.domain.abstractlog.race.analyzing.impl.RaceStatusAnalyzer;
import com.sap.sailing.domain.abstractlog.race.analyzing.impl.RacingProcedureTypeAnalyzer;
import com.sap.sailing.domain.abstractlog.race.analyzing.impl.ResultsAreOfficialFinder;
import com.sap.sailing.domain.abstractlog.race.analyzing.impl.StartTimeFinder;
import com.sap.sailing.domain.abstractlog.race.analyzing.impl.StartTimeFinderResult;
import com.sap.sailing.domain.abstractlog.race.analyzing.impl.TagFinder;
import com.sap.sailing.domain.abstractlog.race.impl.WeakRaceLogChangedVisitor;
import com.sap.sailing.domain.abstractlog.race.state.RaceStateChangedListener;
import com.sap.sailing.domain.abstractlog.race.state.RaceStateEvent;
import com.sap.sailing.domain.abstractlog.race.state.RaceStateEventScheduler;
import com.sap.sailing.domain.abstractlog.race.state.ReadonlyRaceState;
import com.sap.sailing.domain.abstractlog.race.state.impl.BaseRaceStateChangedListener;
import com.sap.sailing.domain.abstractlog.race.state.impl.RaceStateChangedListeners;
import com.sap.sailing.domain.abstractlog.race.state.impl.RaceStateEvents;
import com.sap.sailing.domain.abstractlog.race.state.racingprocedure.RacingProcedureFactory;
import com.sap.sailing.domain.abstractlog.race.state.racingprocedure.ReadonlyRacingProcedure;
import com.sap.sailing.domain.abstractlog.race.state.racingprocedure.impl.ReadonlyRacingProcedureFactory;
import com.sap.sailing.domain.base.CourseBase;
import com.sap.sailing.domain.base.configuration.ConfigurationLoader;
import com.sap.sailing.domain.base.configuration.RegattaConfiguration;
import com.sap.sailing.domain.base.configuration.impl.EmptyRegattaConfiguration;
import com.sap.sailing.domain.common.Wind;
import com.sap.sailing.domain.common.racelog.RaceLogRaceStatus;
import com.sap.sailing.domain.common.racelog.RacingProcedureType;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.TimeRange;
import com.sap.sse.common.Util;
import com.sap.sse.common.impl.TimeRangeImpl;
import com.sap.sse.shared.util.WeakIdentityHashMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.UUID;

public class ReadonlyRaceStateImpl
implements ReadonlyRaceState,
RaceLogChangedListener {
    private static final WeakIdentityHashMap<RaceLog, WeakIdentityHashMap<RaceLogResolver, ReadonlyRaceState>> raceStateCache = new WeakIdentityHashMap();
    public static final RacingProcedureType fallbackInitialProcedureType = RacingProcedureType.RRS26;
    protected final RaceLog raceLog;
    private final RaceStatusAnalyzer.Clock statusAnalyzerClock;
    private final RacingProcedureFactory procedureFactory;
    private final RaceStateChangedListeners changedListeners;
    private ReadonlyRacingProcedure racingProcedure;
    private RaceStateEventScheduler scheduler;
    private RaceStatusAnalyzer statusAnalyzer;
    private final RacingProcedureTypeAnalyzer racingProcedureAnalyzer;
    private final StartTimeFinder startTimeAnalyzer;
    private final FinishingTimeFinder finishingTimeAnalyzer;
    private final FinishedTimeFinder finishedTimeAnalyzer;
    private final ProtestTimeFinder protestTimeAnalyzer;
    private final ResultsAreOfficialFinder resultsAreOfficialAnalyzer;
    private final FinishPositioningListFinder finishPositioningListAnalyzer;
    private final ConfirmedFinishPositioningListFinder confirmedFinishPositioningListAnalyzer;
    private final LastPublishedCourseDesignFinder courseDesignerAnalyzer;
    private final LastWindFixFinder lastWindFixAnalyzer;
    private final TagFinder tagAnalyzer;
    private RacingProcedureType cachedRacingProcedureType;
    private RacingProcedureType cachedRacingProcedureTypeNoFallback;
    private RaceLogRaceStatus cachedRaceStatus;
    private TimePoint clockTimePointWhenCachedRaceStatusWasSet;
    private Iterable<TimePoint> timePointsWhenRaceStatusMayChange;
    private Iterable<RaceLogTagEvent> cachedTagEvents;
    private boolean cachedResultsAreOfficial;
    private int cachedPassId;
    private StartTimeFinderResult cachedStartTimeFinderResult;
    private TimePoint cachedFinishingTime;
    private TimePoint cachedFinishedTime;
    private TimeRange cachedProtest;
    private CompetitorResults cachedPositionedCompetitors;
    private AbstractFinishPositioningListFinder.CompetitorResultsAndTheirCreationTimePoints cachedConfirmedPositionedCompetitors;
    private CourseBase cachedCourseDesign;
    private Wind cachedWindFix;
    private RaceLogResolver raceLogResolver;
    private ReadonlyRaceState raceStateToObserve;
    private RaceStateChangedListener raceStateToObserveListener;

    public static ReadonlyRaceState getOrCreate(RaceLogResolver raceLogResolver, RaceLog raceLog) {
        return ReadonlyRaceStateImpl.getOrCreate(raceLogResolver, raceLog, null, Collections.emptyMap());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ReadonlyRaceState getOrCreate(RaceLogResolver raceLogResolver, RaceLog raceLog, SimpleRaceLogIdentifier forRaceLogIdentifier, Map<SimpleRaceLogIdentifier, ReadonlyRaceState> dependentRaceStates) {
        ReadonlyRaceState result = null;
        WeakIdentityHashMap<RaceLog, WeakIdentityHashMap<RaceLogResolver, ReadonlyRaceState>> weakIdentityHashMap = raceStateCache;
        synchronized (weakIdentityHashMap) {
            WeakIdentityHashMap raceStatesForRaceLog = (WeakIdentityHashMap)raceStateCache.get((Object)raceLog);
            if (raceStatesForRaceLog == null) {
                raceStatesForRaceLog = new WeakIdentityHashMap();
                raceStateCache.put((Object)raceLog, (Object)raceStatesForRaceLog);
            } else {
                result = (ReadonlyRaceState)raceStatesForRaceLog.get((Object)raceLogResolver);
            }
            if (result == null) {
                result = ReadonlyRaceStateImpl.createInternal(raceLogResolver, raceLog, forRaceLogIdentifier, dependentRaceStates);
                raceStatesForRaceLog.put((Object)raceLogResolver, (Object)result);
            }
        }
        return result;
    }

    private static final ReadonlyRaceState createInternal(RaceLogResolver raceLogResolver, RaceLog raceLog, SimpleRaceLogIdentifier forRaceLogIdentifier, Map<SimpleRaceLogIdentifier, ReadonlyRaceState> dependentRaceStates) {
        return ReadonlyRaceStateImpl.create(raceLogResolver, raceLog, forRaceLogIdentifier, dependentRaceStates);
    }

    public static ReadonlyRaceState create(RaceLogResolver raceLogResolver, RaceLog raceLog, SimpleRaceLogIdentifier forRaceLogIdentifier, ConfigurationLoader<RegattaConfiguration> configurationLoader, Map<SimpleRaceLogIdentifier, ReadonlyRaceState> dependentRaceStates) {
        return new ReadonlyRaceStateImpl(raceLogResolver, raceLog, forRaceLogIdentifier, new ReadonlyRacingProcedureFactory(configurationLoader), dependentRaceStates);
    }

    public static ReadonlyRaceState create(RaceLogResolver raceLogResolver, RaceLog raceLog, SimpleRaceLogIdentifier forRaceLogIdentifier, Map<SimpleRaceLogIdentifier, ReadonlyRaceState> dependentRaceStates) {
        return new ReadonlyRaceStateImpl(raceLogResolver, raceLog, forRaceLogIdentifier, new ReadonlyRacingProcedureFactory(new EmptyRegattaConfiguration()), dependentRaceStates);
    }

    private ReadonlyRaceStateImpl(RaceLogResolver raceLogResolver, RaceLog raceLog, SimpleRaceLogIdentifier forRaceLogIdentifier, RacingProcedureFactory procedureFactory, Map<SimpleRaceLogIdentifier, ReadonlyRaceState> dependentRaceStates) {
        this(raceLogResolver, raceLog, forRaceLogIdentifier, new RaceStatusAnalyzer.StandardClock(), procedureFactory, dependentRaceStates);
    }

    protected ReadonlyRaceStateImpl(RaceLogResolver raceLogResolver, RaceLog raceLog, SimpleRaceLogIdentifier forRaceLogIdentifier, RaceStatusAnalyzer.Clock analyzersClock, RacingProcedureFactory procedureFactory, Map<SimpleRaceLogIdentifier, ReadonlyRaceState> dependentRaceStates) {
        Map<SimpleRaceLogIdentifier, ReadonlyRaceState> dependentRaceStatesAndMe;
        this.raceLog = raceLog;
        this.raceLogResolver = raceLogResolver;
        this.procedureFactory = procedureFactory;
        this.changedListeners = new RaceStateChangedListeners();
        this.racingProcedureAnalyzer = new RacingProcedureTypeAnalyzer(raceLog);
        this.statusAnalyzerClock = analyzersClock;
        this.startTimeAnalyzer = new StartTimeFinder(raceLogResolver, raceLog);
        this.finishingTimeAnalyzer = new FinishingTimeFinder(raceLog);
        this.finishedTimeAnalyzer = new FinishedTimeFinder(raceLog);
        this.protestTimeAnalyzer = new ProtestTimeFinder(raceLog);
        this.resultsAreOfficialAnalyzer = new ResultsAreOfficialFinder(raceLog);
        this.finishPositioningListAnalyzer = new FinishPositioningListFinder(raceLog);
        this.confirmedFinishPositioningListAnalyzer = new ConfirmedFinishPositioningListFinder(raceLog);
        this.courseDesignerAnalyzer = new LastPublishedCourseDesignFinder(raceLog, false);
        this.lastWindFixAnalyzer = new LastWindFixFinder(raceLog);
        this.tagAnalyzer = new TagFinder(raceLog);
        this.raceStateToObserveListener = new BaseRaceStateChangedListener(){

            @Override
            public void onStartTimeChanged(ReadonlyRaceState state) {
                ReadonlyRaceStateImpl.this.update();
            }
        };
        this.cachedRacingProcedureTypeNoFallback = this.determineInitialProcedureType();
        this.cachedRacingProcedureType = this.cachedRacingProcedureTypeNoFallback == null || this.cachedRacingProcedureTypeNoFallback == RacingProcedureType.UNKNOWN ? fallbackInitialProcedureType : this.cachedRacingProcedureTypeNoFallback;
        this.cachedRaceStatus = RaceLogRaceStatus.UNKNOWN;
        this.cachedPassId = raceLog.getCurrentPassId();
        this.raceLog.addListener(new WeakRaceLogChangedVisitor(this.raceLog, this));
        if (forRaceLogIdentifier != null) {
            dependentRaceStatesAndMe = new HashMap<SimpleRaceLogIdentifier, ReadonlyRaceState>(dependentRaceStates);
            dependentRaceStatesAndMe.put(forRaceLogIdentifier, this);
        } else {
            dependentRaceStatesAndMe = dependentRaceStates;
        }
        this.recreateRacingProcedure(dependentRaceStatesAndMe);
        this.adjustObserverForRelativeStartTime(dependentRaceStatesAndMe);
    }

    protected ReadonlyRaceState getRaceStateToObserve() {
        return this.raceStateToObserve;
    }

    protected RacingProcedureType determineInitialProcedureType() {
        RacingProcedureType inRaceLogType = (RacingProcedureType)this.racingProcedureAnalyzer.analyze();
        return this.determineInitialProcedureType(inRaceLogType);
    }

    private RacingProcedureType determineInitialProcedureType(RacingProcedureType inRaceLogType) {
        RegattaConfiguration configuration = this.getConfiguration();
        if (inRaceLogType != RacingProcedureType.UNKNOWN) {
            return inRaceLogType;
        }
        return configuration.getDefaultRacingProcedureType();
    }

    @Override
    public RaceLog getRaceLog() {
        return this.raceLog;
    }

    @Override
    public ReadonlyRacingProcedure getRacingProcedure() {
        return this.racingProcedure;
    }

    @Override
    public ReadonlyRacingProcedure getRacingProcedureNoFallback() {
        ReadonlyRacingProcedure result = this.cachedRacingProcedureTypeNoFallback == null || this.cachedRacingProcedureTypeNoFallback == RacingProcedureType.UNKNOWN ? null : this.getRacingProcedure();
        return result;
    }

    @Override
    public <T extends ReadonlyRacingProcedure> T getTypedReadonlyRacingProcedure() {
        return (T)this.getRacingProcedure();
    }

    @Override
    public <T extends ReadonlyRacingProcedure> T getTypedReadonlyRacingProcedure(Class<T> clazz) {
        ReadonlyRacingProcedure procedure = this.getRacingProcedure();
        if (clazz.isAssignableFrom(procedure.getClass())) {
            return (T)procedure;
        }
        return null;
    }

    @Override
    public void setStateEventScheduler(RaceStateEventScheduler scheduler) {
        this.scheduler = scheduler;
        if (this.racingProcedure != null) {
            this.racingProcedure.setStateEventScheduler(scheduler);
            this.racingProcedure.triggerStateEventScheduling(this);
        }
    }

    @Override
    public RaceLogRaceStatus getStatus() {
        TimePoint timePointForAnalysis = this.statusAnalyzerClock.now();
        TimeRangeImpl timeRangeSinceLastStatusUpdate = new TimeRangeImpl(this.clockTimePointWhenCachedRaceStatusWasSet, timePointForAnalysis);
        if (this.overlapsTimePointForPotentialStatusChange((TimeRange)timeRangeSinceLastStatusUpdate)) {
            this.analyzeAndUpdateCachedRaceStatus();
        }
        return this.cachedRaceStatus;
    }

    @Override
    public boolean isResultsAreOfficial() {
        return this.cachedResultsAreOfficial;
    }

    private boolean overlapsTimePointForPotentialStatusChange(TimeRange timeRangeSinceLastStatusUpdate) {
        for (TimePoint e : this.timePointsWhenRaceStatusMayChange) {
            if (!timeRangeSinceLastStatusUpdate.includes(e)) continue;
            return true;
        }
        return false;
    }

    @Override
    public TimePoint getStartTime() {
        if (this.cachedStartTimeFinderResult.getResolutionFailed() == StartTimeFinderResult.ResolutionFailed.RACE_LOG_UNRESOLVED) {
            this.updateStartTime();
        }
        return this.cachedStartTimeFinderResult.getStartTime();
    }

    @Override
    public StartTimeFinderResult getStartTimeFinderResult() {
        return this.cachedStartTimeFinderResult;
    }

    @Override
    public TimePoint getFinishingTime() {
        return this.cachedFinishingTime;
    }

    @Override
    public TimePoint getFinishedTime() {
        return this.cachedFinishedTime;
    }

    @Override
    public TimeRange getProtestTime() {
        return this.cachedProtest;
    }

    @Override
    public CompetitorResults getFinishPositioningList() {
        return this.cachedPositionedCompetitors;
    }

    @Override
    public AbstractFinishPositioningListFinder.CompetitorResultsAndTheirCreationTimePoints getConfirmedFinishPositioningList() {
        return this.cachedConfirmedPositionedCompetitors;
    }

    @Override
    public CourseBase getCourseDesign() {
        return this.cachedCourseDesign;
    }

    @Override
    public Wind getWindFix() {
        return this.cachedWindFix;
    }

    @Override
    public Iterable<RaceLogTagEvent> getTagEvents() {
        return this.cachedTagEvents;
    }

    @Override
    public RegattaConfiguration getConfiguration() {
        return this.procedureFactory.getConfiguration();
    }

    @Override
    public void addChangedListener(RaceStateChangedListener listener) {
        this.changedListeners.add(listener);
    }

    @Override
    public void removeChangedListener(RaceStateChangedListener listener) {
        this.changedListeners.remove(listener);
    }

    @Override
    public void eventAdded(RaceLogEvent event) {
        if (event instanceof RaceLogDependentStartTimeEvent || event instanceof RaceLogStartTimeEvent || event instanceof RaceLogPassChangeEvent) {
            this.adjustObserverForRelativeStartTime();
        }
        this.update();
    }

    private void adjustObserverForRelativeStartTime() {
        this.adjustObserverForRelativeStartTime(Collections.emptyMap());
    }

    private void adjustObserverForRelativeStartTime(Map<SimpleRaceLogIdentifier, ReadonlyRaceState> dependentRaceStates) {
        StartTimeFinderResult startTimeAnalysisResult = (StartTimeFinderResult)this.startTimeAnalyzer.analyze();
        this.adjustObserverForRelativeStartTime(startTimeAnalysisResult, dependentRaceStates);
    }

    private void adjustObserverForRelativeStartTime(StartTimeFinderResult startTimeAnalysisResult, Map<SimpleRaceLogIdentifier, ReadonlyRaceState> dependentRaceStates) {
        if (startTimeAnalysisResult.isDependentStartTime()) {
            this.setupListenersOnDependentRace(startTimeAnalysisResult, dependentRaceStates);
        } else if (this.raceStateToObserve != null) {
            this.raceStateToObserve.removeChangedListener(this.raceStateToObserveListener);
            this.raceStateToObserve = null;
        }
    }

    private void setupListenersOnDependentRace(StartTimeFinderResult startTimeAnalysisResult, Map<SimpleRaceLogIdentifier, ReadonlyRaceState> dependentRaceStates) {
        SimpleRaceLogIdentifier dependentOnRaceIdentifier;
        assert (startTimeAnalysisResult.isDependentStartTime());
        assert (!Util.isEmpty(startTimeAnalysisResult.getDependingOnRaces()));
        if (this.raceStateToObserve != null) {
            this.raceStateToObserve.removeChangedListener(this.raceStateToObserveListener);
            this.raceStateToObserve = null;
        }
        if (dependentRaceStates.containsKey(dependentOnRaceIdentifier = startTimeAnalysisResult.getDependingOnRaces().iterator().next())) {
            this.raceStateToObserve = dependentRaceStates.get(dependentOnRaceIdentifier);
            this.raceStateToObserve.addChangedListener(this.raceStateToObserveListener);
        } else {
            RaceLog resolvedRaceLog = this.raceLogResolver.resolve(dependentOnRaceIdentifier);
            if (resolvedRaceLog != null) {
                this.raceStateToObserve = ReadonlyRaceStateImpl.getOrCreate(this.raceLogResolver, resolvedRaceLog, dependentOnRaceIdentifier, dependentRaceStates);
                this.raceStateToObserve.addChangedListener(this.raceStateToObserveListener);
            }
        }
    }

    @Override
    public boolean processStateEvent(RaceStateEvent event) {
        if (this.racingProcedure.processStateEvent(event) || event.getEventName() == RaceStateEvents.START) {
            this.update();
            return true;
        }
        return false;
    }

    protected void update() {
        this.update(Collections.emptyMap());
    }

    protected void update(Map<SimpleRaceLogIdentifier, ReadonlyRaceState> dependentRaceStates) {
        RaceLogResultsAreOfficialEvent resultsAreOfficialEvent;
        Iterable tagEvents;
        Wind windFix;
        CourseBase courseDesign;
        AbstractFinishPositioningListFinder.CompetitorResultsAndTheirCreationTimePoints confirmedPositionedCompetitors;
        CompetitorResults positionedCompetitors;
        TimePoint finishedTime;
        int passId;
        RacingProcedureType type = (RacingProcedureType)this.racingProcedureAnalyzer.analyze();
        if (!Util.equalsWithNull((Object)this.cachedRacingProcedureType, (Object)type) && type != RacingProcedureType.UNKNOWN) {
            this.cachedRacingProcedureType = type;
            this.cachedRacingProcedureTypeNoFallback = this.determineInitialProcedureType(type);
            this.recreateRacingProcedure(dependentRaceStates);
            this.changedListeners.onRacingProcedureChanged(this);
        }
        if (this.cachedPassId != (passId = this.raceLog.getCurrentPassId())) {
            this.cachedPassId = passId;
            this.changedListeners.onAdvancePass(this);
            this.cachedRacingProcedureType = null;
            this.cachedRacingProcedureTypeNoFallback = null;
        }
        StartTimeFinderResult startTimeFinderResult = this.updateStartTime();
        this.adjustObserverForRelativeStartTime(startTimeFinderResult, dependentRaceStates);
        TimePoint finishingTime = (TimePoint)this.finishingTimeAnalyzer.analyze();
        if (!Util.equalsWithNull((Object)this.cachedFinishingTime, (Object)finishingTime)) {
            this.cachedFinishingTime = finishingTime;
            this.changedListeners.onFinishingTimeChanged(this);
        }
        if (!Util.equalsWithNull((Object)this.cachedFinishedTime, (Object)(finishedTime = (TimePoint)this.finishedTimeAnalyzer.analyze()))) {
            this.cachedFinishedTime = finishedTime;
            this.changedListeners.onFinishedTimeChanged(this);
        }
        this.analyzeAndUpdateCachedRaceStatus();
        TimeRange protest = (TimeRange)this.protestTimeAnalyzer.analyze();
        if (!Util.equalsWithNull((Object)this.cachedProtest, (Object)protest)) {
            this.cachedProtest = protest;
            this.changedListeners.onProtestTimeChanged(this);
        }
        if (!Util.equalsWithNull((Object)this.cachedPositionedCompetitors, (Object)(positionedCompetitors = ((AbstractFinishPositioningListFinder.CompetitorResultsAndTheirCreationTimePoints)this.finishPositioningListAnalyzer.analyze()).getCompetitorResults()))) {
            this.cachedPositionedCompetitors = positionedCompetitors;
            this.changedListeners.onFinishingPositionsChanged(this);
        }
        if (!Util.equalsWithNull((Object)this.cachedConfirmedPositionedCompetitors, (Object)(confirmedPositionedCompetitors = (AbstractFinishPositioningListFinder.CompetitorResultsAndTheirCreationTimePoints)this.confirmedFinishPositioningListAnalyzer.analyze()))) {
            this.cachedConfirmedPositionedCompetitors = confirmedPositionedCompetitors;
            if (this.cachedConfirmedPositionedCompetitors != null) {
                this.changedListeners.onFinishingPositionsConfirmed(this);
            }
        }
        if (!Util.equalsWithNull((Object)this.cachedCourseDesign, (Object)(courseDesign = (CourseBase)this.courseDesignerAnalyzer.analyze()))) {
            this.cachedCourseDesign = courseDesign;
            this.changedListeners.onCourseDesignChanged(this);
        }
        if (!Util.equalsWithNull((Object)this.cachedWindFix, (Object)(windFix = (Wind)this.lastWindFixAnalyzer.analyze()))) {
            this.cachedWindFix = windFix;
            this.changedListeners.onWindFixChanged(this);
        }
        if (!Util.equalsWithNull(this.cachedTagEvents, (Object)(tagEvents = (Iterable)this.tagAnalyzer.analyze()))) {
            this.cachedTagEvents = tagEvents;
            this.changedListeners.onTagEventsChanged(this);
        }
        if ((resultsAreOfficialEvent = (RaceLogResultsAreOfficialEvent)this.resultsAreOfficialAnalyzer.analyze()) != null != this.cachedResultsAreOfficial) {
            this.cachedResultsAreOfficial = resultsAreOfficialEvent != null;
            this.changedListeners.onResultsAreOfficialChanged(this);
        }
    }

    private StartTimeFinderResult updateStartTime() {
        StartTimeFinderResult startTimeFinderResult = (StartTimeFinderResult)this.startTimeAnalyzer.analyze();
        if (!Util.equalsWithNull((Object)this.cachedStartTimeFinderResult, (Object)startTimeFinderResult)) {
            this.cachedStartTimeFinderResult = startTimeFinderResult;
            this.changedListeners.onStartTimeChanged(this);
        }
        return startTimeFinderResult;
    }

    protected void analyzeAndUpdateCachedRaceStatus() {
        Util.Pair statusAndTimePoint = (Util.Pair)this.statusAnalyzer.analyze();
        if (!Util.equalsWithNull((Object)this.cachedRaceStatus, (Object)statusAndTimePoint)) {
            this.updateCachedRaceStatusAndValidity((Util.Pair<RaceLogRaceStatus, TimePoint>)statusAndTimePoint);
        }
    }

    private void updateCachedRaceStatusAndValidity(Util.Pair<RaceLogRaceStatus, TimePoint> statusAndTimePoint) {
        RaceLogRaceStatus oldRaceStatus = this.cachedRaceStatus;
        this.cachedRaceStatus = (RaceLogRaceStatus)statusAndTimePoint.getA();
        this.clockTimePointWhenCachedRaceStatusWasSet = (TimePoint)statusAndTimePoint.getB();
        if (this.getStartTimeFinderResult() == null || this.getStartTime() == null) {
            this.timePointsWhenRaceStatusMayChange = Collections.emptyList();
        } else {
            TimePoint startTime = this.getStartTime();
            LinkedList<TimePoint> newTimePointsWhenRaceStatusMayChange = new LinkedList<TimePoint>();
            for (RaceStateEvent e : this.racingProcedure.createStartStateEvents(startTime)) {
                newTimePointsWhenRaceStatusMayChange.add(e.getTimePoint());
            }
            if (this.getFinishingTime() != null) {
                newTimePointsWhenRaceStatusMayChange.add(this.getFinishingTime());
            }
            if (this.getFinishedTime() != null) {
                newTimePointsWhenRaceStatusMayChange.add(this.getFinishedTime());
            }
            this.timePointsWhenRaceStatusMayChange = newTimePointsWhenRaceStatusMayChange;
        }
        if (!Util.equalsWithNull((Object)oldRaceStatus, (Object)this.cachedRaceStatus)) {
            this.changedListeners.onStatusChanged(this);
        }
    }

    private void recreateRacingProcedure(Map<SimpleRaceLogIdentifier, ReadonlyRaceState> dependentRaceStates) {
        if (this.racingProcedure != null) {
            this.removeChangedListener(this.racingProcedure);
            this.racingProcedure.detach();
        }
        this.racingProcedure = this.procedureFactory.createRacingProcedure(this.cachedRacingProcedureType, this.raceLog, this.raceLogResolver);
        this.racingProcedure.setStateEventScheduler(this.scheduler);
        this.addChangedListener(this.racingProcedure);
        this.statusAnalyzer = new RaceStatusAnalyzer(this.raceLogResolver, this.raceLog, this.statusAnalyzerClock, this.racingProcedure);
        this.update(dependentRaceStates);
    }

    @Override
    public UUID getCourseAreaId() {
        return this.cachedStartTimeFinderResult == null ? null : this.cachedStartTimeFinderResult.getCourseAreaId();
    }
}

