/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.abstractlog.race.state.impl;

import com.sap.sailing.domain.abstractlog.AbstractLogEventAuthor;
import com.sap.sailing.domain.abstractlog.race.CompetitorResults;
import com.sap.sailing.domain.abstractlog.race.RaceLog;
import com.sap.sailing.domain.abstractlog.race.SimpleRaceLogIdentifier;
import com.sap.sailing.domain.abstractlog.race.analyzing.impl.AdditionalScoringInformationFinder;
import com.sap.sailing.domain.abstractlog.race.analyzing.impl.RaceLogResolver;
import com.sap.sailing.domain.abstractlog.race.analyzing.impl.RaceStatusAnalyzer;
import com.sap.sailing.domain.abstractlog.race.impl.RaceLogCourseDesignChangedEventImpl;
import com.sap.sailing.domain.abstractlog.race.impl.RaceLogDependentStartTimeEventImpl;
import com.sap.sailing.domain.abstractlog.race.impl.RaceLogFinishPositioningConfirmedEventImpl;
import com.sap.sailing.domain.abstractlog.race.impl.RaceLogFinishPositioningListChangedEventImpl;
import com.sap.sailing.domain.abstractlog.race.impl.RaceLogFlagEventImpl;
import com.sap.sailing.domain.abstractlog.race.impl.RaceLogPassChangeEventImpl;
import com.sap.sailing.domain.abstractlog.race.impl.RaceLogProtestStartTimeEventImpl;
import com.sap.sailing.domain.abstractlog.race.impl.RaceLogRaceStatusEventImpl;
import com.sap.sailing.domain.abstractlog.race.impl.RaceLogResultsAreOfficialEventImpl;
import com.sap.sailing.domain.abstractlog.race.impl.RaceLogStartProcedureChangedEventImpl;
import com.sap.sailing.domain.abstractlog.race.impl.RaceLogStartTimeEventImpl;
import com.sap.sailing.domain.abstractlog.race.impl.RaceLogWindFixEventImpl;
import com.sap.sailing.domain.abstractlog.race.scoring.AdditionalScoringInformationType;
import com.sap.sailing.domain.abstractlog.race.scoring.RaceLogAdditionalScoringInformationEvent;
import com.sap.sailing.domain.abstractlog.race.scoring.impl.RaceLogAdditionalScoringInformationEventImpl;
import com.sap.sailing.domain.abstractlog.race.state.RaceState;
import com.sap.sailing.domain.abstractlog.race.state.impl.ReadonlyRaceStateImpl;
import com.sap.sailing.domain.abstractlog.race.state.racingprocedure.RacingProcedure;
import com.sap.sailing.domain.abstractlog.race.state.racingprocedure.RacingProcedureFactory;
import com.sap.sailing.domain.abstractlog.race.state.racingprocedure.impl.RacingProcedureFactoryImpl;
import com.sap.sailing.domain.base.CourseBase;
import com.sap.sailing.domain.base.configuration.ConfigurationLoader;
import com.sap.sailing.domain.base.configuration.RegattaConfiguration;
import com.sap.sailing.domain.base.configuration.impl.EmptyRegattaConfiguration;
import com.sap.sailing.domain.common.CourseDesignerMode;
import com.sap.sailing.domain.common.Wind;
import com.sap.sailing.domain.common.abstractlog.NotRevokableException;
import com.sap.sailing.domain.common.racelog.Flags;
import com.sap.sailing.domain.common.racelog.RaceLogRaceStatus;
import com.sap.sailing.domain.common.racelog.RacingProcedureType;
import com.sap.sse.common.Duration;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.TimeRange;
import java.util.Collections;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;

public class RaceStateImpl
extends ReadonlyRaceStateImpl
implements RaceState {
    private static final Logger logger = Logger.getLogger(RaceStateImpl.class.getName());
    private final AbstractLogEventAuthor author;

    public static RaceState create(RaceLogResolver raceLogResolver, RaceLog raceLog, AbstractLogEventAuthor author) {
        return RaceStateImpl.create(raceLogResolver, raceLog, author, new EmptyRegattaConfiguration());
    }

    public static RaceState create(RaceLogResolver raceLogResolver, RaceLog raceLog, AbstractLogEventAuthor author, ConfigurationLoader<RegattaConfiguration> configuration) {
        return new RaceStateImpl(raceLogResolver, raceLog, author, new RacingProcedureFactoryImpl(author, configuration));
    }

    public RaceStateImpl(RaceLogResolver raceLogResolver, RaceLog raceLog, AbstractLogEventAuthor author, RacingProcedureFactory procedureFactory) {
        this(raceLogResolver, raceLog, author, new RaceStatusAnalyzer.StandardClock(), procedureFactory);
    }

    private RaceStateImpl(RaceLogResolver raceLogResolver, RaceLog raceLog, AbstractLogEventAuthor author, RaceStatusAnalyzer.Clock analyzersClock, RacingProcedureFactory procedureFactory) {
        super(raceLogResolver, raceLog, null, analyzersClock, procedureFactory, Collections.emptyMap());
        this.author = author;
    }

    @Override
    public RacingProcedure getRacingProcedure() {
        return (RacingProcedure)super.getRacingProcedure();
    }

    @Override
    public <T extends RacingProcedure> T getTypedRacingProcedure() {
        return (T)this.getRacingProcedure();
    }

    @Override
    public <T extends RacingProcedure> T getTypedRacingProcedure(Class<T> clazz) {
        RacingProcedure procedure = this.getRacingProcedure();
        if (clazz.isAssignableFrom(procedure.getClass())) {
            return (T)procedure;
        }
        return null;
    }

    @Override
    public AbstractLogEventAuthor getAuthor() {
        return this.author;
    }

    @Override
    public void setRacingProcedure(TimePoint timePoint, RacingProcedureType newType) {
        this.raceLog.add(new RaceLogStartProcedureChangedEventImpl(timePoint, this.author, this.raceLog.getCurrentPassId(), newType));
    }

    @Override
    public void forceNewStartTime(TimePoint now, TimePoint startTime, UUID courseAreaId) {
        this.raceLog.add(new RaceLogStartTimeEventImpl(now, this.author, this.raceLog.getCurrentPassId(), startTime, courseAreaId));
    }

    @Override
    public void forceNewDependentStartTime(TimePoint now, Duration startTimeDifference, SimpleRaceLogIdentifier dependentOnRace, UUID courseAreaId) {
        this.raceLog.add(new RaceLogDependentStartTimeEventImpl(now, this.author, this.raceLog.getCurrentPassId(), dependentOnRace, startTimeDifference, courseAreaId));
    }

    @Override
    public void setFinishingTime(TimePoint timePoint) {
        this.raceLog.add(new RaceLogRaceStatusEventImpl(timePoint, this.author, this.raceLog.getCurrentPassId(), RaceLogRaceStatus.FINISHING));
    }

    @Override
    public void setFinishedTime(TimePoint timePoint) {
        this.raceLog.add(new RaceLogRaceStatusEventImpl(timePoint, this.author, this.raceLog.getCurrentPassId(), RaceLogRaceStatus.FINISHED));
        this.forceUpdate();
    }

    @Override
    public void setResultsAreOfficial(TimePoint timePoint) {
        this.raceLog.add(new RaceLogResultsAreOfficialEventImpl(timePoint, this.author, this.raceLog.getCurrentPassId()));
    }

    @Override
    public void setProtestTime(TimePoint now, TimeRange protestTime) {
        assert (protestTime != null && protestTime.from() != null && protestTime.to() != null);
        this.raceLog.add(new RaceLogProtestStartTimeEventImpl(now, this.author, this.raceLog.getCurrentPassId(), protestTime));
    }

    @Override
    public void setAdvancePass(TimePoint timePoint) {
        this.raceLog.add(new RaceLogPassChangeEventImpl(timePoint, this.author, this.raceLog.getCurrentPassId() + 1));
    }

    @Override
    public void setAborted(TimePoint timePoint, boolean isPostponed, Flags reasonFlag) {
        Flags markerFlag = isPostponed ? Flags.AP : Flags.NOVEMBER;
        this.raceLog.add(new RaceLogFlagEventImpl(timePoint, this.author, this.raceLog.getCurrentPassId(), markerFlag, reasonFlag, true));
    }

    @Override
    public void setGeneralRecall(TimePoint timePoint) {
        this.raceLog.add(new RaceLogFlagEventImpl(timePoint, this.author, this.raceLog.getCurrentPassId(), Flags.FIRSTSUBSTITUTE, Flags.NONE, true));
    }

    @Override
    public void setFinishPositioningListChanged(TimePoint timePoint, CompetitorResults positionedCompetitors) {
        this.raceLog.add(new RaceLogFinishPositioningListChangedEventImpl(timePoint, this.author, this.raceLog.getCurrentPassId(), positionedCompetitors));
    }

    @Override
    public void setFinishPositioningConfirmed(TimePoint timePoint, CompetitorResults positionedCompetitors) {
        this.raceLog.add(new RaceLogFinishPositioningConfirmedEventImpl(timePoint, this.author, this.raceLog.getCurrentPassId(), positionedCompetitors));
    }

    @Override
    public void setCourseDesign(TimePoint timePoint, CourseBase courseDesign, CourseDesignerMode courseDesignerMode) {
        this.raceLog.add(new RaceLogCourseDesignChangedEventImpl(timePoint, this.author, this.raceLog.getCurrentPassId(), courseDesign, courseDesignerMode));
    }

    @Override
    public void setWindFix(TimePoint timePoint, Wind wind, boolean isMagnetic) {
        this.raceLog.add(new RaceLogWindFixEventImpl(timePoint, this.author, this.raceLog.getCurrentPassId(), wind, isMagnetic));
    }

    @Override
    public void setAdditionalScoringInformationEnabled(TimePoint timePoint, boolean enable, AdditionalScoringInformationType informationType) {
        RaceLogAdditionalScoringInformationEvent event = new AdditionalScoringInformationFinder(this.raceLog).analyze(informationType);
        if (enable) {
            if (event == null) {
                this.raceLog.add(new RaceLogAdditionalScoringInformationEventImpl(timePoint, this.author, this.raceLog.getCurrentPassId(), informationType));
            }
        } else if (event != null) {
            try {
                this.raceLog.revokeEvent(this.author, event, "disable additional scoring information");
            }
            catch (NotRevokableException e) {
                logger.log(Level.WARNING, "Could not disable scoring information by adding RevokeEvent", e);
            }
        }
    }

    @Override
    public boolean isAdditionalScoringInformationEnabled(AdditionalScoringInformationType informationType) {
        RaceLogAdditionalScoringInformationEvent event = new AdditionalScoringInformationFinder(this.raceLog).analyze(informationType);
        return event != null;
    }

    @Override
    public void forceUpdate() {
        super.update();
    }
}

