/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.abstractlog.race.impl;

import com.sap.sailing.domain.abstractlog.AbstractLogEventAuthor;
import com.sap.sailing.domain.abstractlog.race.RaceLogEventVisitor;
import com.sap.sailing.domain.abstractlog.race.RaceLogStartTimeEvent;
import com.sap.sailing.domain.abstractlog.race.impl.RaceLogRaceStatusEventImpl;
import com.sap.sailing.domain.common.racelog.RaceLogRaceStatus;
import com.sap.sse.common.TimePoint;
import java.io.Serializable;
import java.util.UUID;

public class RaceLogStartTimeEventImpl
extends RaceLogRaceStatusEventImpl
implements RaceLogStartTimeEvent {
    private static final long serialVersionUID = 8185811395997196162L;
    private final TimePoint startTime;
    private final UUID courseAreaId;

    public RaceLogStartTimeEventImpl(TimePoint createdAt, TimePoint pTimePoint, AbstractLogEventAuthor author, Serializable pId, int pPassId, TimePoint pStartTime, RaceLogRaceStatus nextStatus, UUID courseAreaId) {
        super(createdAt, pTimePoint, author, pId, pPassId, nextStatus);
        this.startTime = pStartTime;
        this.courseAreaId = courseAreaId;
    }

    public RaceLogStartTimeEventImpl(TimePoint logicalTimePoint, AbstractLogEventAuthor author, int pPassId, TimePoint pStartTime, UUID courseAreaId) {
        this(RaceLogStartTimeEventImpl.now(), logicalTimePoint, author, RaceLogStartTimeEventImpl.randId(), pPassId, pStartTime, RaceLogRaceStatus.SCHEDULED, courseAreaId);
    }

    @Override
    public TimePoint getStartTime() {
        return this.startTime;
    }

    @Override
    public UUID getCourseAreaId() {
        return this.courseAreaId;
    }

    @Override
    public void accept(RaceLogEventVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public String getShortInfo() {
        return "startTime=" + this.startTime + (this.getCourseAreaId() == null ? "" : ", course area ID=" + this.getCourseAreaId().toString());
    }
}

