/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.abstractlog.race.analyzing.impl;

import com.sap.sailing.domain.abstractlog.race.RaceLog;
import com.sap.sailing.domain.abstractlog.race.RaceLogEvent;
import com.sap.sailing.domain.abstractlog.race.RaceLogRevokeEvent;
import com.sap.sailing.domain.abstractlog.race.RaceLogTagEvent;
import com.sap.sailing.domain.abstractlog.race.analyzing.impl.RaceLogAnalyzer;
import java.util.ArrayList;
import java.util.List;

public class TagFinder
extends RaceLogAnalyzer<List<RaceLogTagEvent>> {
    private final RaceLog raceLog;
    private final boolean onlyUnrevokedEvents;

    public TagFinder(RaceLog raceLog) {
        this(raceLog, false);
    }

    public TagFinder(RaceLog raceLog, boolean onlyUnrevokedEvents) {
        super(raceLog);
        this.raceLog = raceLog;
        this.onlyUnrevokedEvents = onlyUnrevokedEvents;
    }

    @Override
    protected List<RaceLogTagEvent> performAnalysis() {
        Iterable raceLogEvents = this.onlyUnrevokedEvents ? this.raceLog.getUnrevokedEvents() : this.getAllEvents();
        ArrayList<RaceLogTagEvent> result = new ArrayList<RaceLogTagEvent>();
        for (RaceLogEvent raceLogEvent : raceLogEvents) {
            RaceLogTagEvent revokedTagEvent;
            int index;
            RaceLogRevokeEvent revokeEvent;
            RaceLogEvent revokedEvent;
            if (raceLogEvent instanceof RaceLogTagEvent) {
                result.add((RaceLogTagEvent)raceLogEvent);
                continue;
            }
            if (!(raceLogEvent instanceof RaceLogRevokeEvent) || (revokedEvent = (RaceLogEvent)this.raceLog.getEventById((revokeEvent = (RaceLogRevokeEvent)raceLogEvent).getRevokedEventId())) == null || !(revokedEvent instanceof RaceLogTagEvent) || (index = result.indexOf(revokedTagEvent = (RaceLogTagEvent)revokedEvent)) < 0) continue;
            ((RaceLogTagEvent)result.get(index)).markAsRevoked(revokeEvent.getCreatedAt());
        }
        return result;
    }
}

