/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.abstractlog.race.analyzing.impl;

import com.sap.sailing.domain.abstractlog.race.RaceLog;
import com.sap.sailing.domain.abstractlog.race.RaceLogEvent;
import com.sap.sailing.domain.abstractlog.race.RaceLogFlagEvent;
import com.sap.sailing.domain.abstractlog.race.analyzing.impl.RaceLogAnalyzer;
import com.sap.sailing.domain.abstractlog.race.analyzing.impl.RacingProcedureTypeAnalyzer;
import com.sap.sailing.domain.abstractlog.race.impl.RaceLogImpl;
import com.sap.sailing.domain.abstractlog.race.state.racingprocedure.impl.RacingProcedureFactoryImpl;
import com.sap.sailing.domain.abstractlog.race.state.racingprocedure.line.ConfigurableStartModeFlagRacingProcedure;
import com.sap.sailing.domain.base.configuration.impl.EmptyRegattaConfiguration;
import com.sap.sailing.domain.common.racelog.Flags;
import com.sap.sailing.domain.common.racelog.RacingProcedureType;
import java.util.List;
import java.util.UUID;

public class StartModeFlagFinder
extends RaceLogAnalyzer<Flags> {
    private final RacingProcedureTypeAnalyzer procedureAnalyzer;
    private final List<Flags> startModeFlags;

    public StartModeFlagFinder(RacingProcedureTypeAnalyzer procedureAnalyzer, RaceLog raceLog, List<Flags> startModeFlags) {
        super(raceLog);
        if (raceLog != procedureAnalyzer.getLog()) {
            throw new IllegalArgumentException("Both analyzers must operate on the same race log.");
        }
        this.procedureAnalyzer = procedureAnalyzer;
        this.startModeFlags = startModeFlags;
    }

    @Override
    protected Flags performAnalysis() {
        RacingProcedureType type = (RacingProcedureType)this.procedureAnalyzer.analyze();
        if (type == RacingProcedureType.UNKNOWN || !(new RacingProcedureFactoryImpl(null, new EmptyRegattaConfiguration()).createRacingProcedure(type, new RaceLogImpl(UUID.randomUUID()), null) instanceof ConfigurableStartModeFlagRacingProcedure)) {
            return null;
        }
        for (RaceLogEvent event : this.getPassEventsDescending()) {
            RaceLogFlagEvent flagEvent;
            if (!(event instanceof RaceLogFlagEvent) || !this.isStartModeFlagEvent(flagEvent = (RaceLogFlagEvent)event)) continue;
            return flagEvent.getUpperFlag();
        }
        return null;
    }

    private boolean isStartModeFlagEvent(RaceLogFlagEvent event) {
        boolean result = event.getLowerFlag().equals((Object)Flags.NONE) ? this.startModeFlags.contains(event.getUpperFlag()) : false;
        return result;
    }
}

