/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.abstractlog.race.analyzing.impl;

import com.sap.sailing.domain.abstractlog.race.RaceLog;
import com.sap.sailing.domain.abstractlog.race.RaceLogDependentStartTimeEvent;
import com.sap.sailing.domain.abstractlog.race.RaceLogEvent;
import com.sap.sailing.domain.abstractlog.race.RaceLogRaceStatusEvent;
import com.sap.sailing.domain.abstractlog.race.RaceLogStartTimeEvent;
import com.sap.sailing.domain.abstractlog.race.analyzing.impl.DependentStartTimeResolver;
import com.sap.sailing.domain.abstractlog.race.analyzing.impl.RaceLogAnalyzer;
import com.sap.sailing.domain.abstractlog.race.analyzing.impl.RaceLogResolver;
import com.sap.sailing.domain.abstractlog.race.impl.BaseRaceLogEventVisitor;
import com.sap.sailing.domain.abstractlog.race.impl.RaceLogRaceStatusEventComparator;
import com.sap.sailing.domain.abstractlog.race.state.racingprocedure.ReadonlyRacingProcedure;
import com.sap.sailing.domain.common.racelog.RaceLogRaceStatus;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.Util;
import com.sap.sse.common.impl.MillisecondsTimePoint;
import com.sap.sse.shared.util.impl.ArrayListNavigableSet;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;

public class RaceStatusAnalyzer
extends RaceLogAnalyzer<Util.Pair<RaceLogRaceStatus, TimePoint>> {
    private final RaceLogResolver resolver;
    private final Clock clock;
    private final ReadonlyRacingProcedure racingProcedure;
    private static final Set<RaceLogRaceStatus> statusTypesToIgnoreIfEventNotValidYet = new HashSet<RaceLogRaceStatus>(Arrays.asList(RaceLogRaceStatus.FINISHED, RaceLogRaceStatus.FINISHING));

    public RaceStatusAnalyzer(RaceLogResolver resolver, RaceLog raceLog, ReadonlyRacingProcedure racingProcedure) {
        this(resolver, raceLog, new StandardClock(), racingProcedure);
    }

    public RaceStatusAnalyzer(RaceLogResolver resolver, RaceLog raceLog, Clock clock, ReadonlyRacingProcedure racingProcedure) {
        super(raceLog);
        this.resolver = resolver;
        this.clock = clock;
        this.racingProcedure = racingProcedure;
    }

    @Override
    protected Util.Pair<RaceLogRaceStatus, TimePoint> performAnalysis() {
        ArrayListNavigableSet statusEvents = new ArrayListNavigableSet((Comparator)RaceLogRaceStatusEventComparator.INSTANCE);
        for (RaceLogEvent event : this.getPassUnrevokedEvents()) {
            if (!(event instanceof RaceLogRaceStatusEvent)) continue;
            statusEvents.add((Object)((RaceLogRaceStatusEvent)event));
        }
        TimePoint now = this.clock.now();
        EventDispatcher eventDispatcher = new EventDispatcher(now, this.racingProcedure);
        HashSet<RaceLogRaceStatus> statusesToIgnore = new HashSet<RaceLogRaceStatus>();
        RaceLogRaceStatus result = RaceLogRaceStatus.UNSCHEDULED;
        for (RaceLogRaceStatusEvent event : statusEvents.descendingSet()) {
            boolean dispatch;
            if (statusTypesToIgnoreIfEventNotValidYet.contains(event.getNextStatus())) {
                if (statusesToIgnore.contains(event.getNextStatus()) || event.getLogicalTimePoint() == null || event.getLogicalTimePoint().after(now)) {
                    statusesToIgnore.add(event.getNextStatus());
                    dispatch = false;
                } else {
                    dispatch = true;
                }
            } else {
                dispatch = true;
            }
            if (!dispatch) continue;
            event.accept(eventDispatcher);
            result = eventDispatcher.nextStatus;
            break;
        }
        return new Util.Pair((Object)result, (Object)now);
    }

    public static interface Clock {
        public TimePoint now();
    }

    private class EventDispatcher
    extends BaseRaceLogEventVisitor {
        private final TimePoint now;
        private final ReadonlyRacingProcedure racingProcedure;
        public RaceLogRaceStatus nextStatus;

        public EventDispatcher(TimePoint now, ReadonlyRacingProcedure racingProcedure) {
            this.now = now;
            this.racingProcedure = racingProcedure;
            this.nextStatus = RaceLogRaceStatus.UNKNOWN;
        }

        @Override
        public void visit(RaceLogStartTimeEvent event) {
            TimePoint startTime = event.getStartTime();
            this.setRaceLogStatusBasedOnStartTime(startTime);
        }

        private void setRaceLogStatusBasedOnStartTime(TimePoint startTime) {
            this.nextStatus = startTime == null ? RaceLogRaceStatus.PRESCHEDULED : (this.racingProcedure.isStartphaseActive(startTime, this.now) ? RaceLogRaceStatus.STARTPHASE : (this.now.before(startTime) ? RaceLogRaceStatus.SCHEDULED : RaceLogRaceStatus.RUNNING));
        }

        @Override
        public void visit(RaceLogRaceStatusEvent event) {
            this.nextStatus = event.getNextStatus();
        }

        @Override
        public void visit(RaceLogDependentStartTimeEvent event) {
            DependentStartTimeResolver startTimeResolver = new DependentStartTimeResolver(RaceStatusAnalyzer.this.resolver);
            TimePoint startTime = startTimeResolver.resolve(event).getStartTime();
            this.setRaceLogStatusBasedOnStartTime(startTime);
        }
    }

    public static final class StandardClock
    implements Clock {
        @Override
        public TimePoint now() {
            return MillisecondsTimePoint.now();
        }
    }
}

