/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.abstractlog.race.analyzing.impl;

import com.sap.sailing.domain.abstractlog.race.RaceLog;
import com.sap.sailing.domain.abstractlog.race.RaceLogDependentStartTimeEvent;
import com.sap.sailing.domain.abstractlog.race.SimpleRaceLogIdentifier;
import com.sap.sailing.domain.abstractlog.race.analyzing.impl.RaceLogResolver;
import com.sap.sailing.domain.abstractlog.race.analyzing.impl.StartTimeFinder;
import com.sap.sailing.domain.abstractlog.race.analyzing.impl.StartTimeFinderResult;
import com.sap.sse.common.Duration;
import com.sap.sse.common.Util;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;

public class DependentStartTimeResolver {
    private RaceLogResolver raceLogResolver;

    public DependentStartTimeResolver(RaceLogResolver raceLogResolver) {
        this.raceLogResolver = raceLogResolver;
    }

    public StartTimeFinderResult resolve(RaceLogDependentStartTimeEvent event) {
        List<SimpleRaceLogIdentifier> dependingOnRaces = Collections.emptyList();
        return this.internalResolve(event, dependingOnRaces);
    }

    StartTimeFinderResult internalResolve(RaceLogDependentStartTimeEvent event, Iterable<SimpleRaceLogIdentifier> dependingOnRaces) {
        StartTimeFinderResult result;
        SimpleRaceLogIdentifier identifier = event.getDependentOnRaceIdentifier();
        Duration startTimeDifference = event.getStartTimeDifference();
        RaceLog raceLog = this.raceLogResolver.resolve(identifier);
        if (raceLog == null) {
            result = new StartTimeFinderResult(dependingOnRaces, startTimeDifference, StartTimeFinderResult.ResolutionFailed.RACE_LOG_UNRESOLVED, null);
        } else {
            ArrayList<SimpleRaceLogIdentifier> extendedDependingOnRaces = new ArrayList<SimpleRaceLogIdentifier>();
            Util.addAll(dependingOnRaces, extendedDependingOnRaces);
            extendedDependingOnRaces.add(identifier);
            if (this.containsCycle(extendedDependingOnRaces)) {
                result = new StartTimeFinderResult(extendedDependingOnRaces, null, StartTimeFinderResult.ResolutionFailed.CYCLIC_DEPENDENCY, null);
            } else {
                StartTimeFinder dependentStartTimeFinder = new StartTimeFinder(this.raceLogResolver, raceLog);
                StartTimeFinderResult resultOfDependentRace = dependentStartTimeFinder.analyze(extendedDependingOnRaces);
                if (resultOfDependentRace.getStartTime() == null) {
                    resultOfDependentRace.setStartTimeDiff(startTimeDifference);
                    result = resultOfDependentRace;
                } else {
                    result = new StartTimeFinderResult(resultOfDependentRace.getDependingOnRaces(), resultOfDependentRace.getStartTime().plus(startTimeDifference), startTimeDifference, event.getCourseAreaId());
                }
            }
        }
        return result;
    }

    private boolean containsCycle(Iterable<SimpleRaceLogIdentifier> dependingOnRaces) {
        HashSet dependingOnRacesHashSet = new HashSet();
        Util.addAll(dependingOnRaces, dependingOnRacesHashSet);
        return dependingOnRacesHashSet.size() < Util.size(dependingOnRaces);
    }
}

