/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.abstractlog.impl;

import com.sap.sailing.domain.abstractlog.AbstractLog;
import com.sap.sailing.domain.abstractlog.AbstractLogEvent;
import com.sap.sailing.domain.abstractlog.BaseLogAnalyzer;
import java.util.ArrayList;
import java.util.List;

public class AllEventsOfTypeFinder<LogT extends AbstractLog<EventT, VisitorT>, EventT extends AbstractLogEvent<VisitorT>, VisitorT>
extends BaseLogAnalyzer<LogT, EventT, VisitorT, List<EventT>> {
    private final Class<?> ofType;
    private final boolean onlyUnrevoked;

    public AllEventsOfTypeFinder(LogT log, boolean onlyUnrevoked, Class<?> ofType) {
        super(log);
        this.ofType = ofType;
        this.onlyUnrevoked = onlyUnrevoked;
    }

    @Override
    protected List<EventT> performAnalysis() {
        ArrayList<AbstractLogEvent> result = new ArrayList<AbstractLogEvent>();
        Iterable set = this.onlyUnrevoked ? this.getLog().getUnrevokedEventsDescending() : this.getAllEventsDescending();
        for (AbstractLogEvent event : set) {
            if (!this.ofType.isAssignableFrom(event.getClass())) continue;
            result.add(event);
        }
        return result;
    }
}

