/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.kiworesultimport.impl;

import com.sap.sailing.kiworesultimport.Start;
import com.sap.sailing.kiworesultimport.StartReport;
import com.sap.sailing.kiworesultimport.impl.AbstractNodeWrapper;
import com.sap.sailing.kiworesultimport.impl.StartImpl;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.impl.MillisecondsTimePoint;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class StartReportImpl
extends AbstractNodeWrapper
implements StartReport {
    private static final DateFormat df = new SimpleDateFormat("yyyy-MM-ddX");
    private final String sourceName;

    public StartReportImpl(Node node, String sourceName) {
        super(node);
        this.sourceName = sourceName;
    }

    @Override
    public String getSourceName() {
        return this.sourceName;
    }

    @Override
    public String getDateAsString() {
        return ((Element)this.getNode()).getElementsByTagName("datum").item(0).getNodeValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TimePoint getTimePoint() throws ParseException {
        String datum = this.getDateAsString();
        DateFormat dateFormat = df;
        synchronized (dateFormat) {
            return datum == null || datum.trim().length() == 0 ? null : new MillisecondsTimePoint(df.parse(datum));
        }
    }

    @Override
    public String getCourseAreaName() {
        return ((Element)this.getNode()).getElementsByTagName("regattabahn").item(0).getNodeValue();
    }

    @Override
    public String getStartBearingAsString() {
        return ((Element)this.getNode()).getElementsByTagName("kompasskurs").item(0).getNodeValue();
    }

    @Override
    public String getWindSpeedAsString() {
        return ((Element)this.getNode()).getElementsByTagName("windstaerke").item(0).getNodeValue();
    }

    @Override
    public String getWindDirectionAsString() {
        return ((Element)this.getNode()).getElementsByTagName("windrichtung").item(0).getNodeValue();
    }

    @Override
    public Iterable<Start> getStarts() {
        ArrayList<Start> result = new ArrayList<Start>();
        NodeList starts = ((Element)this.getNode()).getElementsByTagName("start");
        int i = 0;
        while (i < starts.getLength()) {
            Element startNode = (Element)starts.item(i);
            StartImpl start = new StartImpl(startNode);
            if (start.getBoatClass() != null) {
                result.add(start);
            }
            ++i;
        }
        return result;
    }
}

