/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.kiworesultimport.impl;

import com.sap.sailing.domain.common.RegattaScoreCorrections;
import com.sap.sailing.domain.common.ScoreCorrectionProvider;
import com.sap.sailing.kiworesultimport.ParserFactory;
import com.sap.sailing.kiworesultimport.RegattaSummary;
import com.sap.sailing.kiworesultimport.ZipFile;
import com.sap.sailing.kiworesultimport.ZipFileParser;
import com.sap.sailing.kiworesultimport.impl.RegattaSummaryAsScoreCorrections;
import com.sap.sailing.resultimport.ResultDocumentDescriptor;
import com.sap.sailing.resultimport.impl.AbstractFileBasedScoreCorrectionProvider;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.Util;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

public class ScoreCorrectionProviderImpl
extends AbstractFileBasedScoreCorrectionProvider {
    private static final long serialVersionUID = -4596215011753860781L;
    private static final String name = "Kieler Woche Official Results by b+m";

    public ScoreCorrectionProviderImpl(File scanDir) {
        super(scanDir);
    }

    public String getName() {
        return name;
    }

    public Map<String, Set<Util.Pair<String, TimePoint>>> getHasResultsForBoatClassFromDateByEventName() throws IOException, SAXException, ParserConfigurationException, URISyntaxException {
        HashMap<String, Set<Util.Pair<String, TimePoint>>> result = new HashMap<String, Set<Util.Pair<String, TimePoint>>>();
        for (RegattaSummary regattaSummary : this.getAllRegattaSummaries()) {
            String eventName = regattaSummary.getEventName();
            HashSet<Util.Pair> resultTimesForBoatClassNames = (HashSet<Util.Pair>)result.get(eventName);
            if (resultTimesForBoatClassNames == null) {
                resultTimesForBoatClassNames = new HashSet<Util.Pair>();
                result.put(eventName, resultTimesForBoatClassNames);
            }
            resultTimesForBoatClassNames.add(new Util.Pair((Object)regattaSummary.getBoatClassName(), (Object)regattaSummary.getTimePointPublished()));
        }
        return result;
    }

    public RegattaScoreCorrections getScoreCorrections(InputStream inputStream) throws Exception {
        Iterable<RegattaSummary> regattaSummariesFromInputStream = this.getRegattaSummaries(inputStream);
        RegattaSummaryAsScoreCorrections result = regattaSummariesFromInputStream == null || Util.isEmpty(regattaSummariesFromInputStream) ? null : new RegattaSummaryAsScoreCorrections(regattaSummariesFromInputStream.iterator().next(), (ScoreCorrectionProvider)this);
        return result;
    }

    private Iterable<RegattaSummary> getAllRegattaSummaries() throws IOException, SAXException, ParserConfigurationException, URISyntaxException {
        ArrayList<RegattaSummary> result = new ArrayList<RegattaSummary>();
        for (ResultDocumentDescriptor resultDocDescr : this.getResultDocumentProvider().getResultDocumentDescriptors()) {
            if (!resultDocDescr.getDocumentName().toLowerCase().endsWith(".zip")) continue;
            Util.addAll(this.getRegattaSummaries(resultDocDescr.getInputStream()), result);
        }
        return result;
    }

    private Iterable<RegattaSummary> getRegattaSummaries(InputStream inputStream) throws IOException, SAXException, ParserConfigurationException {
        ZipFileParser zipFileParser = ParserFactory.INSTANCE.createZipFileParser();
        ZipFile zipFile = zipFileParser.parse(inputStream);
        return zipFile.getRegattaSummaries();
    }

    public RegattaScoreCorrections getScoreCorrections(String eventName, String boatClassName, TimePoint timePointPublished) throws IOException, SAXException, ParserConfigurationException, URISyntaxException {
        for (RegattaSummary regattaSummary : this.getAllRegattaSummaries()) {
            if (!regattaSummary.getEventName().equals(eventName) || !regattaSummary.getBoatClassName().equals(boatClassName) || !regattaSummary.getTimePointPublished().equals(timePointPublished)) continue;
            return new RegattaSummaryAsScoreCorrections(regattaSummary, (ScoreCorrectionProvider)this);
        }
        return null;
    }
}

