/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.kiworesultimport.impl;

import com.sap.sailing.kiworesultimport.Boat;
import com.sap.sailing.kiworesultimport.BoatResultInRace;
import com.sap.sailing.kiworesultimport.RaceSummary;
import java.util.HashMap;
import java.util.Map;

public class RaceSummaryImpl
implements RaceSummary {
    private final String boatClassName;
    private final Map<Boat, BoatResultInRace> boatResults;
    private final Map<String, Boat> sailingNumberToBoat;
    private final Iterable<String> fleetNames;
    private final int raceNumber;

    public RaceSummaryImpl(String boatClassName, Map<Boat, BoatResultInRace> boatResults, Iterable<String> fleetNames, int raceNumber) {
        this.boatClassName = boatClassName;
        this.boatResults = boatResults;
        this.raceNumber = raceNumber;
        this.fleetNames = fleetNames;
        this.sailingNumberToBoat = new HashMap<String, Boat>();
        for (Boat boat : boatResults.keySet()) {
            this.sailingNumberToBoat.put(boat.getSailingNumber(), boat);
        }
    }

    @Override
    public String getBoatClassName() {
        return this.boatClassName;
    }

    @Override
    public int getRaceNumber() {
        return this.raceNumber;
    }

    @Override
    public Iterable<Boat> getBoats() {
        return this.boatResults.keySet();
    }

    @Override
    public BoatResultInRace getBoatResults(Boat boat) {
        return this.boatResults.get(boat);
    }

    @Override
    public Boat getBoat(String sailingNumber) {
        return this.sailingNumberToBoat.get(sailingNumber);
    }

    @Override
    public Iterable<String> getFleetNames() {
        return this.fleetNames;
    }
}

