/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.ui.simulator.streamlets;

import com.google.gwt.maps.client.base.LatLng;
import com.google.gwt.maps.client.base.LatLngBounds;
import com.sap.sailing.domain.common.Position;
import com.sap.sailing.domain.common.WindSource;
import com.sap.sailing.domain.common.confidence.BearingWithConfidence;
import com.sap.sailing.domain.common.confidence.BearingWithConfidenceCluster;
import com.sap.sailing.domain.common.confidence.Weigher;
import com.sap.sailing.domain.common.confidence.impl.BearingWithConfidenceImpl;
import com.sap.sailing.domain.common.impl.MeterDistance;
import com.sap.sailing.gwt.ui.client.shared.racemap.CoordinateSystem;
import com.sap.sailing.gwt.ui.shared.WindDTO;
import com.sap.sailing.gwt.ui.shared.WindInfoForRaceDTO;
import com.sap.sailing.gwt.ui.shared.WindTrackInfoDTO;
import com.sap.sailing.gwt.ui.simulator.streamlets.PositionDTOWeigher;
import com.sap.sailing.gwt.ui.simulator.streamlets.Vector;
import com.sap.sailing.gwt.ui.simulator.streamlets.VectorField;
import com.sap.sse.common.Bearing;
import com.sap.sse.common.Distance;
import com.sap.sse.common.Util;
import com.sap.sse.common.impl.DegreeBearingImpl;
import java.util.Date;
import java.util.List;
import java.util.Map;

public class WindInfoForRaceVectorField
implements VectorField,
PositionDTOWeigher.AverageLatitudeProvider {
    private static final double MAX_WIND_SPEED_IN_KNOTS = 40.0;
    private final LatLngBounds infiniteBounds = LatLngBounds.newInstance((LatLng)LatLng.newInstance((double)-90.0, (double)-180.0), (LatLng)LatLng.newInstance((double)90.0, (double)180.0));
    private final Weigher<Position> weigher;
    private double averageLatitudeCosine;
    private double knotsInDegreePerFrame;
    private long latitudeCount;
    private double latitudeSum;
    private final CoordinateSystem coordinateSystem;
    private final BearingWithConfidenceCluster<Position> bearingCluster;
    private final WindInfoForRaceDTO windInfoForRace;

    public WindInfoForRaceVectorField(WindInfoForRaceDTO windInfoForRace, double framesPerSecond, CoordinateSystem coordinateSystem) {
        this.coordinateSystem = coordinateSystem;
        this.windInfoForRace = windInfoForRace;
        this.knotsInDegreePerFrame = 4.6296296296296296E-6 / framesPerSecond;
        this.weigher = new PositionDTOWeigher((Distance)new MeterDistance(100.0), (PositionDTOWeigher.AverageLatitudeProvider)this);
        this.bearingCluster = new BearingWithConfidenceCluster(this.weigher);
    }

    public void updateWindInfo(WindInfoForRaceDTO newWindInfo) {
        this.windInfoForRace.windTrackInfoByWindSource = newWindInfo.windTrackInfoByWindSource;
        this.bearingCluster.clear();
        for (Map.Entry windSourceAndWindTrack : this.windInfoForRace.windTrackInfoByWindSource.entrySet()) {
            WindDTO timewiseClosestFixForWindSource;
            List windFixes;
            if (Util.contains((Iterable)this.windInfoForRace.windSourcesToExclude, windSourceAndWindTrack.getKey()) || (windFixes = ((WindTrackInfoDTO)windSourceAndWindTrack.getValue()).windFixes) == null || windFixes.isEmpty() || (timewiseClosestFixForWindSource = (WindDTO)windFixes.get(0)) == null) continue;
            double confidence = timewiseClosestFixForWindSource.confidence == null ? 1.0 : timewiseClosestFixForWindSource.confidence;
            this.bearingCluster.add((BearingWithConfidence)new BearingWithConfidenceImpl((Bearing)new DegreeBearingImpl(timewiseClosestFixForWindSource.dampenedTrueWindBearingDeg.doubleValue()), confidence, (Object)timewiseClosestFixForWindSource.position));
        }
        this.updateAverageLatitudeDeg(newWindInfo);
    }

    private void updateAverageLatitudeDeg(WindInfoForRaceDTO windInfoForRace) {
        for (Map.Entry windSourceAndTrack : windInfoForRace.windTrackInfoByWindSource.entrySet()) {
            for (WindDTO wind : ((WindTrackInfoDTO)windSourceAndTrack.getValue()).windFixes) {
                if (wind.position == null) continue;
                this.latitudeSum += wind.position.getLatDeg();
                ++this.latitudeCount;
            }
        }
        if (this.latitudeCount > 0L) {
            this.setAverageLatitudeDeg(this.latitudeSum / (double)this.latitudeCount);
        }
    }

    public void setAverageLatitudeDeg(double averageLatitudeDeg) {
        this.averageLatitudeCosine = Math.cos(averageLatitudeDeg / 180.0 * Math.PI);
    }

    public double getCosineOfAverageLatitude() {
        return this.averageLatitudeCosine;
    }

    public boolean inBounds(Position p) {
        return true;
    }

    public boolean inBounds(LatLng p) {
        return true;
    }

    public Vector getVector(LatLng mappedPosition, Date at) {
        Vector result;
        Position p = this.coordinateSystem.getPosition(mappedPosition);
        double speedConfidenceSum = 0.0;
        double knotSpeedSumScaledByConfidence = 0.0;
        for (Map.Entry windSourceAndWindTrack : this.windInfoForRace.windTrackInfoByWindSource.entrySet()) {
            WindDTO timewiseClosestFixForWindSource;
            List windFixes;
            if (Util.contains((Iterable)this.windInfoForRace.windSourcesToExclude, windSourceAndWindTrack.getKey()) || (windFixes = ((WindTrackInfoDTO)windSourceAndWindTrack.getValue()).windFixes) == null || windFixes.isEmpty() || (timewiseClosestFixForWindSource = (WindDTO)windFixes.get(0)) == null) continue;
            double confidence = (timewiseClosestFixForWindSource.confidence == null ? 1.0 : timewiseClosestFixForWindSource.confidence) * this.weigher.getConfidence((Object)timewiseClosestFixForWindSource.position, (Object)p);
            if (!((WindSource)windSourceAndWindTrack.getKey()).getType().useSpeed()) continue;
            speedConfidenceSum += confidence;
            knotSpeedSumScaledByConfidence += confidence * timewiseClosestFixForWindSource.dampenedTrueWindSpeedInKnots;
        }
        BearingWithConfidence bearing = this.bearingCluster.getAverage((Object)p);
        if (bearing != null && bearing.getObject() != null) {
            double mappedBearingRad = this.coordinateSystem.map((Bearing)bearing.getObject()).getRadians();
            double speedInKnots = knotSpeedSumScaledByConfidence / speedConfidenceSum;
            result = new Vector(speedInKnots * Math.sin(mappedBearingRad), speedInKnots * Math.cos(mappedBearingRad));
        } else {
            result = null;
        }
        return result;
    }

    public double getMotionScale(double zoomLevel) {
        return 2.0 * this.knotsInDegreePerFrame * Math.pow(1.8, Math.min(15.0, 20.0 - zoomLevel));
    }

    public double getParticleWeight(LatLng p, Vector v) {
        return v == null ? 0.0 : v.length() / 40.0;
    }

    public double getLineWidth(double speed) {
        return 1.2;
    }

    public LatLngBounds getFieldCorners() {
        return this.infiniteBounds;
    }

    public double getParticleFactor() {
        return 0.5;
    }
}

