/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.ui.simulator.racemap;

import com.sap.sailing.gwt.ui.simulator.racemap.TwoDSegment;
import com.sap.sailing.gwt.ui.simulator.racemap.TwoDVector;

/*
 * Exception performing whole class analysis ignored.
 */
public class TwoDPoint {
    private double x;
    private double y;

    public TwoDPoint(double x, double y) {
        this.x = x;
        this.y = y;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getDistanceTo(TwoDPoint point) {
        return TwoDPoint.distanceBetween((double)this.x, (double)this.y, (double)point.getX(), (double)point.getY());
    }

    public double getDistanceTo(double x, double y) {
        return TwoDPoint.distanceBetween((double)this.x, (double)this.y, (double)x, (double)y);
    }

    public static double distanceBetween(double x1, double y1, double x2, double y2) {
        return Math.sqrt(Math.pow(x2 - x1, 2.0) + Math.pow(y2 - y1, 2.0));
    }

    public static double distanceBetween(TwoDPoint point1, TwoDPoint point2) {
        return TwoDPoint.distanceBetween((double)point1.getX(), (double)point1.getY(), (double)point2.getX(), (double)point2.getY());
    }

    public double getDistanceTo(TwoDSegment line) {
        return this.getDistanceTo(this.getProjection(line));
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        TwoDPoint other = (TwoDPoint)obj;
        return this.x == other.getX() && this.y == other.getY();
    }

    public int hashCode() {
        return 31 * Double.valueOf(this.x).hashCode() * Double.valueOf(this.y).hashCode();
    }

    public TwoDPoint getProjection(TwoDSegment line) {
        double slope = line.getLineSlope();
        double intercept = line.getLineIntercept();
        double x = (slope * this.getY() + this.getX() - slope * intercept) / (slope * slope + 1.0);
        double y = slope * x + intercept;
        return new TwoDPoint(x, y);
    }

    public TwoDPoint getProjectionByVector(TwoDSegment line, TwoDVector vector) {
        double a = vector.getRe();
        double b = vector.getIm();
        double p = line.getLineSlope();
        double q = line.getLineIntercept();
        double x = ((q - this.y) / b + this.x / a) / (1.0 / a - p / b);
        double y = p * x + q;
        return new TwoDPoint(x, y);
    }

    private static boolean areInClockwiseOrder(TwoDPoint A, TwoDPoint B, TwoDPoint C) {
        return (C.y - A.y) * (B.x - A.x) > (B.y - A.y) * (C.x - A.x);
    }

    public static boolean areIntersecting(TwoDPoint A, TwoDPoint B, TwoDPoint C, TwoDPoint D) {
        return TwoDPoint.areInClockwiseOrder((TwoDPoint)A, (TwoDPoint)C, (TwoDPoint)D) != TwoDPoint.areInClockwiseOrder((TwoDPoint)B, (TwoDPoint)C, (TwoDPoint)D) && TwoDPoint.areInClockwiseOrder((TwoDPoint)A, (TwoDPoint)B, (TwoDPoint)C) != TwoDPoint.areInClockwiseOrder((TwoDPoint)A, (TwoDPoint)B, (TwoDPoint)D);
    }
}

