/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.ui.simulator;

import com.google.gwt.canvas.dom.client.Context2d;
import com.google.gwt.maps.client.MapWidget;
import com.google.gwt.maps.client.base.LatLng;
import com.google.gwt.maps.client.base.Point;
import com.sap.sailing.domain.common.Position;
import com.sap.sailing.domain.common.impl.DegreePosition;
import com.sap.sailing.gwt.ui.client.shared.racemap.CoordinateSystem;
import com.sap.sailing.gwt.ui.shared.WindLinesDTO;
import com.sap.sailing.gwt.ui.simulator.TimeListenerWithStoppingCriteria;
import com.sap.sailing.gwt.ui.simulator.racemap.FullCanvasOverlay;
import com.sap.sailing.gwt.ui.simulator.util.LineSegment;
import com.sap.sse.gwt.client.player.TimeListener;
import com.sap.sse.gwt.client.player.Timer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.logging.Logger;

public class WindLineCanvasOverlay
extends FullCanvasOverlay
implements TimeListenerWithStoppingCriteria {
    private WindLinesDTO windLinesDTO;
    private String lineColor = "Black";
    private final Timer timer;
    private Position[] corners;
    private LineSegment[] boundary;
    private Position center;
    private static Logger logger = Logger.getLogger(WindLineCanvasOverlay.class.getName());

    public WindLineCanvasOverlay(MapWidget map, int zIndex, Timer timer, CoordinateSystem coordinateSystem) {
        super(map, zIndex, coordinateSystem);
        this.timer = timer;
        this.windLinesDTO = null;
        this.corners = null;
        this.boundary = null;
    }

    public void timeChanged(Date newTime, Date oldTime) {
        Map windLinesMap = this.windLinesDTO.getWindLinesMap();
        if (windLinesMap == null) {
            return;
        }
        this.clear();
        Context2d context2d = this.canvas.getContext2d();
        context2d.setGlobalAlpha(0.2);
        int index = 0;
        for (Map.Entry entry : windLinesMap.entrySet()) {
            List positionToDraw = new ArrayList();
            SortedMap headMap = ((SortedMap)entry.getValue()).headMap(newTime.getTime() + 1L);
            if (!headMap.isEmpty()) {
                positionToDraw = (List)headMap.get(headMap.lastKey());
            }
            logger.info("In WindLineCanvasOverlay.drawWindField drawing " + positionToDraw.size() + " points" + " @ " + newTime);
            this.drawWindLine(positionToDraw, ++index);
        }
    }

    public boolean shallStop() {
        Map positionTimePointPositionDTOMap = this.windLinesDTO.getWindLinesMap();
        if (!this.isVisible() || positionTimePointPositionDTOMap == null || this.timer == null || positionTimePointPositionDTOMap.isEmpty()) {
            return true;
        }
        Set positions = positionTimePointPositionDTOMap.keySet();
        if (positions != null && !positions.isEmpty()) {
            SortedMap timePointPositionDTOMap = (SortedMap)positionTimePointPositionDTOMap.get(positions.iterator().next());
            return (Long)timePointPositionDTOMap.lastKey() < this.timer.getTime().getTime();
        }
        return true;
    }

    public WindLinesDTO getWindLinesDTO() {
        return this.windLinesDTO;
    }

    public void setWindLinesDTO(WindLinesDTO windLinesDTO) {
        this.windLinesDTO = windLinesDTO;
    }

    public void addToMap() {
        super.addToMap();
        if (this.timer != null) {
            this.timer.addTimeListener((TimeListener)this);
        }
    }

    public void removeFromMap() {
        super.removeFromMap();
        if (this.timer != null) {
            this.timer.removeTimeListener((TimeListener)this);
        }
    }

    protected void draw() {
        super.draw();
        if (this.getMapProjection() != null && this.windLinesDTO != null) {
            this.clear();
            this.drawWindLine();
        }
    }

    private void clear() {
        this.canvas.getContext2d().clearRect(0.0, 0.0, (double)this.canvas.getCoordinateSpaceWidth(), (double)this.canvas.getCoordinateSpaceHeight());
    }

    protected void drawWindLine() {
        if (this.timer != null) {
            this.timeChanged(this.timer.getTime(), null);
        }
    }

    protected void drawWindLine(List<Position> positionList, int index) {
        if (positionList == null) {
            return;
        }
        int numPoints = positionList.size();
        if (numPoints < 1) {
            return;
        }
        String title = "Wind line at " + numPoints + " points.";
        this.getCanvas().setTitle(title);
        Iterator<Position> positionDTOIter = positionList.iterator();
        Position prevPosition = null;
        while (positionDTOIter.hasNext()) {
            Position position = positionDTOIter.next();
            if (prevPosition != null) {
                if (this.checkPointInGrid(prevPosition) && this.checkPointInGrid(position)) {
                    this.drawLine(prevPosition, position);
                } else {
                    Position pointOnBoundary = this.getPointOnBoundary(prevPosition, position);
                    if (pointOnBoundary != null) {
                        this.drawLine(prevPosition, pointOnBoundary);
                    }
                }
            }
            prevPosition = position;
        }
    }

    private Position getPointOnBoundary(Position p1, Position p2) {
        if (this.boundary != null) {
            LineSegment line = new LineSegment(p1.getLatDeg(), p1.getLngDeg(), p2.getLatDeg(), p2.getLngDeg());
            LineSegment.Point p = line.intersect(this.boundary[0]);
            if (p != null) {
                DegreePosition pDTO = new DegreePosition(p.getX(), p.getY());
                return pDTO;
            }
            p = line.intersect(this.boundary[2]);
            if (p != null) {
                DegreePosition pDTO = new DegreePosition(p.getX(), p.getY());
                return pDTO;
            }
            p = line.intersect(this.boundary[1]);
            if (p != null) {
                DegreePosition pDTO = new DegreePosition(p.getX(), p.getY());
                return pDTO;
            }
            p = line.intersect(this.boundary[3]);
            if (p != null) {
                DegreePosition pDTO = new DegreePosition(p.getX(), p.getY());
                return pDTO;
            }
        }
        return null;
    }

    private void drawLine(Position p1, Position p2) {
        double weight = 1.0;
        LatLng positionLatLng = this.coordinateSystem.toLatLng(p1);
        Point canvasPositionInPx = this.getMapProjection().fromLatLngToDivPixel(positionLatLng);
        double x1 = canvasPositionInPx.getX() - this.getWidgetPosLeft();
        double y1 = canvasPositionInPx.getY() - this.getWidgetPosTop();
        positionLatLng = this.coordinateSystem.toLatLng(p2);
        canvasPositionInPx = this.getMapProjection().fromLatLngToDivPixel(positionLatLng);
        double x2 = canvasPositionInPx.getX() - this.getWidgetPosLeft();
        double y2 = canvasPositionInPx.getY() - this.getWidgetPosTop();
        this.drawLine(x1, y1, x2, y2, 1.0, this.lineColor);
    }

    public void setGridCorners(Position[] gridCorners) {
        this.corners = gridCorners;
        if (this.corners != null && this.corners.length == 4) {
            this.boundary = new LineSegment[4];
            this.boundary[0] = new LineSegment(this.corners[0].getLatDeg(), this.corners[0].getLngDeg(), this.corners[1].getLatDeg(), this.corners[1].getLngDeg());
            this.boundary[1] = new LineSegment(this.corners[1].getLatDeg(), this.corners[1].getLngDeg(), this.corners[2].getLatDeg(), this.corners[2].getLngDeg());
            this.boundary[2] = new LineSegment(this.corners[2].getLatDeg(), this.corners[2].getLngDeg(), this.corners[3].getLatDeg(), this.corners[3].getLngDeg());
            this.boundary[3] = new LineSegment(this.corners[3].getLatDeg(), this.corners[3].getLngDeg(), this.corners[0].getLatDeg(), this.corners[0].getLngDeg());
            this.center = this.getCenter();
        }
    }

    private Point getPointInDivPixel(Position p) {
        LatLng pLatLng = LatLng.newInstance((double)p.getLatDeg(), (double)p.getLngDeg());
        Point canvasPositionInPx = this.getMapProjection().fromLatLngToDivPixel(pLatLng);
        return Point.newInstance((double)canvasPositionInPx.getX(), (double)canvasPositionInPx.getY());
    }

    public void setCanvasSettings() {
        if (this.corners != null && this.corners.length == 4) {
            Point corner0 = this.getPointInDivPixel(this.corners[0]);
            Point corner1 = this.getPointInDivPixel(this.corners[1]);
            Point corner3 = this.getPointInDivPixel(this.corners[3]);
            int canvasWidth = (int)Math.sqrt(Math.pow(corner0.getX() - corner1.getX(), 2.0) + Math.pow(corner0.getY() - corner1.getY(), 2.0));
            int canvasHeight = (int)Math.sqrt(Math.pow(corner3.getX() - corner0.getX(), 2.0) + Math.pow(corner3.getY() - corner0.getY(), 2.0));
            int canvasRadius = (int)Math.sqrt(canvasWidth * canvasWidth / 4 + canvasHeight * canvasHeight / 4);
            this.canvas.setSize(2 * canvasRadius + "px", 2 * canvasRadius + "px");
            this.canvas.setCoordinateSpaceWidth(2 * canvasRadius);
            this.canvas.setCoordinateSpaceHeight(2 * canvasRadius);
            Point anchorPoint = this.getAnchorPoint();
            this.setWidgetPosLeft(anchorPoint.getX());
            this.setWidgetPosTop(anchorPoint.getY());
            this.setCanvasPosition(anchorPoint.getX(), anchorPoint.getY());
        }
    }

    private Point getAnchorPoint() {
        if (this.corners != null) {
            LinkedList<Double> xlist = new LinkedList<Double>();
            LinkedList<Double> ylist = new LinkedList<Double>();
            int i = 0;
            while (i < this.corners.length) {
                Point corner = this.getPointInDivPixel(this.corners[i]);
                xlist.add(corner.getX());
                ylist.add(corner.getY());
                ++i;
            }
            return Point.newInstance((double)((Double)Collections.min(xlist)), (double)((Double)Collections.min(ylist)));
        }
        return null;
    }

    private Position getCenter() {
        DegreePosition center = this.corners != null && this.corners.length == 4 ? new DegreePosition((this.corners[0].getLatDeg() + this.corners[1].getLatDeg() + this.corners[2].getLatDeg() + this.corners[3].getLatDeg()) / 4.0, (this.corners[0].getLngDeg() + this.corners[1].getLngDeg() + this.corners[2].getLngDeg() + this.corners[3].getLngDeg()) / 4.0) : null;
        return center;
    }

    private boolean checkPointInGrid(Position point) {
        if (this.center != null) {
            Position pointOnBoundary = this.getPointOnBoundary(this.center, point);
            if (pointOnBoundary == null) {
                return true;
            }
            return pointOnBoundary.equals(point);
        }
        return false;
    }
}

