/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.ui.shared.racemap;

import com.google.gwt.canvas.dom.client.Context2d;
import com.sap.sailing.domain.common.LegType;
import com.sap.sailing.domain.common.MarkType;
import com.sap.sailing.domain.common.PassingInstruction;
import com.sap.sailing.domain.common.Position;
import com.sap.sailing.domain.common.impl.MeterDistance;
import com.sap.sailing.gwt.ui.shared.CoursePositionsDTO;
import com.sap.sailing.gwt.ui.shared.MarkDTO;
import com.sap.sailing.gwt.ui.shared.WaypointDTO;
import com.sap.sailing.gwt.ui.shared.racemap.AbstractMarkVectorGraphics;
import com.sap.sse.common.Bearing;
import com.sap.sse.common.Color;
import com.sap.sse.common.Distance;
import com.sap.sse.common.impl.DegreeBearingImpl;
import java.util.Iterator;

public class BoatMarkVectorGraphics
extends AbstractMarkVectorGraphics {
    private static final Distance BOAT_MARK_HEIGHT_IN_METERS = new MeterDistance(6.2);
    private static final Distance BOAT_MARK_WIDTH_IN_METERS = new MeterDistance(3.5);
    private static final double BOAT_MARK_SELECTION_SCALE = 3.5;
    private static final double BOAT_MARK_SELECTION_TRANSLATE_X = 50.0;
    private static final double BOAT_MARK_SELECTION_TRANSLATE_Y = -130.0;
    private final String markIdAsString;

    public BoatMarkVectorGraphics(MarkType type, Color color, String shape, String pattern, String markIdAsString) {
        super(type, color, shape, pattern);
        this.anchorPointX = BOAT_MARK_HEIGHT_IN_METERS.getMeters() / 2.0;
        this.anchorPointY = BOAT_MARK_WIDTH_IN_METERS.getMeters() / 2.0;
        this.markHeightInMeters = BOAT_MARK_HEIGHT_IN_METERS;
        this.markWidthInMeters = BOAT_MARK_WIDTH_IN_METERS;
        this.markIdAsString = markIdAsString;
    }

    protected void setUpScaleAndTranslateForMarkSelection(Context2d ctx) {
        ctx.scale(3.5, 3.5);
        ctx.translate(50.0, -130.0);
    }

    protected void drawMarkBody(Context2d ctx, boolean isSelected, String color) {
        ctx.beginPath();
        ctx.setFillStyle("#000000");
        ctx.setStrokeStyle("#FFFFFF");
        ctx.setLineWidth(30.0);
        ctx.setLineCap("butt");
        ctx.setLineJoin("miter");
        ctx.setMiterLimit(3.0);
        ctx.moveTo(35.0, 185.0);
        ctx.lineTo(35.0, 35.0);
        ctx.quadraticCurveTo(100.0, 20.0, 200.0, 20.0);
        ctx.quadraticCurveTo(285.0, 20.0, 370.0, 35.0);
        ctx.quadraticCurveTo(455.0, 50.0, 520.0, 90.0);
        ctx.quadraticCurveTo(585.0, 127.0, 600.0, 185.0);
        ctx.quadraticCurveTo(585.0, 243.0, 520.0, 280.0);
        ctx.quadraticCurveTo(455.0, 320.0, 370.0, 335.0);
        ctx.quadraticCurveTo(285.0, 350.0, 200.0, 350.0);
        ctx.quadraticCurveTo(100.0, 350.0, 35.0, 335.0);
        ctx.lineTo(35.0, 185.0);
        ctx.fill();
        ctx.stroke();
        ctx.setFillStyle("#FFFFFF");
        ctx.beginPath();
        ctx.setLineWidth(1.0);
        ctx.setLineJoin("miter");
        ctx.setMiterLimit(4.0);
        ctx.moveTo(75.0, 75.0);
        ctx.lineTo(350.0, 75.0);
        ctx.lineTo(350.0, 295.0);
        ctx.lineTo(75.0, 295.0);
        ctx.lineTo(75.0, 75.0);
        ctx.fill();
        ctx.stroke();
        ctx.setFillStyle("#000000");
        ctx.beginPath();
        ctx.moveTo(337.0, 186.36);
        ctx.arc(300.0, 185.0, 35.0, 0.0, Math.PI * 2);
        ctx.stroke();
        ctx.fill();
        ctx.beginPath();
    }

    public Bearing getRotationInDegrees(CoursePositionsDTO coursePositionsDTO) {
        MarkDTO firstMark = null;
        MarkDTO secondMark = null;
        boolean isStart = true;
        Position previousWaypointPosition = null;
        Iterator waypointPosIter = coursePositionsDTO.waypointPositions.iterator();
        Position currentWaypointPosition = waypointPosIter.hasNext() ? (Position)waypointPosIter.next() : null;
        Iterator waypointIter = coursePositionsDTO.course.waypoints.iterator();
        while (waypointIter.hasNext()) {
            boolean isFinish;
            WaypointDTO currentWaypoint = (WaypointDTO)waypointIter.next();
            Position nextWaypointPosition = waypointPosIter.hasNext() ? (Position)waypointPosIter.next() : null;
            boolean bl = isFinish = !waypointIter.hasNext();
            if (currentWaypoint.passingInstructions == PassingInstruction.Line) {
                Iterator marks = currentWaypoint.controlPoint.getMarks().iterator();
                firstMark = (MarkDTO)marks.next();
                if (marks.hasNext()) {
                    secondMark = (MarkDTO)marks.next();
                    if (this.markIdAsString.equals(firstMark.getIdAsString())) {
                        return this.getLineBearing(firstMark.position, secondMark.position, isStart, coursePositionsDTO.startLineAngleFromPortToStarboardWhenApproachingLineToCombinedWind, nextWaypointPosition, isFinish, coursePositionsDTO.finishLineAngleFromPortToStarboardWhenApproachingLineToCombinedWind, previousWaypointPosition, true);
                    }
                    if (this.markIdAsString.equals(secondMark.getIdAsString())) {
                        return this.getLineBearing(secondMark.position, firstMark.position, isStart, coursePositionsDTO.startLineAngleFromPortToStarboardWhenApproachingLineToCombinedWind, nextWaypointPosition, isFinish, coursePositionsDTO.finishLineAngleFromPortToStarboardWhenApproachingLineToCombinedWind, previousWaypointPosition, false);
                    }
                }
            }
            isStart = false;
            previousWaypointPosition = currentWaypointPosition;
            currentWaypointPosition = nextWaypointPosition;
        }
        return null;
    }

    private Bearing getLineBearing(Position boatMarkPosition, Position pinEndPosition, boolean isStart, Double startLineAngleFromPortToStarboardWhenApproachingLineToCombinedWind, Position nextWaypointPosition, boolean isFinish, Double finishLineAngleFromPortToStarboardWhenApproachingLineToCombinedWind, Position previousWaypointPosition, boolean boatIsFirstMark) {
        Bearing result;
        Bearing bearingFromBoatMarkToPinEnd = boatMarkPosition.getBearingGreatCircle(pinEndPosition);
        if (isStart) {
            if (nextWaypointPosition == null) {
                result = null;
            } else if (this.isReach(startLineAngleFromPortToStarboardWhenApproachingLineToCombinedWind)) {
                result = this.bearingOrReverseDependingOnXTEToOther(boatMarkPosition, bearingFromBoatMarkToPinEnd, nextWaypointPosition);
            } else {
                boolean pinEndOnPortWhenApproachingLine = pinEndPosition.crossTrackError(boatMarkPosition, boatMarkPosition.getBearingGreatCircle(nextWaypointPosition)).compareTo((Object)Distance.NULL) < 0;
                result = this.getWindFrom(startLineAngleFromPortToStarboardWhenApproachingLineToCombinedWind, bearingFromBoatMarkToPinEnd, pinEndOnPortWhenApproachingLine).add((Bearing)new DegreeBearingImpl(-90.0));
            }
        } else if (previousWaypointPosition == null) {
            result = null;
        } else if (this.isReach(finishLineAngleFromPortToStarboardWhenApproachingLineToCombinedWind)) {
            result = bearingFromBoatMarkToPinEnd == null ? null : this.bearingOrReverseDependingOnXTEToOther(pinEndPosition, bearingFromBoatMarkToPinEnd.reverse(), previousWaypointPosition);
        } else {
            boolean pinEndOnPortWhenApproachingLine = pinEndPosition.crossTrackError(previousWaypointPosition, previousWaypointPosition.getBearingGreatCircle(boatMarkPosition)).compareTo((Object)Distance.NULL) < 0;
            result = this.getWindFrom(finishLineAngleFromPortToStarboardWhenApproachingLineToCombinedWind, bearingFromBoatMarkToPinEnd, pinEndOnPortWhenApproachingLine).add((Bearing)new DegreeBearingImpl(-90.0));
        }
        return result;
    }

    private Bearing getWindFrom(Double lineAngleFromPortToStarboardWhenApproachingLineToCombinedWind, Bearing bearingFromBoatMarkToPinEnd, boolean pinEndOnPortWhenApproachingLine) {
        Bearing windFrom = pinEndOnPortWhenApproachingLine ? bearingFromBoatMarkToPinEnd.reverse().add((Bearing)new DegreeBearingImpl(lineAngleFromPortToStarboardWhenApproachingLineToCombinedWind.doubleValue())) : bearingFromBoatMarkToPinEnd.add((Bearing)new DegreeBearingImpl(lineAngleFromPortToStarboardWhenApproachingLineToCombinedWind.doubleValue()));
        return windFrom;
    }

    private Bearing bearingOrReverseDependingOnXTEToOther(Position pos, Bearing bearing, Position other) {
        Bearing result = bearing == null ? pos.getBearingGreatCircle(other).add((Bearing)new DegreeBearingImpl(-90.0)) : (pos.crossTrackError(other, bearing).compareTo((Object)Distance.NULL) > 0 ? bearing.reverse() : bearing);
        return result;
    }

    private boolean isReach(Double lineAngleToCombinedWind) {
        return lineAngleToCombinedWind == null || Math.abs(90.0 - Math.abs(lineAngleToCombinedWind)) > LegType.UPWIND_DOWNWIND_TOLERANCE_IN_DEG;
    }
}

